/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.grid.columns;

import java.util.HashMap;
import java.util.Map;
import org.jooq.Field;
import org.jooq.SortField;
import org.jooq.impl.DSL;
import org.squashtest.tm.domain.Level;
import org.squashtest.tm.service.internal.display.grid.GridSort;
import org.squashtest.tm.service.internal.display.grid.columns.GridColumn;

public class LevelEnumColumn
extends GridColumn {
    private Class<? extends Level> levelEnum;

    public LevelEnumColumn(Class<? extends Level> levelEnum, String alias) {
        this(levelEnum, (Field<String>)DSL.field((String)alias, String.class));
    }

    public LevelEnumColumn(Class<? extends Level> levelEnum, Field<String> field) {
        super(field);
        this.levelEnum = levelEnum;
    }

    @Override
    public SortField<?> generateOrderClause(GridSort.SortDirection direction) {
        Map<String, Integer> sortMap = this.getAscSortMap();
        if (direction.equals((Object)GridSort.SortDirection.DESC)) {
            sortMap.keySet().forEach(key -> {
                Integer n = sortMap.put((String)key, (Integer)sortMap.get(key) * -1);
            });
        }
        return this.aliasedField.sort(sortMap);
    }

    public Map<String, Integer> getAscSortMap() {
        HashMap<String, Integer> sortMap = new HashMap<String, Integer>();
        Level[] levelArray = this.levelEnum.getEnumConstants();
        int n = levelArray.length;
        int n2 = 0;
        while (n2 < n) {
            Level level = levelArray[n2];
            sortMap.put(level.toString(), level.getLevel());
            ++n2;
        }
        return sortMap;
    }
}

