/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.customreport;

import java.util.Arrays;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.Workspace;
import org.squashtest.tm.domain.users.preferences.CorePartyPreference;
import org.squashtest.tm.service.display.customreport.DashboardDisplayService;
import org.squashtest.tm.service.internal.repository.display.PartyPreferenceDisplayDao;
import org.squashtest.tm.service.user.UserAccountService;

@Service
@Transactional(readOnly=true)
public class DashboardDisplayServiceImpl
implements DashboardDisplayService {
    private UserAccountService userAccountService;
    private PartyPreferenceDisplayDao partyPreferenceDisplayDao;

    public DashboardDisplayServiceImpl(UserAccountService userAccountService, PartyPreferenceDisplayDao partyPreferenceDisplayDao) {
        this.userAccountService = userAccountService;
        this.partyPreferenceDisplayDao = partyPreferenceDisplayDao;
    }

    @Override
    public List<Workspace> findFavoriteWorkspaceForDashboardAndCurrentUser(Long dashboardId) {
        Long userId = this.userAccountService.findCurrentUser().getId();
        List<String> preferenceKeys = this.partyPreferenceDisplayDao.findPreferenceKeysForFavoriteDashboardAndUser(dashboardId, userId);
        List<CorePartyPreference> corePartyPreferences = Arrays.stream(CorePartyPreference.values()).filter(preference -> preferenceKeys.contains(preference.getPreferenceKey())).toList();
        return corePartyPreferences.stream().map(this::getFavoriteWorkspace).toList();
    }

    private Workspace getFavoriteWorkspace(CorePartyPreference preference) {
        return switch (preference) {
            case CorePartyPreference.FAVORITE_DASHBOARD_HOME -> Workspace.HOME;
            case CorePartyPreference.FAVORITE_DASHBOARD_CAMPAIGN -> Workspace.CAMPAIGN;
            case CorePartyPreference.FAVORITE_DASHBOARD_REQUIREMENT -> Workspace.REQUIREMENT;
            case CorePartyPreference.FAVORITE_DASHBOARD_TEST_CASE -> Workspace.TEST_CASE;
            default -> throw new IllegalArgumentException("This preference is not a favorite dashboard pref " + preference.getPreferenceKey());
        };
    }
}

