/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.deletion.jdbc;

import jakarta.persistence.EntityManager;
import java.util.Collection;
import java.util.UUID;
import org.jooq.DSLContext;
import org.springframework.stereotype.Component;
import org.squashtest.tm.service.campaign.CustomTestSuiteModificationService;
import org.squashtest.tm.service.internal.attachment.AttachmentRepository;
import org.squashtest.tm.service.internal.deletion.jdbc.JdbcBatchReorderHelper;
import org.squashtest.tm.service.internal.deletion.jdbc.JdbcTestPlanItemDeletionHandler;

@Component
public class JdbcTestPlanItemDeletionHandlerFactory {
    private final DSLContext dslContext;
    private final EntityManager entityManager;
    private final AttachmentRepository attachmentRepository;
    private final JdbcBatchReorderHelper reorderHelper;
    private final CustomTestSuiteModificationService testSuiteModificationService;

    public JdbcTestPlanItemDeletionHandlerFactory(DSLContext dslContext, EntityManager entityManager, AttachmentRepository attachmentRepository, JdbcBatchReorderHelper reorderHelper, CustomTestSuiteModificationService testSuiteModificationService) {
        this.dslContext = dslContext;
        this.entityManager = entityManager;
        this.attachmentRepository = attachmentRepository;
        this.reorderHelper = reorderHelper;
        this.testSuiteModificationService = testSuiteModificationService;
    }

    public JdbcTestPlanItemDeletionHandler build(Collection<Long> testPlanItemIds) {
        return this.build(testPlanItemIds, UUID.randomUUID().toString());
    }

    public JdbcTestPlanItemDeletionHandler build(Collection<Long> testPlanItemIds, String operationId) {
        return new JdbcTestPlanItemDeletionHandler(testPlanItemIds, this.dslContext, this.entityManager, this.attachmentRepository, this.reorderHelper, this.testSuiteModificationService, operationId);
    }
}

