/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.annotation;

import java.util.function.BooleanSupplier;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Component;
import org.squashtest.tm.service.license.UltimateLicenseAvailabilityService;
import org.squashtest.tm.service.plugin.PluginFinderService;

@Aspect
@Component
public class IsLicenseAvailableAspect {
    private final UltimateLicenseAvailabilityService ultimateLicenseAvailabilityService;
    private final PluginFinderService pluginFinderService;

    public IsLicenseAvailableAspect(UltimateLicenseAvailabilityService ultimateLicenseAvailabilityService, PluginFinderService pluginFinderService) {
        this.ultimateLicenseAvailabilityService = ultimateLicenseAvailabilityService;
        this.pluginFinderService = pluginFinderService;
    }

    @Around(value="@annotation(IsUltimateLicenseAvailable)")
    public Object checkUltimateLicense(ProceedingJoinPoint joinPoint) throws Throwable {
        return this.checkLicense(joinPoint, this.ultimateLicenseAvailabilityService::isAvailable, "Ultimate");
    }

    @Around(value="@annotation(IsPremiumLicenseAvailable) || @within(IsPremiumLicenseAvailable)")
    public Object checkPremiumLicense(ProceedingJoinPoint joinPoint) throws Throwable {
        return this.checkLicense(joinPoint, this.pluginFinderService::isPremiumPluginInstalled, "Premium");
    }

    private Object checkLicense(ProceedingJoinPoint joinPoint, BooleanSupplier licenseCheck, String licenseType) throws Throwable {
        if (!licenseCheck.getAsBoolean()) {
            throw new AccessDeniedException("Forbidden %d %s License Not Available".formatted(HttpStatus.FORBIDDEN.value(), licenseType));
        }
        return joinPoint.proceed();
    }
}

