/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl.collectors.libraries;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.NodeReference;
import org.squashtest.tm.domain.NodeType;
import org.squashtest.tm.domain.actionword.ActionWordTreeDefinition;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.records.ProjectRecord;
import org.squashtest.tm.service.internal.display.grid.DataRow;
import org.squashtest.tm.service.internal.repository.display.CustomFieldValueDisplayDao;
import org.squashtest.tm.service.internal.repository.display.MilestoneDisplayDao;
import org.squashtest.tm.service.internal.repository.display.TreeNodeCollector;
import org.squashtest.tm.service.internal.repository.display.impl.collectors.libraries.AbstractLibraryCollector;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;

@Component
public class ActionWordLibraryCollector
extends AbstractLibraryCollector
implements TreeNodeCollector {
    public ActionWordLibraryCollector(DSLContext dsl, CustomFieldValueDisplayDao customFieldValueDisplayDao, ActiveMilestoneHolder activeMilestoneHolder, MilestoneDisplayDao milestoneDisplayDao) {
        super(dsl, customFieldValueDisplayDao, activeMilestoneHolder, milestoneDisplayDao);
    }

    @Override
    protected Map<Long, DataRow> doCollect(List<Long> ids) {
        Map<Long, DataRow> libraryRows = this.dsl.select((SelectField)Tables.PROJECT.PROJECT_ID.as("projectId"), (SelectField)Tables.PROJECT.NAME, (SelectField)Tables.ACTION_WORD_LIBRARY_NODE.AWLN_ID, (SelectField)Tables.ACTION_WORD_LIBRARY.AWL_ID, (SelectField)DSL.count((Field)Tables.AWLN_RELATIONSHIP.DESCENDANT_ID).as("CHILD_COUNT")).from((TableLike)Tables.ACTION_WORD_LIBRARY_NODE).innerJoin((TableLike)Tables.ACTION_WORD_LIBRARY).on(Tables.ACTION_WORD_LIBRARY_NODE.AWL_ID.eq((Field)Tables.ACTION_WORD_LIBRARY.AWL_ID)).and(Tables.ACTION_WORD_LIBRARY_NODE.ENTITY_TYPE.eq((Object)ActionWordTreeDefinition.LIBRARY.name())).innerJoin((TableLike)Tables.PROJECT).on(Tables.PROJECT.AWL_ID.eq((Field)Tables.ACTION_WORD_LIBRARY.AWL_ID)).leftJoin((TableLike)Tables.AWLN_RELATIONSHIP).on(Tables.AWLN_RELATIONSHIP.ANCESTOR_ID.eq((Field)Tables.ACTION_WORD_LIBRARY_NODE.AWLN_ID)).where(Tables.ACTION_WORD_LIBRARY_NODE.AWLN_ID.in(ids)).groupBy(new GroupField[]{Tables.ACTION_WORD_LIBRARY_NODE.AWLN_ID, Tables.ACTION_WORD_LIBRARY.AWL_ID, Tables.PROJECT.PROJECT_ID, Tables.AWLN_RELATIONSHIP.ANCESTOR_ID}).fetch().stream().collect(Collectors.toMap(tuple -> (Long)tuple.get((Field)Tables.ACTION_WORD_LIBRARY_NODE.AWLN_ID), tuple -> {
            DataRow dataRow = new DataRow();
            dataRow.setId(new NodeReference(this.getHandledEntityType(), (Long)tuple.get((Field)Tables.ACTION_WORD_LIBRARY_NODE.AWLN_ID)).toNodeId());
            dataRow.setProjectId((Long)tuple.get("projectId", Long.class));
            dataRow.setState((Integer)tuple.get("CHILD_COUNT", Integer.class) > 0 ? DataRow.State.closed : DataRow.State.leaf);
            dataRow.setData(tuple.intoMap());
            return dataRow;
        }));
        this.appendMilestonesByProject(libraryRows);
        return libraryRows;
    }

    @Override
    protected TableField<ProjectRecord, Long> getLibraryColumnInProjectTable() {
        return Tables.PROJECT.AWL_ID;
    }

    @Override
    protected Field<Long> getLibraryIdColumnInContentTable() {
        return Tables.AWLN_RELATIONSHIP.ANCESTOR_ID;
    }

    @Override
    protected Field<Long> getContentIdColumnInContentTable() {
        return Tables.AWLN_RELATIONSHIP.DESCENDANT_ID;
    }

    @Override
    protected Table<?> getLibraryContentTable() {
        return Tables.AWLN_RELATIONSHIP;
    }

    @Override
    protected Table<?> getLibraryTable() {
        return Tables.ACTION_WORD_LIBRARY;
    }

    @Override
    protected TableField<?, Long> getLibraryPrimaryKeyColumn() {
        return Tables.ACTION_WORD_LIBRARY.AWL_ID;
    }

    @Override
    public NodeType getHandledEntityType() {
        return NodeType.ACTION_WORD_LIBRARY;
    }
}

