/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.milestone;

import jakarta.inject.Inject;
import jakarta.transaction.Transactional;
import java.util.Collections;
import java.util.List;
import org.jooq.DSLContext;
import org.springframework.stereotype.Service;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.service.annotation.CheckEntityExists;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.display.milestone.MilestoneDisplayService;
import org.squashtest.tm.service.internal.display.dto.MilestoneAdminViewDto;
import org.squashtest.tm.service.internal.display.dto.MilestoneDto;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.internal.display.grid.administration.MilestoneGrid;
import org.squashtest.tm.service.internal.dto.UserDto;
import org.squashtest.tm.service.internal.repository.display.MilestoneDisplayDao;
import org.squashtest.tm.service.milestone.MilestoneManagerService;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.user.UserAccountService;

@Service
@Transactional
public class MilestoneDisplayServiceImpl
implements MilestoneDisplayService {
    private final DSLContext dsl;
    private final MilestoneDisplayDao milestoneDisplayDao;
    private final UserAccountService userAccountService;
    private final MilestoneManagerService milestoneManagerService;
    private final PermissionEvaluationService permissionEvaluationService;

    @Inject
    MilestoneDisplayServiceImpl(DSLContext dsl, UserAccountService userAccountService, MilestoneDisplayDao milestoneDisplayDao, MilestoneManagerService milestoneManagerService, PermissionEvaluationService permissionEvaluationService) {
        this.userAccountService = userAccountService;
        this.milestoneDisplayDao = milestoneDisplayDao;
        this.dsl = dsl;
        this.milestoneManagerService = milestoneManagerService;
        this.permissionEvaluationService = permissionEvaluationService;
    }

    @Override
    public GridResponse findAll(GridRequest request) {
        UserDto currentUser = this.userAccountService.findCurrentUserDto();
        if (!currentUser.isAdmin()) {
            this.permissionEvaluationService.checkAtLeastOneMilestoneManagementPermissionOrAdmin(currentUser.getPartyIds());
        }
        Long userId = currentUser.getUserId();
        MilestoneGrid milestoneGrid = new MilestoneGrid(userId, currentUser.isAdmin());
        GridResponse response = milestoneGrid.getRows(request, this.dsl);
        response.sanitizeField("description");
        return response;
    }

    @Override
    @CheckEntityExists(entityType=Milestone.class)
    public MilestoneAdminViewDto getMilestoneView(@Id long milestoneId) {
        this.milestoneManagerService.checkIfCanManageMilestonesOrAdmin(Collections.singletonList(milestoneId));
        List<MilestoneDto> milestones = this.milestoneDisplayDao.findByIds(Collections.singleton(milestoneId));
        MilestoneAdminViewDto milestoneAdminViewDto = MilestoneAdminViewDto.fromMilestoneDto(milestones.get(0));
        milestoneAdminViewDto.setCanEdit(this.milestoneManagerService.canEditMilestone(milestoneId));
        this.milestoneDisplayDao.appendBoundProjectsToMilestoneInformation(milestoneAdminViewDto);
        return milestoneAdminViewDto;
    }
}

