/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.deletion;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.NodeReference;
import org.squashtest.tm.service.internal.deletion.NodeScope;
import org.squashtest.tm.service.internal.deletion.NodeScopeType;
import org.squashtest.tm.service.internal.repository.hibernate.TestCaseBinDao;

@Component
public class NodeScopeFactory {
    private final TestCaseBinDao testCaseBinDao;

    public NodeScopeFactory(TestCaseBinDao testCaseBinDao) {
        this.testCaseBinDao = testCaseBinDao;
    }

    public NodeScope fromNodeIds(List<String> scopes) {
        Set<NodeReference> references = NodeScopeFactory.convertToReferences(scopes);
        return this.fromNodeReferences(references);
    }

    public NodeScope fromNodeReferences(Set<NodeReference> references) {
        Objects.requireNonNull(references, "references cannot be null");
        Map partitioned = references.stream().collect(Collectors.partitioningBy(ref -> NodeScopeType.NODE.isCompatibleWith(ref.getNodeType()), Collectors.toSet()));
        Set<NodeReference> nodes = partitioned.getOrDefault(true, Set.of());
        Set notNodes = partitioned.getOrDefault(false, Set.of());
        Set<NodeReference> filteredNodes = this.filterNodeReferences(nodes);
        HashSet<NodeReference> filteredReferences = new HashSet<NodeReference>(filteredNodes);
        filteredReferences.addAll(notNodes);
        return NodeScope.of(filteredReferences);
    }

    private Set<NodeReference> filterNodeReferences(Set<NodeReference> references) {
        Set<Long> filteredIds = this.testCaseBinDao.filterHighestParentNodeIds(references);
        return references.stream().filter(ref -> filteredIds.contains(ref.getId())).collect(Collectors.toSet());
    }

    private static Set<NodeReference> convertToReferences(List<String> sources) {
        Objects.requireNonNull(sources, "sources cannot be null");
        return sources.stream().map(NodeReference::fromNodeId).collect(Collectors.toSet());
    }
}

