/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.customreport;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.SelectJoinStep;
import org.jooq.SelectSelectStep;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.springframework.stereotype.Service;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.customreport.CustomExportColumnLabel;
import org.squashtest.tm.domain.customreport.CustomReportCustomExport;
import org.squashtest.tm.domain.customreport.CustomReportCustomExportColumn;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.Execution;
import org.squashtest.tm.jooq.domain.tables.Iteration;
import org.squashtest.tm.service.customreport.CustomReportCustomExportCSVService;
import org.squashtest.tm.service.internal.repository.display.utils.ConditionsConstants;

@Service
public class CustomReportCustomExportCSVServiceImpl
implements CustomReportCustomExportCSVService {
    private static final String ES_VS = "es_vs";
    private static final String CAMPAIGN_ITPI_DONE = "campaign_itpi_done";
    private static final String CAMPAIGN_ITPI_TOTAL = "campaign_itpi_total";
    @Inject
    private DSLContext dslContext;

    @Override
    public Map<Long, Result<Record>> getRowsData(CustomReportCustomExport customExport, Set<EntityType> cufEntityList, boolean restrainToLastExecution) {
        List selectedColumns = customExport.getColumns();
        List<EntityType> fullEntityList = this.getEntityTypeList(restrainToLastExecution, selectedColumns);
        List<Field<?>> fieldsList = this.getFieldsList(cufEntityList, selectedColumns);
        List entities = customExport.getScope();
        return this.fetchData(entities, fieldsList, fullEntityList, selectedColumns, restrainToLastExecution);
    }

    private List<EntityType> getEntityTypeList(boolean restrainToLastExecution, List<CustomReportCustomExportColumn> selectedColumns) {
        List<EntityType> fullEntityList = selectedColumns.stream().map(column -> column.getLabel().getEntityType()).distinct().collect(Collectors.toList());
        if (restrainToLastExecution && !fullEntityList.contains(EntityType.EXECUTION)) {
            fullEntityList.add(EntityType.EXECUTION);
        }
        return fullEntityList;
    }

    private List<Field<?>> getFieldsList(Set<EntityType> cufEntityList, List<CustomReportCustomExportColumn> selectedColumns) {
        List<Field<?>> fieldsList = selectedColumns.stream().filter(column -> column.getLabel().getJooqTableField() != null).map(column -> column.getLabel().getJooqTableField()).collect(Collectors.toList());
        for (EntityType entityType : cufEntityList) {
            Field entityIdTableField = (Field)CustomExportColumnLabel.getEntityTypeToIdTableFieldMap().get(entityType);
            if (fieldsList.contains(entityIdTableField)) continue;
            fieldsList.add(entityIdTableField);
        }
        if (!fieldsList.contains(Tables.CAMPAIGN.CLN_ID)) {
            fieldsList.add((Field<?>)Tables.CAMPAIGN.CLN_ID);
        }
        return fieldsList;
    }

    private Map<Long, Result<Record>> fetchData(List<EntityReference> entities, Collection<Field<?>> fieldList, List<EntityType> fullEntityList, List<CustomReportCustomExportColumn> selectedColumns, boolean printLastExec) {
        int queryDepth = this.getQueryDepth(fullEntityList);
        boolean isTestSuiteRequested = fullEntityList.contains(EntityType.TEST_SUITE);
        boolean isGroupByAndOrderByExecutionStepIdNeeded = this.checkGroupByAndOrderByExecutionStepIdNeeded(selectedColumns, queryDepth, fullEntityList);
        Map<EntityType, Boolean> selectedEntityTypeMap = this.getSelectedEntityTypeMap(entities.stream().map(EntityReference::getType).toList());
        SelectSelectStep selectQuery = this.dslContext.select(fieldList);
        SelectJoinStep<Record> fromQuery = this.buildFromClauseOfMainQuery(fieldList, isTestSuiteRequested, selectedEntityTypeMap, queryDepth, (SelectSelectStep<Record>)selectQuery);
        Map<TableField<?, Long>, List<Long>> selectedTableFieldMap = this.getTableFieldListMap(entities);
        Condition condition = this.buildCondition(selectedTableFieldMap, printLastExec);
        Set<Field<?>> defaultGroupAndOrderByFieldList = this.buildDefaultGroupAndOrderByFieldList(queryDepth, isTestSuiteRequested, isGroupByAndOrderByExecutionStepIdNeeded);
        fromQuery.where(condition).groupBy(this.appendRequiredGroupByFields(defaultGroupAndOrderByFieldList, selectedColumns)).orderBy(defaultGroupAndOrderByFieldList);
        return fromQuery.fetchGroups((Field)Tables.CAMPAIGN.CLN_ID);
    }

    private Map<TableField<?, Long>, List<Long>> getTableFieldListMap(List<EntityReference> entities) {
        Map entityMap = CustomExportColumnLabel.getSelectableEntityTypeToIdTableFieldMap();
        HashMap selectedTableFieldMap = new HashMap();
        entities.forEach(entityReference -> this.appendTableField(entityMap, selectedTableFieldMap, (EntityReference)entityReference));
        return selectedTableFieldMap;
    }

    private void appendTableField(Map<EntityType, TableField<?, Long>> entityMap, Map<TableField<?, Long>, List<Long>> selectedTableFieldMap, EntityReference entityReference) {
        TableField field = entityMap.getOrDefault(entityReference.getType(), null);
        if (Objects.isNull(field)) {
            throw new IllegalArgumentException("Entity of type " + entityReference.getType().name() + " is not supported");
        }
        selectedTableFieldMap.computeIfAbsent(field, k -> new ArrayList()).add(entityReference.getId());
    }

    private Condition buildCondition(Map<TableField<?, Long>, List<Long>> fields, boolean printLastExec) {
        Condition condition = null;
        for (Map.Entry<TableField<?, Long>, List<Long>> entry : fields.entrySet()) {
            condition = condition == null ? entry.getKey().in((Collection)entry.getValue()) : condition.or(entry.getKey().in((Collection)entry.getValue()));
        }
        if (printLastExec) {
            Execution execution = Tables.EXECUTION.as("execution");
            condition = condition.and(Tables.EXECUTION.EXECUTION_ORDER.eq((Select)this.dslContext.select((SelectField)DSL.max((Field)execution.EXECUTION_ORDER)).from((TableLike)execution).where(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.eq((Field)execution.TEST_PLAN_ITEM_ID))).or(Tables.TEST_PLAN_ITEM.LAST_EXECUTED_ON.isNull())).or(condition.and(Tables.TEST_PLAN_ITEM.LAST_EXECUTED_ON.isNull()));
        }
        return condition;
    }

    private Map<EntityType, Boolean> getSelectedEntityTypeMap(List<EntityType> type) {
        HashMap<EntityType, Boolean> result = new HashMap<EntityType, Boolean>();
        result.put(EntityType.ITERATION, type.contains(EntityType.ITERATION));
        result.put(EntityType.TEST_SUITE, type.contains(EntityType.TEST_SUITE));
        result.put(EntityType.CAMPAIGN_FOLDER, type.contains(EntityType.CAMPAIGN_FOLDER));
        return result;
    }

    private SelectJoinStep<Record> buildFromClauseOfMainQuery(Collection<Field<?>> fieldList, boolean isTestSuiteRequested, Map<EntityType, Boolean> selectedEntityTypeMap, int queryDepth, SelectSelectStep<Record> selectQuery) {
        SelectJoinStep fromQuery = selectQuery.from((TableLike)Tables.CAMPAIGN);
        if (Boolean.TRUE.equals(selectedEntityTypeMap.get(EntityType.CAMPAIGN_FOLDER))) {
            this.joinCampaignFolder((SelectJoinStep<Record>)fromQuery);
        }
        fromQuery.innerJoin((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.CAMPAIGN.CLN_ID));
        if (fieldList.contains(CustomExportColumnLabel.CAMPAIGN_MILESTONE.getJooqTableField())) {
            this.joinCampaignMilestone((SelectJoinStep<Record>)fromQuery);
        }
        if (this.isJoinOnIterationNeeded(queryDepth, selectedEntityTypeMap)) {
            this.joinIteration((SelectJoinStep<Record>)fromQuery);
        }
        if (this.isJoinOnTestCaseNeeded(queryDepth, selectedEntityTypeMap)) {
            this.joinTestCase((SelectJoinStep<Record>)fromQuery);
            this.joinInfoListItem((SelectJoinStep<Record>)fromQuery);
            if (this.isJoinOnTestSuiteNeeded(isTestSuiteRequested, selectedEntityTypeMap)) {
                this.joinTestSuite((SelectJoinStep<Record>)fromQuery);
            }
        }
        if (queryDepth > 3) {
            this.joinExecution((SelectJoinStep<Record>)fromQuery);
        }
        if (queryDepth > 4) {
            this.joinExecutionStep((SelectJoinStep<Record>)fromQuery);
        }
        return fromQuery;
    }

    private void joinCampaignFolder(SelectJoinStep<Record> fromQuery) {
        fromQuery.leftJoin((TableLike)Tables.CLN_RELATIONSHIP_CLOSURE).on(Tables.CLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.eq((Field)Tables.CAMPAIGN.CLN_ID)).leftJoin((TableLike)Tables.CAMPAIGN_FOLDER).on(Tables.CAMPAIGN_FOLDER.CLN_ID.eq((Field)Tables.CLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID));
    }

    private void joinCampaignMilestone(SelectJoinStep<Record> fromQuery) {
        fromQuery.leftJoin((TableLike)Tables.MILESTONE_CAMPAIGN).on(Tables.MILESTONE_CAMPAIGN.CAMPAIGN_ID.eq((Field)Tables.CAMPAIGN.CLN_ID)).leftJoin((TableLike)Tables.MILESTONE).on(Tables.MILESTONE.MILESTONE_ID.eq((Field)Tables.MILESTONE_CAMPAIGN.MILESTONE_ID));
    }

    private void joinIteration(SelectJoinStep<Record> fromQuery) {
        fromQuery.leftJoin((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Field)Tables.CAMPAIGN.CLN_ID)).leftJoin((TableLike)Tables.ITERATION).on(Tables.ITERATION.ITERATION_ID.eq((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ID));
    }

    private void joinExecutionStep(SelectJoinStep<Record> fromQuery) {
        fromQuery.leftJoin((TableLike)Tables.EXECUTION_EXECUTION_STEPS).on(Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).leftJoin((TableLike)Tables.EXECUTION_STEP).on(Tables.EXECUTION_STEP.EXECUTION_STEP_ID.eq((Field)Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_STEP_ID)).leftJoin((TableLike)Tables.VERIFYING_STEPS.as(ES_VS)).on(Tables.VERIFYING_STEPS.as((String)ES_VS).TEST_STEP_ID.eq((Field)Tables.EXECUTION_STEP.TEST_STEP_ID));
    }

    private void joinExecution(SelectJoinStep<Record> fromQuery) {
        fromQuery.leftJoin((TableLike)Tables.EXECUTION).on(Tables.EXECUTION.TEST_PLAN_ITEM_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID));
    }

    private void joinTestSuite(SelectJoinStep<Record> fromQuery) {
        fromQuery.leftJoin((TableLike)Tables.TEST_SUITE_TEST_PLAN_ITEM).on(Tables.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).leftJoin((TableLike)Tables.TEST_SUITE).on(Tables.TEST_SUITE.ID.eq((Field)Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID));
    }

    private void joinInfoListItem(SelectJoinStep<Record> fromQuery) {
        fromQuery.leftJoin((TableLike)Tables.INFO_LIST_ITEM.as("type_list")).on(Tables.INFO_LIST_ITEM.as((String)"type_list").ITEM_ID.eq((Field)Tables.TEST_CASE.TC_TYPE)).leftJoin((TableLike)Tables.INFO_LIST_ITEM.as("type_nature")).on(Tables.INFO_LIST_ITEM.as((String)"type_nature").ITEM_ID.eq((Field)Tables.TEST_CASE.TC_NATURE));
    }

    private void joinTestCase(SelectJoinStep<Record> fromQuery) {
        fromQuery.leftJoin((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.ITERATION.TEST_PLAN_ID)).leftJoin((TableLike)Tables.CORE_USER).on(Tables.CORE_USER.PARTY_ID.eq((Field)Tables.TEST_PLAN_ITEM.ASSIGNEE_ID)).leftJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).leftJoin((TableLike)Tables.DATASET).on(Tables.DATASET.DATASET_ID.eq((Field)Tables.TEST_PLAN_ITEM.DATASET_ID).and(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.DATASET.TEST_CASE_ID))).leftJoin((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).leftJoin((TableLike)Tables.PROJECT).on(Tables.PROJECT.TCL_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID));
    }

    private boolean isJoinOnTestSuiteNeeded(boolean isTestSuiteRequested, Map<EntityType, Boolean> selectedEntityTypeMap) {
        return isTestSuiteRequested || selectedEntityTypeMap.get(EntityType.TEST_SUITE) != false;
    }

    private boolean isJoinOnTestCaseNeeded(int queryDepth, Map<EntityType, Boolean> selectedEntityTypeMap) {
        return queryDepth > 2 || selectedEntityTypeMap.get(EntityType.TEST_SUITE) != false;
    }

    private boolean isJoinOnIterationNeeded(int queryDepth, Map<EntityType, Boolean> selectedEntityTypeMap) {
        return queryDepth > 1 || selectedEntityTypeMap.get(EntityType.ITERATION) != false || selectedEntityTypeMap.get(EntityType.TEST_SUITE) != false;
    }

    private int getQueryDepth(List<EntityType> entityTypeList) {
        if (entityTypeList.contains(EntityType.ISSUE)) {
            return 6;
        }
        if (entityTypeList.contains(EntityType.EXECUTION_STEP) || entityTypeList.contains(EntityType.TEST_STEP)) {
            return 5;
        }
        if (entityTypeList.contains(EntityType.EXECUTION)) {
            return 4;
        }
        if (entityTypeList.contains(EntityType.TEST_CASE) || entityTypeList.contains(EntityType.TEST_SUITE)) {
            return 3;
        }
        if (entityTypeList.contains(EntityType.ITERATION)) {
            return 2;
        }
        return 1;
    }

    private boolean checkGroupByAndOrderByExecutionStepIdNeeded(List<CustomReportCustomExportColumn> selectedColumns, int queryDepth, List<EntityType> entityTypeList) {
        if (queryDepth > 4) {
            boolean entityListContainExecutionStepOrTestStep;
            boolean columnsContainsIssueExecutionStep = selectedColumns.stream().map(CustomReportCustomExportColumn::getLabel).anyMatch(label -> label.equals((Object)CustomExportColumnLabel.ISSUE_EXECUTION_STEP_ISSUES_NUMBER) || label.equals((Object)CustomExportColumnLabel.ISSUE_EXECUTION_STEP_ISSUES_IDS));
            boolean bl = entityListContainExecutionStepOrTestStep = entityTypeList.contains(EntityType.EXECUTION_STEP) || entityTypeList.contains(EntityType.TEST_STEP);
            return columnsContainsIssueExecutionStep || entityListContainExecutionStepOrTestStep;
        }
        return false;
    }

    private Set<Field<?>> buildDefaultGroupAndOrderByFieldList(int queryDepth, boolean isTestSuiteRequested, boolean isGroupByAndOrderByExecutionStepIdNeeded) {
        HashSet orderByFieldList = new HashSet();
        orderByFieldList.add((Field<?>)Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID);
        orderByFieldList.add((Field<?>)Tables.CAMPAIGN.CLN_ID);
        if (queryDepth > 1) {
            orderByFieldList.add((Field<?>)Tables.ITERATION.ITERATION_ID);
        }
        if (queryDepth > 2) {
            if (isTestSuiteRequested) {
                orderByFieldList.add((Field<?>)Tables.TEST_SUITE.ID);
            }
            orderByFieldList.add((Field<?>)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID);
        }
        if (queryDepth > 3) {
            orderByFieldList.add((Field<?>)Tables.EXECUTION.EXECUTION_ID);
        }
        if (isGroupByAndOrderByExecutionStepIdNeeded) {
            orderByFieldList.add((Field<?>)Tables.EXECUTION_STEP.EXECUTION_STEP_ID);
        }
        return orderByFieldList;
    }

    private Set<Field<?>> appendRequiredGroupByFields(Set<Field<?>> defaultGroupByFieldList, List<CustomReportCustomExportColumn> selectedColumns) {
        for (CustomReportCustomExportColumn column : selectedColumns) {
            if (column.getLabel().getJooqTablePkField() != null) {
                defaultGroupByFieldList.add(column.getLabel().getJooqTablePkField());
            }
            if (!CustomExportColumnLabel.TEST_CASE_LABEL.equals((Object)column.getLabel()) && !CustomExportColumnLabel.TEST_CASE_DESCRIPTION.equals((Object)column.getLabel())) continue;
            defaultGroupByFieldList.add((Field<?>)Tables.TEST_CASE.TCLN_ID);
        }
        return defaultGroupByFieldList;
    }

    @Override
    public Map<Long, Object> computeCampaignProgressRate(Set<Long> campaignIds) {
        HashMap<Long, Object> result = new HashMap<Long, Object>();
        campaignIds.forEach(campaignRowId -> {
            Object object = result.put((Long)campaignRowId, this.getCampaignProgressRateData((Long)campaignRowId));
        });
        return result;
    }

    private Object getCampaignProgressRateData(Long campaignId) {
        return this.dslContext.select(this.getCampaignProgressRateField(campaignId)).fetchOne(this.getCampaignProgressRateField(campaignId));
    }

    private Field<?> getCampaignProgressRateField(Long campaignId) {
        return DSL.concat((Field[])new Field[]{DSL.round((Field)this.getItpiDoneCountField(campaignId).div(DSL.nullif(this.getItpiTotalCountField(campaignId), (Object)0.0)).mul((Number)100L), (int)2).cast(SQLDataType.VARCHAR((int)5)), DSL.val((String)" "), DSL.val((String)"%")});
    }

    private Field<Double> getItpiDoneCountField(Long campaignId) {
        return DSL.select((SelectField)DSL.count((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID).cast(SQLDataType.DOUBLE)).from((TableLike)Tables.CAMPAIGN.as(CAMPAIGN_ITPI_DONE)).leftJoin((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Field)Tables.CAMPAIGN.as((String)CAMPAIGN_ITPI_DONE).CLN_ID)).leftJoin((TableLike)Iteration.ITERATION).on(Iteration.ITERATION.ITERATION_ID.eq((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ID)).leftJoin((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Iteration.ITERATION.TEST_PLAN_ID)).where(Tables.CAMPAIGN.as((String)CAMPAIGN_ITPI_DONE).CLN_ID.eq((Object)campaignId)).and(Tables.TEST_PLAN_ITEM.EXECUTION_STATUS.in((Object[])new String[]{"SETTLED", "UNTESTABLE", "BLOCKED", "FAILURE", "SUCCESS"})).asField().cast(Double.class);
    }

    private Field<Double> getItpiTotalCountField(Long campaignId) {
        return DSL.select((SelectField)DSL.count((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID).cast(SQLDataType.DOUBLE)).from((TableLike)Tables.CAMPAIGN.as(CAMPAIGN_ITPI_TOTAL)).leftJoin((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Field)Tables.CAMPAIGN.as((String)CAMPAIGN_ITPI_TOTAL).CLN_ID)).leftJoin((TableLike)Iteration.ITERATION).on(Iteration.ITERATION.ITERATION_ID.eq((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ID)).leftJoin((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Iteration.ITERATION.TEST_PLAN_ID)).where(Tables.CAMPAIGN.as((String)CAMPAIGN_ITPI_TOTAL).CLN_ID.eq((Object)campaignId)).asField().cast(Double.class);
    }
}

