/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.attachment;

import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.jooq.tools.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public final class AttachmentHelper {
    private AttachmentHelper() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static String adaptHtmlImageAttribute(String html, Predicate<String> isAttachment, BiConsumer<Element, String> processorMatch, BiConsumer<Element, String> processorNoMatch) {
        if (StringUtils.isBlank((String)html)) {
            return html;
        }
        Document document = Jsoup.parse((String)html);
        Elements elements = document.select("img");
        if (elements.isEmpty()) {
            return html;
        }
        elements.forEach(element -> {
            String imageSrc = element.attr("src");
            if (isAttachment.test(imageSrc)) {
                processorMatch.accept((Element)element, imageSrc);
            } else {
                processorNoMatch.accept((Element)element, imageSrc);
            }
        });
        return document.body().html();
    }

    public static String adaptHtmlImageAttribute(String html, Predicate<String> isAttachment, BiConsumer<Element, String> processorMatch) {
        return AttachmentHelper.adaptHtmlImageAttribute(html, isAttachment, processorMatch, (element, imageSrc) -> {});
    }

    public static String adaptHtmlImageExport(String html) {
        return AttachmentHelper.adaptHtmlImageAttribute(html, src -> !src.contains("data:image"), (element, imageSrc) -> {
            Element element2 = element.attr("alt", imageSrc);
        });
    }
}

