/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testautomation;

import com.google.common.collect.Lists;
import jakarta.persistence.EntityManager;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.core.foundation.exception.EntityDoesNotExistException;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.attachment.ExternalContentCoordinates;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.domain.servers.TokenAuthCredentials;
import org.squashtest.tm.domain.testautomation.AutomatedSuite;
import org.squashtest.tm.domain.testautomation.AutomatedSuiteWorkflow;
import org.squashtest.tm.domain.testautomation.TestAutomationServer;
import org.squashtest.tm.service.annotation.BatchPreventConcurrent;
import org.squashtest.tm.service.annotation.Ids;
import org.squashtest.tm.service.annotation.SpringDaoMetaAnnotationAspect;
import org.squashtest.tm.service.attachment.AttachmentManagerService;
import org.squashtest.tm.service.campaign.AutomatedExecutionCreationService;
import org.squashtest.tm.service.campaign.CustomTestSuiteModificationService;
import org.squashtest.tm.service.internal.campaign.CampaignNodeDeletionHandler;
import org.squashtest.tm.service.internal.repository.AutomatedSuiteDao;
import org.squashtest.tm.service.internal.repository.CustomTestAutomationServerDao;
import org.squashtest.tm.service.internal.repository.ExecutionStepDao;
import org.squashtest.tm.service.internal.repository.GenericProjectDao;
import org.squashtest.tm.service.internal.repository.IterationDao;
import org.squashtest.tm.service.internal.repository.IterationTestPlanDao;
import org.squashtest.tm.service.internal.repository.TestPlanItemDao;
import org.squashtest.tm.service.internal.repository.TestSuiteDao;
import org.squashtest.tm.service.internal.testautomation.AutomatedSuiteManagerServiceImpl$AjcClosure1;
import org.squashtest.tm.service.internal.testautomation.AutomatedSuiteStartService;
import org.squashtest.tm.service.internal.testautomation.TestAutomationConnectorRegistry;
import org.squashtest.tm.service.license.UltimateLicenseAvailabilityService;
import org.squashtest.tm.service.orchestrator.model.OrchestratorResponse;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.servers.CredentialsProvider;
import org.squashtest.tm.service.testautomation.AutomatedSuiteManagerService;
import org.squashtest.tm.service.testautomation.AutomationDeletionCount;
import org.squashtest.tm.service.testautomation.model.AutomatedSuiteCreationSpecification;
import org.squashtest.tm.service.testautomation.model.AutomatedSuiteWithSquashAutomAutomatedITPIs;
import org.squashtest.tm.service.testautomation.model.SquashAutomExecutionConfiguration;
import org.squashtest.tm.service.testautomation.model.SuiteExecutionConfiguration;
import org.squashtest.tm.service.testautomation.spi.TestAutomationConnector;
import org.squashtest.tm.service.testautomation.spi.TestAutomationException;
import org.squashtest.tm.service.testautomation.supervision.AutomatedExecutionViewUtils;
import org.squashtest.tm.service.testautomation.supervision.model.AutomatedSuiteOverview;

@Transactional
@Service
public class AutomatedSuiteManagerServiceImpl
implements AutomatedSuiteManagerService {
    private static final String EXECUTE = "EXECUTE";
    private static final Logger LOGGER;
    public static final int BIND_VARIABLES_LIMIT = 500;
    private final AutomatedSuiteDao autoSuiteDao;
    private final IterationDao iterationDao;
    private final TestSuiteDao testSuiteDao;
    private final IterationTestPlanDao iterationTestPlanDao;
    private final TestPlanItemDao testPlanItemDao;
    private final TestAutomationConnectorRegistry connectorRegistry;
    private final PermissionEvaluationService permissionService;
    private final CampaignNodeDeletionHandler deletionHandler;
    private final CustomTestAutomationServerDao testAutomationServerDao;
    private final GenericProjectDao genericProjectDao;
    private final CredentialsProvider credentialsProvider;
    private final AttachmentManagerService attachmentManagerService;
    private final AutomatedExecutionCreationService automatedExecutionCreationService;
    private final EntityManager entityManager;
    private final UltimateLicenseAvailabilityService ultimateLicenseService;
    private final CustomTestSuiteModificationService customTestSuiteModificationService;
    private final AutomatedSuiteStartService automatedSuiteStartService;
    private final ExecutionStepDao executionStepDao;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        AutomatedSuiteManagerServiceImpl.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(AutomatedSuiteManagerServiceImpl.class);
    }

    public AutomatedSuiteManagerServiceImpl(AutomatedSuiteDao autoSuiteDao, IterationDao iterationDao, TestSuiteDao testSuiteDao, IterationTestPlanDao iterationTestPlanDao, TestPlanItemDao testPlanItemDao, TestAutomationConnectorRegistry connectorRegistry, PermissionEvaluationService permissionService, CampaignNodeDeletionHandler deletionHandler, CustomTestAutomationServerDao testAutomationServerDao, GenericProjectDao genericProjectDao, CredentialsProvider credentialsProvider, AttachmentManagerService attachmentManagerService, AutomatedExecutionCreationService automatedExecutionCreationService, EntityManager entityManager, UltimateLicenseAvailabilityService ultimateLicenseService, CustomTestSuiteModificationService customTestSuiteModificationService, AutomatedSuiteStartService automatedSuiteStartService, ExecutionStepDao executionStepDao) {
        this.autoSuiteDao = autoSuiteDao;
        this.iterationDao = iterationDao;
        this.testSuiteDao = testSuiteDao;
        this.iterationTestPlanDao = iterationTestPlanDao;
        this.testPlanItemDao = testPlanItemDao;
        this.connectorRegistry = connectorRegistry;
        this.permissionService = permissionService;
        this.deletionHandler = deletionHandler;
        this.testAutomationServerDao = testAutomationServerDao;
        this.genericProjectDao = genericProjectDao;
        this.credentialsProvider = credentialsProvider;
        this.attachmentManagerService = attachmentManagerService;
        this.automatedExecutionCreationService = automatedExecutionCreationService;
        this.entityManager = entityManager;
        this.ultimateLicenseService = ultimateLicenseService;
        this.customTestSuiteModificationService = customTestSuiteModificationService;
        this.automatedSuiteStartService = automatedSuiteStartService;
        this.executionStepDao = executionStepDao;
    }

    @Override
    public AutomatedSuite findById(Long id) {
        return this.autoSuiteDao.findById(id);
    }

    @Override
    public AutomatedSuite findByUuid(String uuid) {
        return this.autoSuiteDao.findByUuid(uuid).orElseThrow(() -> new EntityDoesNotExistException("AUTOMATED_SUITE", uuid));
    }

    @Override
    public boolean stopWorkflows(Long suiteId, List<String> workflows) {
        ArrayList errors = new ArrayList();
        workflows.forEach(workflow -> {
            LOGGER.info("Stopping workflow {} for suite {}", new Object[]{workflow, suiteId});
            AutomatedSuiteWorkflow automatedSuiteWorkflow = this.autoSuiteDao.getAutomatedSuiteWorkflowByWorkflowId((String)workflow);
            if (automatedSuiteWorkflow == null) {
                LOGGER.info("No running workflow {} for suite {}", new Object[]{workflow, suiteId});
                return;
            }
            this.stopWorkflow(suiteId, (String)workflow, automatedSuiteWorkflow, errors);
        });
        return errors.contains(true);
    }

    private void stopWorkflow(Long suiteId, String workflow, AutomatedSuiteWorkflow automatedSuiteWorkflow, List<Boolean> errors) {
        Long projectId = automatedSuiteWorkflow.getProjectId();
        TestAutomationServer server = this.genericProjectDao.findTestAutomationServer(projectId);
        if (server == null) {
            LOGGER.error("No test automation server found for project with id: {}", new Object[]{projectId});
            errors.add(true);
            return;
        }
        TestAutomationConnector connector = this.connectorRegistry.getConnectorForKind(server.getKind());
        TokenAuthCredentials credentials = this.credentialsProvider.getProjectLevelCredentials(server.getId(), projectId).orElse(null);
        try {
            OrchestratorResponse<Void> response = connector.killWorkflow(server, projectId, credentials, workflow);
            if (response.isReachable()) {
                AutomatedSuite suite = (AutomatedSuite)this.entityManager.find(AutomatedSuite.class, (Object)suiteId);
                suite.getWorkflows().removeIf(work -> work.getWorkflowId().equals(workflow));
                this.computeNewTestSuiteStatus(suite);
            } else {
                LOGGER.error("Orchestrator unreachable. Cannot stop workflow {} for suite {}", new Object[]{workflow, suiteId});
                errors.add(true);
            }
        }
        catch (TestAutomationException ex) {
            LOGGER.error("An error occurred while stopping workflow {} for suite {}", new Object[]{workflow, suiteId});
            LOGGER.trace("Error stacktrace: ", (Throwable)((Object)ex));
            errors.add(true);
        }
    }

    private void computeNewTestSuiteStatus(AutomatedSuite suite) {
        TestSuite testSuite = suite.getTestSuite();
        if (testSuite != null) {
            this.customTestSuiteModificationService.updateExecutionStatus(List.of(testSuite));
        }
    }

    @Override
    public void deleteAutomatedSuites(List<Long> automatedSuiteIds) {
        this.deletionHandler.deleteAutomatedSuites(automatedSuiteIds);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public AutomationDeletionCount countOldAutomatedSuitesAndExecutions() {
        return this.autoSuiteDao.countOldAutomatedSuitesAndExecutions();
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public AutomationDeletionCount countOldAutomatedSuitesAndExecutionsForProject(Long projectId) {
        return this.autoSuiteDao.countOldAutomatedSuitesAndExecutionsByProjectId(projectId);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void cleanOldSuites() {
        this.cleanAutomatedSuites(this.autoSuiteDao.getOldAutomatedSuiteIds());
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void cleanOldSuitesForProject(Long projectId) {
        this.cleanAutomatedSuites(this.autoSuiteDao.getOldAutomatedSuiteIdsByProjectId(projectId));
    }

    private void cleanAutomatedSuites(List<Long> oldAutomatedSuiteIds) {
        if (oldAutomatedSuiteIds.isEmpty()) {
            return;
        }
        LOGGER.info("Starting deletion of %d automated suites.".formatted(oldAutomatedSuiteIds.size()), new Object[0]);
        LOGGER.debug("Automated suites IDs: %s".formatted(oldAutomatedSuiteIds), new Object[0]);
        Instant start = Instant.now();
        List automatedSuiteIdPartitions = Lists.partition(oldAutomatedSuiteIds, (int)500);
        automatedSuiteIdPartitions.forEach(automatedSuiteIdPartition -> {
            this.deleteAutomatedSuites((List<Long>)automatedSuiteIdPartition);
            this.entityManager.flush();
            this.entityManager.clear();
        });
        long elapsedMilliseconds = Duration.between(start, Instant.now()).toMillis();
        LOGGER.info("Deletion of %d automated suites completed in %d ms.".formatted(oldAutomatedSuiteIds.size(), elapsedMilliseconds), new Object[0]);
    }

    @Override
    @BatchPreventConcurrent(entityType=TestPlanItem.class)
    public AutomatedSuiteOverview createAndExecute(AutomatedSuiteCreationSpecification specification, @Ids List<Long> itemTestPlanIds) {
        if (this.ultimateLicenseService.isAvailable()) {
            this.setSquashAutomOrchestratorAdditionalConfiguration(specification);
        }
        LOGGER.debug("Start creating executions: {}", new Object[]{new Date()});
        AutomatedSuiteWithSquashAutomAutomatedITPIs suiteWithAutomItpis = this.createFromSpecification(specification, itemTestPlanIds);
        LOGGER.debug("End creating executions: {}", new Object[]{new Date()});
        suiteWithAutomItpis.getSquashAutomAutomatedItems().sort(Comparator.comparingInt(TestPlanItem::getOrder));
        LOGGER.debug("Start sending executions: {}", new Object[]{new Date()});
        this.automatedSuiteStartService.start(suiteWithAutomItpis, specification.getExecutionConfigurations(), specification.getSquashAutomExecutionConfigurations());
        LOGGER.debug("End sending executions: {}", new Object[]{new Date()});
        LOGGER.debug("Start creating automated suite overview: {}", new Object[]{new Date()});
        AutomatedSuiteOverview automatedSuiteOverview = AutomatedExecutionViewUtils.buildFirstAutomatedSuiteOverview(suiteWithAutomItpis);
        LOGGER.debug("End creating automated suite overview: {}", new Object[]{new Date()});
        AutomatedSuiteManagerServiceImpl.setMessages(suiteWithAutomItpis, automatedSuiteOverview);
        return automatedSuiteOverview;
    }

    private static void setMessages(AutomatedSuiteWithSquashAutomAutomatedITPIs suiteWithAutomItpis, AutomatedSuiteOverview automatedSuiteOverview) {
        if (suiteWithAutomItpis.getErrorMessage() != null) {
            automatedSuiteOverview.setErrorMessage(suiteWithAutomItpis.getErrorMessage());
        } else if (suiteWithAutomItpis.getWorkflowsUUIDs() != null && !suiteWithAutomItpis.getWorkflowsUUIDs().isEmpty()) {
            automatedSuiteOverview.setWorkflowsUUIDs(suiteWithAutomItpis.getWorkflowsUUIDs());
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#iterationId, 'org.squashtest.tm.domain.campaign.Iteration', 'EXECUTE') or hasRole('ROLE_ADMIN')")
    @BatchPreventConcurrent(entityType=TestPlanItem.class)
    public AutomatedSuite createFromIterationTestPlan(long iterationId, @Ids List<Long> testPlanIds) {
        Long projectId = this.iterationDao.getProjectId(iterationId);
        Iteration iteration = (Iteration)this.iterationDao.findById(iterationId);
        List<Long> squashTFAutomatedItems = this.extractSquashTFAutomatedItems(testPlanIds);
        Long newSuiteId = this.createSuiteAndClearSession(iteration);
        this.createSquashTFExecutions(squashTFAutomatedItems, newSuiteId, projectId);
        return (AutomatedSuite)this.entityManager.find(AutomatedSuite.class, (Object)newSuiteId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#testSuiteId, 'org.squashtest.tm.domain.campaign.TestSuite', 'EXECUTE') or hasRole('ROLE_ADMIN')")
    @BatchPreventConcurrent(entityType=TestPlanItem.class)
    public AutomatedSuite createFromTestSuiteTestPlan(long testSuiteId, @Ids List<Long> testPlanIds) {
        Long projectId = this.testSuiteDao.getProjectId(testSuiteId);
        List<Long> squashTFAutomatedItems = this.extractSquashTFAutomatedItems(testPlanIds);
        TestSuite testSuite = (TestSuite)this.testSuiteDao.findById(testSuiteId).orElseThrow();
        Long suiteId = this.createSuiteAndClearSession(testSuite);
        this.createSquashTFExecutions(squashTFAutomatedItems, suiteId, projectId);
        return (AutomatedSuite)this.entityManager.find(AutomatedSuite.class, (Object)suiteId);
    }

    @Override
    @BatchPreventConcurrent(entityType=TestPlanItem.class)
    public AutomatedSuite createFromItemsAndIteration(@Ids List<Long> testPlanIds, long iterationId) {
        this.permissionService.checkPermission(testPlanIds, EXECUTE, TestPlanItem.class.getName());
        List<Long> list = testPlanIds;
        TestPlanItemDao testPlanItemDao = this.testPlanItemDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)testPlanItemDao, list);
        Object[] objectArray = new Object[]{this, testPlanItemDao, list, joinPoint};
        AutomatedSuiteManagerServiceImpl$AjcClosure1 automatedSuiteManagerServiceImpl$AjcClosure1 = new AutomatedSuiteManagerServiceImpl$AjcClosure1(objectArray);
        List items = (List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(automatedSuiteManagerServiceImpl$AjcClosure1.linkClosureAndJoinPoint(4112));
        Long projectId = this.iterationDao.getProjectId(iterationId);
        return this.createSuite(items, projectId);
    }

    private AutomatedSuite createSuite(List<Long> items, Long projectId) {
        List<Long> squashTFAutomatedItems = this.extractSquashTFAutomatedItems(items);
        Long newSuiteId = this.createSuiteAndClearSession();
        this.createSquashTFExecutions(squashTFAutomatedItems, newSuiteId, projectId);
        return (AutomatedSuite)this.entityManager.find(AutomatedSuite.class, (Object)newSuiteId);
    }

    private AutomatedSuiteWithSquashAutomAutomatedITPIs createFromSpecification(AutomatedSuiteCreationSpecification specification, List<Long> itemTestPlanIds) {
        specification.validate();
        this.checkPermission(specification);
        Long contextId = specification.getContext().getId();
        Collection<SquashAutomExecutionConfiguration> orchestratorConfigurations = specification.getSquashAutomExecutionConfigurations();
        EntityType entityType = specification.getContext().getType();
        return this.createAutomatedSuite(contextId, orchestratorConfigurations, entityType, itemTestPlanIds);
    }

    private AutomatedSuiteWithSquashAutomAutomatedITPIs createAutomatedSuite(Long entityId, Collection<SquashAutomExecutionConfiguration> orchestratorConfigurations, EntityType entityType, List<Long> itemIds) {
        Long projectId = this.findProjectId(entityType, entityId);
        List<Long> squashTFAutomatedItems = this.extractSquashTFAutomatedItems(itemIds);
        List<Long> squashOrchestratorAutomatedItems = this.extractSquashOrchestratorAutomatedItems(itemIds);
        Long suiteId = this.createSuiteAndClearSession(entityId, entityType);
        Map<Long, Long> orchestratorItemExecutionMap = this.createAutomatedExecutions(suiteId, squashTFAutomatedItems, squashOrchestratorAutomatedItems, orchestratorConfigurations, projectId);
        return this.createAutomatedSuiteWithSquashAutomAutomatedITPIs(suiteId, orchestratorItemExecutionMap);
    }

    private Map<Long, Long> createAutomatedExecutions(Long suiteId, List<Long> squashTFAutomatedItems, List<Long> squashOrchestratorAutomatedItems, Collection<SquashAutomExecutionConfiguration> orchestratorConfigurations, Long projectId) {
        this.createSquashTFExecutions(squashTFAutomatedItems, suiteId, projectId);
        return this.createSquashOrchestratorExecutions(squashOrchestratorAutomatedItems, suiteId, orchestratorConfigurations, projectId);
    }

    private Long findProjectId(EntityType entityType, Long entityId) {
        if (EntityType.ITERATION.equals((Object)entityType)) {
            return this.iterationDao.getProjectId(entityId);
        }
        return this.testSuiteDao.getProjectId(entityId);
    }

    private Long createSuiteAndClearSession(Long entityId, EntityType entityType) {
        if (EntityType.ITERATION.equals((Object)entityType)) {
            Iteration iteration = (Iteration)this.entityManager.getReference(Iteration.class, (Object)entityId);
            return this.createSuiteAndClearSession(iteration);
        }
        TestSuite suite = (TestSuite)this.entityManager.getReference(TestSuite.class, (Object)entityId);
        return this.createSuiteAndClearSession(suite);
    }

    private AutomatedSuiteWithSquashAutomAutomatedITPIs createAutomatedSuiteWithSquashAutomAutomatedITPIs(Long automatedSuiteId, Map<Long, Long> orchestratorItemExecutionMap) {
        AutomatedSuite suite = (AutomatedSuite)this.entityManager.find(AutomatedSuite.class, (Object)automatedSuiteId);
        List<TestPlanItem> items = this.iterationTestPlanDao.fetchWithServerByIds(orchestratorItemExecutionMap.keySet());
        AutomatedSuiteWithSquashAutomAutomatedITPIs automatedSuiteWithSquashAutomAutomatedITPIs = new AutomatedSuiteWithSquashAutomAutomatedITPIs(suite, items);
        automatedSuiteWithSquashAutomAutomatedITPIs.setItemExecutionMap(orchestratorItemExecutionMap);
        return automatedSuiteWithSquashAutomAutomatedITPIs;
    }

    private void checkPermission(AutomatedSuiteCreationSpecification specification) {
        ArrayList<Long> singleId = new ArrayList<Long>();
        singleId.add(specification.getContext().getId());
        Class clazz = specification.getContext().getType() == EntityType.ITERATION ? Iteration.class : TestSuite.class;
        this.permissionService.checkPermission(singleId, EXECUTE, clazz.getName());
    }

    @Override
    public void start(AutomatedSuite suite) {
        this.automatedSuiteStartService.start(suite, new ArrayList<SuiteExecutionConfiguration>());
    }

    private void createSquashTFExecutions(List<Long> testPlanItemIds, Long newSuiteId, Long projectId) {
        if (testPlanItemIds.isEmpty()) {
            return;
        }
        AutomatedSuite automatedSuite = this.autoSuiteDao.load(newSuiteId);
        this.automatedExecutionCreationService.createAutomatedExecutions(automatedSuite, testPlanItemIds, projectId);
    }

    private Map<Long, Long> createSquashOrchestratorExecutions(List<Long> itemIds, Long newSuiteId, Collection<SquashAutomExecutionConfiguration> configurations, Long projectId) {
        if (itemIds.isEmpty()) {
            return Collections.emptyMap();
        }
        AutomatedSuite automatedSuite = this.autoSuiteDao.load(newSuiteId);
        Map<Long, SquashAutomExecutionConfiguration> configurationByProjectId = configurations.stream().collect(Collectors.toMap(SquashAutomExecutionConfiguration::getProjectId, conf -> conf));
        return this.automatedExecutionCreationService.createSquashOrchestratorAutomatedExecutions(automatedSuite, itemIds, projectId, configurationByProjectId);
    }

    private Long createSuiteAndClearSession() {
        AutomatedSuite newSuite = this.autoSuiteDao.createNewSuite();
        this.entityManager.flush();
        Long newSuiteId = newSuite.getId();
        this.entityManager.clear();
        return newSuiteId;
    }

    private Long createSuiteAndClearSession(Iteration iteration) {
        AutomatedSuite newSuite = this.autoSuiteDao.createNewSuite(iteration);
        this.entityManager.flush();
        Long newSuiteId = newSuite.getId();
        this.entityManager.clear();
        return newSuiteId;
    }

    private Long createSuiteAndClearSession(TestSuite testSuite) {
        AutomatedSuite newSuite = this.autoSuiteDao.createNewSuite(testSuite);
        this.entityManager.flush();
        Long newSuiteId = newSuite.getId();
        this.entityManager.clear();
        return newSuiteId;
    }

    @Override
    public void pruneAutomatedSuites(List<Long> automatedSuiteIds, boolean complete) {
        Map<Long, Long> executionMap = this.autoSuiteDao.getAutomatedExecutionIdsWithAttachmentListIds(automatedSuiteIds, complete);
        Set<Long> executionIds = executionMap.keySet();
        List<ExternalContentCoordinates> externalContentCoordinates = this.attachmentManagerService.getListPairContentIDListIDForExecutionIds(executionIds);
        Map<Long, Long> executionStepMap = this.executionStepDao.getTestStepIdsWithAttachmentListIds(executionIds, complete);
        externalContentCoordinates.addAll(this.attachmentManagerService.getListPairContentIDListIDForExecutionStepIds(executionStepMap.keySet()));
        ArrayList<Long> attachmentLists = new ArrayList<Long>();
        attachmentLists.addAll(executionMap.values());
        attachmentLists.addAll(executionStepMap.values());
        this.attachmentManagerService.removeAttachmentsAndContents(attachmentLists, externalContentCoordinates);
    }

    @Override
    public void pruneAttachments(Long projectId, boolean complete) {
        this.pruneAutomatedSuites(this.autoSuiteDao.getOldAutomatedSuiteIdsByProjectId(projectId), complete);
    }

    private List<Long> extractSquashOrchestratorAutomatedItems(List<Long> items) {
        return this.iterationTestPlanDao.filterSquashOrchestratorItemIds(items);
    }

    private List<Long> extractSquashTFAutomatedItems(List<Long> itemIds) {
        return this.iterationTestPlanDao.filterSquashTfItemIds(itemIds);
    }

    private void setSquashAutomOrchestratorAdditionalConfiguration(AutomatedSuiteCreationSpecification specification) {
        for (SquashAutomExecutionConfiguration additionalConfiguration : specification.getSquashAutomExecutionConfigurations()) {
            additionalConfiguration.setAdditionalConfiguration(this.testAutomationServerDao.getAdditionalConfigurationByProjectId(additionalConfiguration.getProjectId()));
        }
    }

    static final /* synthetic */ List findAllByIdsOrderedByIterationTestPlan_aroundBody0(AutomatedSuiteManagerServiceImpl automatedSuiteManagerServiceImpl, TestPlanItemDao testPlanItemDao, List list, JoinPoint joinPoint) {
        return testPlanItemDao.findAllByIdsOrderedByIterationTestPlan(list);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AutomatedSuiteManagerServiceImpl.java", AutomatedSuiteManagerServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("41000401", "findAllByIdsOrderedByIterationTestPlan", "org.squashtest.tm.service.internal.repository.TestPlanItemDao", "java.util.List", "testPlanIds", "", "java.util.List"), 381);
    }
}

