/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import jakarta.persistence.Query;
import java.util.List;
import org.apache.commons.text.WordUtils;
import org.squashtest.tm.domain.library.Library;
import org.squashtest.tm.domain.library.LibraryNode;
import org.squashtest.tm.service.internal.repository.LibraryDao;
import org.squashtest.tm.service.internal.repository.hibernate.HibernateEntityDao;
import org.squashtest.tm.service.internal.repository.hibernate.SetQueryParametersCallback;

public abstract class HibernateLibraryDao<LIBRARY extends Library<NODE>, NODE extends LibraryNode>
extends HibernateEntityDao<LIBRARY>
implements LibraryDao<LIBRARY, NODE> {
    private final String entityClassName;

    protected HibernateLibraryDao() {
        this.entityClassName = WordUtils.uncapitalize((String)this.entityType.getSimpleName());
    }

    @Override
    public List<NODE> findAllRootContentById(final long libraryId) {
        SetQueryParametersCallback callback = new SetQueryParametersCallback(){

            @Override
            public void setQueryParameters(Query query) {
                query.setParameter("libraryId", (Object)libraryId);
            }
        };
        return this.executeListNamedQuery(this.entityClassName + ".findAllRootContentById", callback);
    }

    @Override
    public LIBRARY findByRootContent(NODE node) {
        SetQueryParametersCallback callback = new SetQueryParametersCallback((LibraryNode)node){
            private final /* synthetic */ LibraryNode val$node;
            {
                this.val$node = libraryNode;
            }

            @Override
            public void setQueryParameters(Query query) {
                query.setParameter("content", (Object)this.val$node);
            }
        };
        return (LIBRARY)((Library)this.executeEntityNamedQuery(this.entityClassName + ".findByRootContent", callback));
    }
}

