/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import jakarta.inject.Inject;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.campaign.CampaignLibrary;
import org.squashtest.tm.domain.campaign.CampaignLibraryNode;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.repository.CampaignLibraryDao;
import org.squashtest.tm.service.internal.repository.hibernate.HibernateLibraryDao;

@Repository
public class HibernateCampaignLibraryDao
extends HibernateLibraryDao<CampaignLibrary, CampaignLibraryNode>
implements CampaignLibraryDao {
    @Inject
    private DSLContext dsl;

    @Override
    public CampaignLibrary loadContainerForPaste(long id) {
        return (CampaignLibrary)this.entityManager.createQuery("select cl from CampaignLibrary cl left join fetch cl.rootContent where cl.id = :id", CampaignLibrary.class).setParameter("id", (Object)id).getSingleResult();
    }

    @Override
    public CampaignLibrary loadForNodeAddition(Long libraryId) {
        return (CampaignLibrary)this.entityManager.createQuery("select cl from CampaignLibrary cl left join fetch cl.rootContent where cl.id = :id", CampaignLibrary.class).setParameter("id", (Object)libraryId).getSingleResult();
    }

    @Override
    public List<String> findContentNamesByLibraryId(Long libraryId) {
        return this.entityManager.createQuery("select content.name\nfrom CampaignLibrary library\njoin library.rootContent content\nwhere library.id = :id", String.class).setParameter("id", (Object)libraryId).getResultList();
    }

    @Override
    public Map<Long, List<String>> findContentNamesByNodeIds(Collection<Long> nodeIds) {
        org.squashtest.tm.jooq.domain.tables.CampaignLibraryNode campaignLibraryNode = Tables.CAMPAIGN_LIBRARY_NODE.as("ancestor_CLN");
        return this.dsl.select((SelectField)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID, (SelectField)campaignLibraryNode.NAME).from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).join((TableLike)Tables.CLN_RELATIONSHIP).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.CLN_RELATIONSHIP.ANCESTOR_ID)).join((TableLike)campaignLibraryNode).on(Tables.CLN_RELATIONSHIP.DESCENDANT_ID.eq((Field)campaignLibraryNode.CLN_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.in(nodeIds)).fetchGroups((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID, (Field)campaignLibraryNode.NAME);
    }
}

