/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl;

import jakarta.inject.Inject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.EnumUtils;
import org.jooq.CommonTableExpression;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Record1;
import org.jooq.Result;
import org.jooq.ResultQuery;
import org.jooq.SelectField;
import org.jooq.SelectOnConditionStep;
import org.jooq.SelectSeekStep3;
import org.jooq.TableLike;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.dto.BoundProjectToCufDto;
import org.squashtest.tm.service.internal.display.dto.CufBindingDto;
import org.squashtest.tm.service.internal.display.dto.CustomFieldDto;
import org.squashtest.tm.service.internal.display.dto.CustomFieldOptionDto;
import org.squashtest.tm.service.internal.display.dto.ProjectDto;
import org.squashtest.tm.service.internal.repository.display.CustomFieldDao;

@Repository
public class CustomFieldDaoImpl
implements CustomFieldDao {
    @Inject
    DSLContext dsl;

    @Override
    public CustomFieldDto findByIdWithPossibleValues(Long customFieldId) {
        Map resultAsMap = this.getBaseRequest().where(Tables.CUSTOM_FIELD.CF_ID.equal((Object)customFieldId)).orderBy((OrderField)Tables.CUSTOM_FIELD_OPTION.POSITION, (OrderField)Tables.CUSTOM_FIELD_OPTION.LABEL).fetch().intoGroups(Arrays.asList(Tables.CUSTOM_FIELD.CF_ID.as("ID"), Tables.CUSTOM_FIELD.NAME, Tables.CUSTOM_FIELD.OPTIONAL, Tables.CUSTOM_FIELD.LABEL, Tables.CUSTOM_FIELD.INPUT_TYPE, Tables.CUSTOM_FIELD.CODE, Tables.CUSTOM_FIELD.DEFAULT_VALUE, Tables.CUSTOM_FIELD.LARGE_DEFAULT_VALUE, Tables.CUSTOM_FIELD.NUMERIC_DEFAULT_VALUE).toArray(new Field[0]));
        return this.getAsCustomFieldDto(resultAsMap).get(0);
    }

    @Override
    public List<CustomFieldDto> findAllWithPossibleValues() {
        Map resultAsMap = this.getBaseRequest().orderBy((OrderField)Tables.CUSTOM_FIELD_OPTION.POSITION, (OrderField)Tables.CUSTOM_FIELD_OPTION.LABEL).fetch().intoGroups(Arrays.asList(Tables.CUSTOM_FIELD.CF_ID.as("ID"), Tables.CUSTOM_FIELD.NAME, Tables.CUSTOM_FIELD.OPTIONAL, Tables.CUSTOM_FIELD.LABEL, Tables.CUSTOM_FIELD.INPUT_TYPE, Tables.CUSTOM_FIELD.CODE, Tables.CUSTOM_FIELD.DEFAULT_VALUE, Tables.CUSTOM_FIELD.LARGE_DEFAULT_VALUE, Tables.CUSTOM_FIELD.NUMERIC_DEFAULT_VALUE).toArray(new Field[0]));
        return this.getAsCustomFieldDto(resultAsMap);
    }

    private SelectOnConditionStep<?> getBaseRequest() {
        return this.dsl.select((SelectField)Tables.CUSTOM_FIELD.CF_ID.as("ID"), (SelectField)Tables.CUSTOM_FIELD.NAME, (SelectField)Tables.CUSTOM_FIELD.OPTIONAL, (SelectField)Tables.CUSTOM_FIELD.LABEL, (SelectField)Tables.CUSTOM_FIELD.INPUT_TYPE, (SelectField)Tables.CUSTOM_FIELD.CODE, (SelectField)Tables.CUSTOM_FIELD.DEFAULT_VALUE, (SelectField)Tables.CUSTOM_FIELD.LARGE_DEFAULT_VALUE, (SelectField)Tables.CUSTOM_FIELD.NUMERIC_DEFAULT_VALUE, (SelectField)Tables.CUSTOM_FIELD_OPTION.LABEL, (SelectField)Tables.CUSTOM_FIELD_OPTION.CF_ID, (SelectField)Tables.CUSTOM_FIELD_OPTION.CODE, (SelectField)Tables.CUSTOM_FIELD_OPTION.COLOUR, (SelectField)Tables.CUSTOM_FIELD_OPTION.POSITION).from((TableLike)Tables.CUSTOM_FIELD).leftJoin((TableLike)Tables.CUSTOM_FIELD_OPTION).on(Tables.CUSTOM_FIELD.CF_ID.eq((Field)Tables.CUSTOM_FIELD_OPTION.CF_ID));
    }

    private List<CustomFieldDto> getAsCustomFieldDto(Map<Record, ? extends Result<? extends Record>> cufWithOptions) {
        ArrayList<CustomFieldDto> customFields = new ArrayList<CustomFieldDto>();
        cufWithOptions.entrySet().stream().forEach(cufAttributes -> {
            CustomFieldDto customField = new CustomFieldDto();
            customField.setId((Long)((Record)cufAttributes.getKey()).get(Tables.CUSTOM_FIELD.CF_ID.as("ID")));
            customField.setName((String)((Record)cufAttributes.getKey()).get((Field)Tables.CUSTOM_FIELD.NAME));
            customField.setLabel((String)((Record)cufAttributes.getKey()).get((Field)Tables.CUSTOM_FIELD.LABEL));
            customField.setInputType((String)((Record)cufAttributes.getKey()).get((Field)Tables.CUSTOM_FIELD.INPUT_TYPE));
            customField.setCode((String)((Record)cufAttributes.getKey()).get((Field)Tables.CUSTOM_FIELD.CODE));
            customField.setOptional((Boolean)((Record)cufAttributes.getKey()).get((Field)Tables.CUSTOM_FIELD.OPTIONAL));
            customField.setDefaultValue((String)((Record)cufAttributes.getKey()).get((Field)Tables.CUSTOM_FIELD.DEFAULT_VALUE));
            customField.setLargeDefaultValue((String)((Record)cufAttributes.getKey()).get((Field)Tables.CUSTOM_FIELD.LARGE_DEFAULT_VALUE));
            customField.setNumericDefaultValue((BigDecimal)((Record)cufAttributes.getKey()).get((Field)Tables.CUSTOM_FIELD.NUMERIC_DEFAULT_VALUE));
            customFields.add(customField);
            ((Result)cufAttributes.getValue()).stream().filter(c -> Objects.nonNull(c.get((Field)Tables.CUSTOM_FIELD_OPTION.CF_ID))).forEach(customFieldOptionAttributes -> {
                CustomFieldOptionDto customFieldOption = new CustomFieldOptionDto();
                customFieldOption.setCfId((Long)customFieldOptionAttributes.get((Field)Tables.CUSTOM_FIELD_OPTION.CF_ID));
                customFieldOption.setLabel((String)customFieldOptionAttributes.get((Field)Tables.CUSTOM_FIELD_OPTION.LABEL));
                customFieldOption.setCode((String)customFieldOptionAttributes.get((Field)Tables.CUSTOM_FIELD_OPTION.CODE));
                customFieldOption.setColour((String)customFieldOptionAttributes.get((Field)Tables.CUSTOM_FIELD_OPTION.COLOUR));
                customFieldOption.setPosition((Integer)customFieldOptionAttributes.get((Field)Tables.CUSTOM_FIELD_OPTION.POSITION));
                customField.getOptions().add(customFieldOption);
            });
        });
        return customFields;
    }

    @Override
    public void appendCustomFieldBindings(List<ProjectDto> projects) {
        this.appendCustomFieldBindings(projects, (Map<Long, ProjectDto> projectDtoMap) -> {
            Set projectIds = projectDtoMap.keySet();
            return this.dsl.select(this.getFieldCustomFieldBinding()).from((TableLike)Tables.CUSTOM_FIELD_BINDING).where(Tables.CUSTOM_FIELD_BINDING.BOUND_PROJECT_ID.in(projectIds)).orderBy((OrderField)Tables.CUSTOM_FIELD_BINDING.BOUND_PROJECT_ID, (OrderField)Tables.CUSTOM_FIELD_BINDING.BOUND_ENTITY, (OrderField)Tables.CUSTOM_FIELD_BINDING.POSITION);
        });
    }

    @Override
    public void appendCustomFieldBindings(List<ProjectDto> projects, CommonTableExpression<Record1<Long>> projectIdsCte) {
        SelectSeekStep3 query = this.dsl.with(new CommonTableExpression[]{projectIdsCte}).select(this.getFieldCustomFieldBinding()).from((TableLike)Tables.CUSTOM_FIELD_BINDING).join(projectIdsCte).on(Tables.CUSTOM_FIELD_BINDING.BOUND_PROJECT_ID.eq(projectIdsCte.field("PROJECT_ID_CTE", Long.class))).orderBy((OrderField)Tables.CUSTOM_FIELD_BINDING.BOUND_PROJECT_ID, (OrderField)Tables.CUSTOM_FIELD_BINDING.BOUND_ENTITY, (OrderField)Tables.CUSTOM_FIELD_BINDING.POSITION);
        this.appendCustomFieldBindings(projects, () -> CustomFieldDaoImpl.lambda$4((ResultQuery)query));
    }

    private <T extends Record> void appendCustomFieldBindings(List<ProjectDto> projects, Supplier<ResultQuery<T>> query) {
        this.appendCustomFieldBindings(projects, (Map<Long, ProjectDto> projectDtoMap) -> (ResultQuery)query.get());
    }

    private <T extends Record> void appendCustomFieldBindings(List<ProjectDto> projects, Function<Map<Long, ProjectDto>, ResultQuery<T>> query) {
        if (Objects.nonNull(projects) && !projects.isEmpty()) {
            Map projectsMap = projects.stream().collect(Collectors.toMap(ProjectDto::getId, Function.identity()));
            query.apply(projectsMap).forEach(cufRecord -> {
                ProjectDto projectDto = (ProjectDto)projectsMap.get(cufRecord.get((Field)Tables.CUSTOM_FIELD_BINDING.BOUND_PROJECT_ID));
                projectDto.addBinding(this.getCustomFieldBindingFromRecord((Record)cufRecord));
            });
        }
    }

    private List<Field<?>> getFieldCustomFieldBinding() {
        return List.of(Tables.CUSTOM_FIELD_BINDING.CFB_ID, Tables.CUSTOM_FIELD_BINDING.CF_ID, Tables.CUSTOM_FIELD_BINDING.BOUND_ENTITY, Tables.CUSTOM_FIELD_BINDING.BOUND_PROJECT_ID, Tables.CUSTOM_FIELD_BINDING.POSITION);
    }

    private CufBindingDto getCustomFieldBindingFromRecord(Record cufRecord) {
        BindableEntity bindableEntity = (BindableEntity)EnumUtils.getEnum(BindableEntity.class, (String)((String)cufRecord.get((Field)Tables.CUSTOM_FIELD_BINDING.BOUND_ENTITY)));
        return new CufBindingDto((Long)cufRecord.get((Field)Tables.CUSTOM_FIELD_BINDING.CFB_ID), (Long)cufRecord.get((Field)Tables.CUSTOM_FIELD_BINDING.CF_ID), bindableEntity, (Long)cufRecord.get((Field)Tables.CUSTOM_FIELD_BINDING.BOUND_PROJECT_ID), (Integer)cufRecord.get((Field)Tables.CUSTOM_FIELD_BINDING.POSITION));
    }

    @Override
    public List<BoundProjectToCufDto> findAllBoundProjectsByCufId(Long cufId) {
        return this.dsl.select((SelectField)Tables.CUSTOM_FIELD_BINDING.CFB_ID.as("CUSTOM_FIELD_BINDING_ID"), (SelectField)Tables.CUSTOM_FIELD_BINDING.BOUND_ENTITY.as("BINDABLE_ENTITY"), (SelectField)Tables.PROJECT.PROJECT_ID, (SelectField)Tables.PROJECT.NAME.as("PROJECT_NAME")).from((TableLike)Tables.CUSTOM_FIELD_BINDING).innerJoin((TableLike)Tables.PROJECT).on(Tables.CUSTOM_FIELD_BINDING.BOUND_PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).where(Tables.CUSTOM_FIELD_BINDING.CF_ID.eq((Object)cufId)).orderBy((OrderField)Tables.PROJECT.PROJECT_ID, (OrderField)Tables.CUSTOM_FIELD_BINDING.CFB_ID).fetchInto(BoundProjectToCufDto.class);
    }

    private static /* synthetic */ ResultQuery lambda$4(ResultQuery resultQuery) {
        return resultQuery;
    }
}

