/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.attachment.Attachment;
import org.squashtest.tm.domain.attachment.AttachmentHolder;
import org.squashtest.tm.domain.attachment.AttachmentList;
import org.squashtest.tm.domain.projectimporter.PivotFormatImport;
import org.squashtest.tm.exception.pivot.projectimporter.pivotimporter.AttachmentZipException;
import org.squashtest.tm.service.attachment.AttachmentManagerService;
import org.squashtest.tm.service.attachment.RawAttachment;
import org.squashtest.tm.service.attachment.UploadedData;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AbstractPivotObject;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AttachmentPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.PivotAttachmentEntity;
import org.squashtest.tm.service.internal.dto.projectimporter.AttachmentPivotHolder;
import org.squashtest.tm.service.internal.dto.projectimporter.ContentConversionPivotHolder;
import org.squashtest.tm.service.internal.dto.projectimporter.ImportWarningEntry;
import org.squashtest.tm.service.internal.dto.projectimporter.PivotImportMetadata;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.AttachmentPivotType;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.PivotFormatLoggerHelper;
import org.squashtest.tm.service.pivot.projectimporter.pivotimporter.AttachmentPivotImportService;

@Service
public class AttachmentPivotImportServiceImpl
implements AttachmentPivotImportService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AttachmentPivotImportService.class);
    private static final String PATH_SEPARATOR = "/";
    private final AttachmentManagerService attachmentManagerService;

    public AttachmentPivotImportServiceImpl(AttachmentManagerService attachmentManagerService) {
        this.attachmentManagerService = attachmentManagerService;
    }

    @Override
    public <E extends AttachmentHolder, P extends AbstractPivotObject> Map<Long, Long> addAttachmentsToEntity(AttachmentPivotHolder<E, P> holder, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        HashMap<Long, Long> attachmentConversion = new HashMap<Long, Long>();
        File importFile = new File(pivotFormatImport.getFilePath());
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (ZipFile zipFile = new ZipFile(importFile);){
                this.addAttachmentsToEntity(zipFile, holder, attachmentConversion, pivotImportMetadata, pivotFormatImport);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            LOGGER.error("Could not open zip file to find attachments", (Throwable)ex);
            throw new AttachmentZipException((Exception)ex);
        }
        return attachmentConversion;
    }

    private <E extends AttachmentHolder, P extends AbstractPivotObject> void addAttachmentsToEntity(ZipFile zipFile, AttachmentPivotHolder<E, P> holder, Map<Long, Long> attachmentConversion, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        for (AttachmentPivot attachmentPivot : ((PivotAttachmentEntity)holder.entityPivot()).getAttachments()) {
            if (Objects.nonNull(attachmentPivot.getContentId()) && holder.contentConversion().containsKey(attachmentPivot.getContentId())) {
                this.createAttachmentWithExistingContent(holder, attachmentPivot, attachmentConversion, pivotImportMetadata);
                continue;
            }
            this.createAttachmentWithNewContent(zipFile, holder, attachmentPivot, attachmentConversion, pivotImportMetadata, pivotFormatImport);
        }
    }

    private <E extends AttachmentHolder, P extends AbstractPivotObject> void createAttachmentWithExistingContent(AttachmentPivotHolder<E, P> holder, AttachmentPivot attachmentPivot, Map<Long, Long> attachmentConversion, PivotImportMetadata pivotImportMetadata) {
        ContentConversionPivotHolder contentConversion = holder.contentConversion().get(attachmentPivot.getContentId());
        Attachment newAttachment = this.attachmentManagerService.addCopyAttachment(holder.entity().getAttachmentList(), contentConversion.attachment(), attachmentPivot.getAddedOn(), attachmentPivot.getLastModifiedOn());
        attachmentConversion.put(attachmentPivot.pivotIdToSquashId(), newAttachment.getId());
        attachmentConversion.putIfAbsent(contentConversion.oldAttachmentId(), newAttachment.getId());
        this.gatherContentIds(attachmentPivot, newAttachment, holder.holderType(), pivotImportMetadata);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <E extends AttachmentHolder, P extends AbstractPivotObject> void createAttachmentWithNewContent(ZipFile zipFile, AttachmentPivotHolder<E, P> holder, AttachmentPivot attachmentPivot, Map<Long, Long> attachmentConversion, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        String attachmentPath = this.getAttachmentPathByHolderType(attachmentPivot, holder.holderType());
        ZipEntry zipEntry = zipFile.getEntry(attachmentPath);
        if (Objects.isNull(zipEntry)) {
            PivotFormatLoggerHelper.handleAttachmentNotFound(LOGGER, attachmentPath, holder.holderType(), holder.getPivotId(), pivotFormatImport, pivotImportMetadata);
            return;
        }
        try {
            Throwable throwable = null;
            Object var10_12 = null;
            try {
                InputStream zipFileInputStream = zipFile.getInputStream(zipEntry);
                try {
                    try (InputStream convertedInputStream = this.convertZipInputStreamToByteArrayInputStream(zipFileInputStream);){
                        UploadedData data = new UploadedData(convertedInputStream, attachmentPivot.getOriginalFileName(), zipEntry.getSize());
                        this.checkAttachmentType(data, holder.holderType(), holder.getPivotId(), pivotImportMetadata.getAttachmentTypeWhiteList(), pivotFormatImport);
                        this.checkAttachmentMaxSize(data, pivotImportMetadata.getMaxAttachmentSize(), holder.holderType(), holder.getPivotId(), pivotFormatImport);
                        Attachment attachment = this.attachmentManagerService.addAttachment(holder.entity().getAttachmentList(), (RawAttachment)data, attachmentPivot.getAddedOn(), attachmentPivot.getLastModifiedOn());
                        attachmentConversion.put(attachmentPivot.pivotIdToSquashId(), attachment.getId());
                        this.gatherContentIds(attachmentPivot, attachment, holder.holderType(), pivotImportMetadata);
                    }
                    if (zipFileInputStream == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (zipFileInputStream == null) throw throwable;
                    zipFileInputStream.close();
                    throw throwable;
                }
                zipFileInputStream.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            LOGGER.error("Import {} - Could not add attachment \"{}\" for entity type {}", new Object[]{pivotFormatImport.getId(), attachmentPivot.getZipImportFileName(), holder.holderType(), ex});
            pivotImportMetadata.addImportWarningEntry(ImportWarningEntry.attachmentError(holder.holderType(), attachmentPivot.getOriginalFileName(), pivotImportMetadata.getCurrentImportFile(), ex.getMessage()));
        }
    }

    private void gatherContentIds(AttachmentPivot attachmentPivot, Attachment attachment, EntityType entityType, PivotImportMetadata pivotImportMetadata) {
        if (!EntityType.TEST_CASE.equals((Object)entityType) && !EntityType.TEST_STEP.equals((Object)entityType)) {
            return;
        }
        pivotImportMetadata.getContentConversionByOldContentId().put(attachmentPivot.getContentId(), new ContentConversionPivotHolder(attachmentPivot.getContentId(), attachment.getContent().getId(), attachmentPivot.pivotIdToSquashId(), attachment.getId()));
    }

    @Override
    public String updateRichText(String richText, AttachmentList attachmentList, Map<Long, Long> attachmentConversion, PivotImportMetadata pivotImportMetadata) {
        if (StringUtils.isEmpty((CharSequence)richText)) {
            return richText;
        }
        return this.attachmentManagerService.handleRichTextAttachmentsWithNewUrl(richText, attachmentList, attachmentConversion, pivotImportMetadata.getBaseUrl());
    }

    private InputStream convertZipInputStreamToByteArrayInputStream(InputStream zipFileInputStream) throws IOException {
        byte[] bytes = zipFileInputStream.readAllBytes();
        return new ByteArrayInputStream(bytes);
    }

    private void checkAttachmentType(UploadedData data, EntityType holderType, String holderPivotId, List<String> attachmentWhiteList, PivotFormatImport pivotFormatImport) {
        String fileType = FilenameUtils.getExtension((String)data.getName());
        boolean isAllowed = attachmentWhiteList.stream().anyMatch(type -> type.equalsIgnoreCase(fileType));
        if (!isAllowed) {
            PivotFormatLoggerHelper.handleAttachmentTypeNotAllowed(LOGGER, fileType, data.getName(), holderType, holderPivotId, pivotFormatImport);
        }
    }

    private void checkAttachmentMaxSize(UploadedData data, Long maxAllowedSize, EntityType holderType, String holderPivotId, PivotFormatImport pivotFormatImport) {
        if (data.getSizeInBytes() > maxAllowedSize) {
            PivotFormatLoggerHelper.handleAttachmentMaxSizeExceeded(LOGGER, data.getName(), data.getSizeInBytes(), maxAllowedSize, holderType, holderPivotId, pivotFormatImport);
        }
    }

    private String getAttachmentPathByHolderType(AttachmentPivot attachment, EntityType holderType) {
        AttachmentPivotType attachmentPivotType = AttachmentPivotType.getAttachmentPivotTypeFromEntityType(holderType);
        return "attachments/" + attachmentPivotType.getDirectoryName() + PATH_SEPARATOR + attachment.getZipImportFileName();
    }
}

