/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.jsonpathextractor;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.stereotype.Component;
import org.squashtest.tm.service.jsonpathextractor.JsonPathExtractor;

@Component
public class JsonPathExtractorImpl
implements JsonPathExtractor {
    static final Pattern validJsonPathPattern = Pattern.compile("((\\p{L}|\\d|_)+|\\[\\d+])(\\.(\\p{L}|\\d|_)+|\\[\\d+])*");
    private static final ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public boolean isPathValid(String path) {
        return validJsonPathPattern.matcher(path).matches();
    }

    public static String extract(String json, String path) throws IOException {
        JsonNode rootNode = objectMapper.readTree(json);
        return JsonPathExtractorImpl.extract(rootNode, JsonPathExtractorImpl.split(path), 0).asText();
    }

    private static JsonNode extract(JsonNode node, List<String> pathParts, int startIndex) {
        if (startIndex == pathParts.size()) {
            return node;
        }
        String part = pathParts.get(startIndex);
        if (part.startsWith("[")) {
            int index = Integer.parseInt(part.substring(1, part.length() - 1));
            return JsonPathExtractorImpl.extract(node.get(index), pathParts, startIndex + 1);
        }
        return JsonPathExtractorImpl.extract(node.get(part), pathParts, startIndex + 1);
    }

    private static List<String> split(String str) {
        Matcher m = Pattern.compile("\\[\\d+]|\\w+").matcher(str);
        ArrayList<String> matches = new ArrayList<String>();
        while (m.find()) {
            matches.add(m.group());
        }
        return matches;
    }
}

