/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.sprint;

import java.util.Collections;
import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.domain.campaign.SprintReqVersion;
import org.squashtest.tm.service.annotation.CheckEntityExists;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.display.sprint.SprintReqVersionDisplayService;
import org.squashtest.tm.service.internal.bugtracker.knownissues.local.SprintReqVersionKnownIssueFinder;
import org.squashtest.tm.service.internal.display.dto.UserView;
import org.squashtest.tm.service.internal.display.dto.sprint.AvailableTestPlanItemDto;
import org.squashtest.tm.service.internal.display.dto.sprint.AvailableTestPlanItemIdsDto;
import org.squashtest.tm.service.internal.display.dto.sprint.SprintReqVersionDto;
import org.squashtest.tm.service.internal.display.dto.sprint.SprintReqVersionView;
import org.squashtest.tm.service.internal.repository.display.SprintReqVersionDisplayDao;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.testplanitem.TestPlanItemAssignableUserFinder;

@Service
public class SprintReqVersionDisplayServiceImpl
implements SprintReqVersionDisplayService {
    private final SprintReqVersionDisplayDao sprintReqVersionDisplayDao;
    private final SprintReqVersionKnownIssueFinder sprintReqVersionKnownIssueFinder;
    private final PermissionEvaluationService permissionEvaluationService;
    private final TestPlanItemAssignableUserFinder testPlanItemAssignableUserFinder;

    public SprintReqVersionDisplayServiceImpl(SprintReqVersionDisplayDao sprintReqVersionDisplayDao, SprintReqVersionKnownIssueFinder sprintReqVersionKnownIssueFinder, PermissionEvaluationService permissionEvaluationService, TestPlanItemAssignableUserFinder testPlanItemAssignableUserFinder) {
        this.sprintReqVersionDisplayDao = sprintReqVersionDisplayDao;
        this.sprintReqVersionKnownIssueFinder = sprintReqVersionKnownIssueFinder;
        this.permissionEvaluationService = permissionEvaluationService;
        this.testPlanItemAssignableUserFinder = testPlanItemAssignableUserFinder;
    }

    @Override
    @PreAuthorize(value="hasPermission(#sprintReqVersionId, 'org.squashtest.tm.domain.campaign.SprintReqVersion' ,'READ')  or hasRole('ROLE_ADMIN')")
    @CheckEntityExists(entityType=SprintReqVersion.class)
    public SprintReqVersionView findSprintReqVersionViewById(@Id long sprintReqVersionId) {
        SprintReqVersionView sprintReqVersionDto = this.sprintReqVersionDisplayDao.findSprintReqVersionViewById(sprintReqVersionId);
        int nbIssues = this.sprintReqVersionKnownIssueFinder.countKnownIssues(sprintReqVersionId);
        sprintReqVersionDto.setNbIssues(nbIssues);
        sprintReqVersionDto.setAssignableUsers(UserView.fromEntities(this.testPlanItemAssignableUserFinder.findAssignableUsersByCampaignLibraryId(sprintReqVersionDto.getCampaignLibraryId())));
        sprintReqVersionDto.setTestPlanItemExecutors(this.sprintReqVersionDisplayDao.getSprintReqVersionTestPlanItemExecutors(sprintReqVersionId));
        return sprintReqVersionDto;
    }

    @Override
    public List<SprintReqVersionDto> findSprintReqVersionDtosBySprintId(long sprintId) {
        return this.sprintReqVersionDisplayDao.findSprintReqVersionDtosBySprintId(sprintId);
    }

    @Override
    public List<SprintReqVersionDto> findSprintReqVersionDtosForDenormalization(long sprintId) {
        return this.sprintReqVersionDisplayDao.findSprintReqVersionDtosForDenormalization(sprintId);
    }

    @Override
    public List<AvailableTestPlanItemDto> findAvailableTestPlanItems(long sprintReqVersionId) {
        if (!this.permissionEvaluationService.hasRoleOrPermissionOnObject("ROLE_ADMIN", Permissions.LINK.name(), (Long)sprintReqVersionId, SprintReqVersion.class.getName())) {
            return Collections.emptyList();
        }
        return this.sprintReqVersionDisplayDao.findAvailableTestPlanItems(sprintReqVersionId);
    }

    @Override
    public List<AvailableTestPlanItemIdsDto> findAvailableTestPlanItemIds(long sprintReqVersionId) {
        return this.sprintReqVersionDisplayDao.findAvailableTestPlanItemIds(sprintReqVersionId);
    }
}

