/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.referential;

import com.google.common.collect.Multimap;
import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jooq.CommonTableExpression;
import org.jooq.Record1;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.csp.core.bugtracker.core.UnknownConnectorKindException;
import org.squashtest.csp.core.bugtracker.spi.BugTrackerProviderDescriptor;
import org.squashtest.tm.api.template.TemplateConfigurablePlugin;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.bdd.BddScriptLanguage;
import org.squashtest.tm.domain.bdd.Keyword;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.service.bugtracker.BugTrackersService;
import org.squashtest.tm.service.configuration.ConfigurationService;
import org.squashtest.tm.service.display.referential.ReferentialDataProvider;
import org.squashtest.tm.service.display.user.UserDisplayService;
import org.squashtest.tm.service.documentation.DocumentationLinkProvider;
import org.squashtest.tm.service.internal.bugtracker.BugTrackerConnectorFactory;
import org.squashtest.tm.service.internal.bugtracker.adapter.InternalBugtrackerConnector;
import org.squashtest.tm.service.internal.display.dto.BugTrackerBindingDto;
import org.squashtest.tm.service.internal.display.dto.BugTrackerDto;
import org.squashtest.tm.service.internal.display.dto.BugTrackerReferentialDto;
import org.squashtest.tm.service.internal.display.dto.GlobalConfigurationDto;
import org.squashtest.tm.service.internal.display.dto.KeywordDto;
import org.squashtest.tm.service.internal.display.dto.MilestoneBindingDto;
import org.squashtest.tm.service.internal.display.dto.MilestoneDto;
import org.squashtest.tm.service.internal.display.dto.ProjectDto;
import org.squashtest.tm.service.internal.display.dto.ProjectFilterDto;
import org.squashtest.tm.service.internal.display.dto.ProjectPermissionDto;
import org.squashtest.tm.service.internal.display.referential.AdminReferentialData;
import org.squashtest.tm.service.internal.display.referential.LicenseInformationDto;
import org.squashtest.tm.service.internal.display.referential.ReferentialData;
import org.squashtest.tm.service.internal.display.referential.TemplateConfigurablePluginDto;
import org.squashtest.tm.service.internal.dto.DetailedUserDto;
import org.squashtest.tm.service.internal.dto.UserDto;
import org.squashtest.tm.service.internal.repository.display.AclDisplayDao;
import org.squashtest.tm.service.internal.repository.display.AiServerDisplayDao;
import org.squashtest.tm.service.internal.repository.display.AutomatedTestTechnologyDisplayDao;
import org.squashtest.tm.service.internal.repository.display.CustomFieldDao;
import org.squashtest.tm.service.internal.repository.display.InfoListDisplayDao;
import org.squashtest.tm.service.internal.repository.display.MilestoneDisplayDao;
import org.squashtest.tm.service.internal.repository.display.ProjectAiConfigurationDisplayDao;
import org.squashtest.tm.service.internal.repository.display.ProjectDisplayDao;
import org.squashtest.tm.service.internal.repository.display.ProjectFilterDisplayDao;
import org.squashtest.tm.service.internal.repository.display.RequirementVersionLinkTypeDisplayDao;
import org.squashtest.tm.service.internal.repository.display.ScmServerDisplayDao;
import org.squashtest.tm.service.internal.repository.display.TestAutomationServerDisplayDao;
import org.squashtest.tm.service.internal.security.AuthenticationProviderContext;
import org.squashtest.tm.service.license.UltimateLicenseAvailabilityService;
import org.squashtest.tm.service.plugin.PluginFinderService;
import org.squashtest.tm.service.project.CustomProjectFinder;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.servers.ManageableCredentials;
import org.squashtest.tm.service.servers.StoredCredentialsManager;

@Service
@Transactional(readOnly=true)
public class ReferentialDataProviderImpl
implements ReferentialDataProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReferentialDataProviderImpl.class);
    @Value(value="${squash.rest-api.jwt.secret:#{null}}")
    private String jwtSecret;
    @Value(value="${squash.cloud-mode-enabled:false}")
    private boolean cloudModeEnabled;
    @Inject
    private CustomProjectFinder projectFinder;
    @Inject
    private ProjectFilterDisplayDao projectFilterDao;
    @Inject
    private ProjectDisplayDao projectDao;
    @Inject
    private MilestoneDisplayDao milestoneDao;
    @Inject
    private CustomFieldDao customFieldDao;
    @Inject
    private InfoListDisplayDao infoListDao;
    @Inject
    private ConfigurationService configurationService;
    @Inject
    private AclDisplayDao aclDisplayDao;
    @Inject
    private BugTrackersService bugTrackersService;
    @Inject
    private TestAutomationServerDisplayDao testAutomationServerDisplayDao;
    @Inject
    private UserDisplayService userDisplayService;
    @Inject
    private RequirementVersionLinkTypeDisplayDao requirementVersionLinkTypeDisplayDao;
    @Inject
    private MessageSource translateService;
    @Inject
    private AutomatedTestTechnologyDisplayDao automatedTestTechnologyDisplayDao;
    @Inject
    private ScmServerDisplayDao scmServerDisplayDao;
    @Inject
    private AuthenticationProviderContext authenticationProviderContext;
    @Inject
    private PluginFinderService pluginFinderService;
    @Inject
    private BugTrackerConnectorFactory bugTrackerConnectorFactory;
    @Inject
    private UltimateLicenseAvailabilityService ultimateLicenseService;
    @Inject
    private AiServerDisplayDao aiServerDisplayDao;
    @Inject
    private PermissionEvaluationService permissionEvaluationService;
    @Inject
    private StoredCredentialsManager storedCredentialsManager;
    @Inject
    private ProjectAiConfigurationDisplayDao projectAiConfigurationDisplayDao;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired(required=false)
    private final Collection<TemplateConfigurablePlugin> templatePlugins = Collections.emptyList();
    @Autowired(required=false)
    private final Collection<DocumentationLinkProvider> documentationLinkProviders = Collections.emptyList();

    @Override
    public AdminReferentialData findAdminReferentialData() {
        DetailedUserDto currentUser = this.userDisplayService.findCurrentUser();
        this.permissionEvaluationService.checkAtLeastOneProjectManagementPermissionOrAdmin(currentUser.getPartyIds());
        AdminReferentialData referentialData = new AdminReferentialData();
        referentialData.setUser(currentUser);
        this.appendConfiguration(referentialData);
        this.appendCustomFields(referentialData);
        this.appendAvailableTestAutomationServerKinds(referentialData);
        this.appendAvailableScmServerKinds(referentialData);
        this.appendAiServers(referentialData);
        referentialData.setCanManageLocalPassword(this.authenticationProviderContext.isInternalProviderEnabled());
        this.appendTemplateConfigurablePlugins(referentialData);
        this.appendBugTrackers(referentialData);
        referentialData.setDocumentationLinks(this.getAllDocumentationLinks());
        referentialData.setPremiumPluginInstalled(this.isPremiumPluginInstalled());
        referentialData.setUltimateLicenseAvailable(this.isUltimateLicenseAvailable());
        referentialData.setJwtSecretDefined(this.jwtSecret != null);
        referentialData.setCloudModeEnabled(this.cloudModeEnabled);
        return referentialData;
    }

    @Override
    public ReferentialData findReferentialData() {
        ReferentialData referentialData = new ReferentialData();
        this.appendUser(referentialData);
        CommonTableExpression<Record1<Long>> projectIdsCte = this.projectFinder.findAllReadableIdsCte(referentialData.getUser());
        if (this.projectFinder.checkHasAtLeastOneReadableId(projectIdsCte)) {
            this.addProjectFilter(referentialData, referentialData.getUser());
            this.appendProjects(referentialData, referentialData.getUser(), projectIdsCte);
            this.appendInterProjectData(referentialData);
            this.appendRequirementVersionLinkTypes(referentialData);
            referentialData.setProjectPermissions(this.findProjectPermissions(referentialData.getUser()));
            this.appendTemplateConfigurablePlugins(referentialData);
        }
        referentialData.setDocumentationLinks(this.getAllDocumentationLinks());
        this.appendConfiguration(referentialData);
        this.appendBugTrackers(referentialData);
        referentialData.setCanManageLocalPassword(this.authenticationProviderContext.isInternalProviderEnabled());
        referentialData.setPremiumPluginInstalled(this.isPremiumPluginInstalled());
        referentialData.setUltimateLicenseAvailable(this.isUltimateLicenseAvailable());
        referentialData.setJwtSecretDefined(this.jwtSecret != null);
        return referentialData;
    }

    private void appendScmServers(ReferentialData referentialData) {
        referentialData.setScmServers(this.scmServerDisplayDao.findAll());
    }

    private void appendRequirementVersionLinkTypes(ReferentialData referentialData) {
        referentialData.setRequirementVersionLinkTypes(this.requirementVersionLinkTypeDisplayDao.findAll());
    }

    private void appendInterProjectData(ReferentialData referentialData) {
        this.appendInfoLists(referentialData);
        this.appendCustomFields(referentialData);
        this.appendMilestones(referentialData);
        this.appendAutomationServers(referentialData);
        this.appendAutomatedTestTechnologies(referentialData);
        this.appendScmServers(referentialData);
    }

    private void appendAutomatedTestTechnologies(ReferentialData referentialData) {
        referentialData.setAutomatedTestTechnologies(this.automatedTestTechnologyDisplayDao.findAll());
    }

    private void appendUser(AdminReferentialData referentialData) {
        DetailedUserDto currentUser = this.userDisplayService.findCurrentUser();
        referentialData.setUser(currentUser);
        referentialData.setAdmin(currentUser.isAdmin());
    }

    private void appendConfiguration(AdminReferentialData referentialData) {
        Map<String, String> coreConfig = this.configurationService.findAllConfiguration();
        referentialData.setGlobalConfiguration(GlobalConfigurationDto.create(coreConfig));
        this.appendLicenseInformation(referentialData, coreConfig);
        referentialData.setCallbackUrl(coreConfig.getOrDefault("squashtest.tm.callbackurl", null));
    }

    private void appendAutomationServers(ReferentialData referentialData) {
        referentialData.setAutomationServers(this.testAutomationServerDisplayDao.findAll());
    }

    private void appendBugTrackers(AdminReferentialData referentialData) {
        List bugTrackers = this.entityManager.createQuery("SELECT bt FROM BugTracker bt").getResultList();
        referentialData.setBugTrackers(this.mapToBugTrackerReferentialDtos(bugTrackers));
    }

    private List<BugTrackerReferentialDto> mapToBugTrackerReferentialDtos(List<BugTracker> bugTrackers) {
        Set<String> registeredKinds = this.bugTrackerConnectorFactory.getProviderKinds();
        return bugTrackers.stream().map(bugTracker -> {
            BugTrackerDto btDto = BugTrackerDto.from(bugTracker);
            BugTrackerReferentialDto refDto = BugTrackerReferentialDto.from(btDto);
            if (registeredKinds.contains(refDto.getKind())) {
                this.appendMessageKeysAndCacheInfo((BugTracker)bugTracker, refDto);
            }
            return refDto;
        }).toList();
    }

    private void appendMessageKeysAndCacheInfo(BugTracker bugTracker, BugTrackerReferentialDto refDto) {
        try {
            InternalBugtrackerConnector bugTrackerConnector = this.bugTrackerConnectorFactory.createConnector(bugTracker);
            refDto.setLoginFieldKey(bugTrackerConnector.getKeyForLogin(bugTracker));
            refDto.setPasswordFieldKey(bugTrackerConnector.getKeyForPassword(bugTracker));
            BugTrackerProviderDescriptor providerDescriptor = this.bugTrackersService.getProviderDescriptor(refDto.getKind());
            refDto.setUseProjectPaths(providerDescriptor.usePathToProjects());
            refDto.setProjectHelpMessage(providerDescriptor.getProjectHelpMessage());
            refDto.setCacheAllowed(bugTrackerConnector.allowsReportingCache());
            ManageableCredentials cacheCredentials = this.storedCredentialsManager.findReportingCacheCredentials(bugTracker.getId());
            refDto.setCacheConfigured(cacheCredentials != null);
        }
        catch (UnknownConnectorKindException ex) {
            String warnMessage = String.format("Cannot find provider for BugTracker kind %s, referential data may be incomplete.", refDto.getKind());
            LOGGER.warn(warnMessage, (Throwable)ex);
        }
    }

    private void appendCustomFields(AdminReferentialData referentialData) {
        referentialData.setCustomFields(this.customFieldDao.findAllWithPossibleValues());
    }

    private void appendInfoLists(ReferentialData referentialData) {
        referentialData.setInfoLists(this.infoListDao.findAllWithItems());
    }

    private void appendProjects(ReferentialData referentialData, UserDto currentUser, CommonTableExpression<Record1<Long>> projectIdsCte) {
        List<ProjectDto> projects = this.projectDao.getActiveProjectsByIds(projectIdsCte);
        this.customFieldDao.appendCustomFieldBindings(projects, projectIdsCte);
        this.appendBugTrackerBindings(projects);
        this.milestoneDao.appendMilestoneBinding(projects, projectIdsCte);
        this.appendProjectPermissions(projects, currentUser);
        this.appendDisabledExecutionStatus(projects, projectIdsCte);
        this.appendTranslatedKeywords(projects);
        referentialData.setProjects(projects);
        this.projectDao.appendActivatedPlugins(projects);
    }

    private void appendBugTrackerBindings(List<ProjectDto> projects) {
        projects.stream().filter(project -> project.getBugtrackerId() != null).forEach(projectId -> {
            BugTrackerBindingDto bugTrackerBindingDto = new BugTrackerBindingDto();
            bugTrackerBindingDto.setBugTrackerId(projectId.getBugtrackerId());
            bugTrackerBindingDto.setProjectId(projectId.getId());
            projectId.setBugTrackerBinding(bugTrackerBindingDto);
        });
    }

    private void appendMilestones(ReferentialData referentialData) {
        Set<Long> milestoneIds = referentialData.getProjects().stream().flatMap(projectDto -> projectDto.getMilestoneBindings().stream().map(MilestoneBindingDto::getMilestoneId)).collect(Collectors.toSet());
        List<MilestoneDto> milestones = this.milestoneDao.findByIds(milestoneIds);
        referentialData.setMilestones(milestones);
    }

    private void appendDisabledExecutionStatus(List<ProjectDto> projects, CommonTableExpression<Record1<Long>> projectIdsCte) {
        if (!projects.isEmpty()) {
            Map<Long, List<String>> disabledExecutionStatus = this.projectDao.getDisabledExecutionStatus(projectIdsCte);
            projects.stream().filter(project -> disabledExecutionStatus.containsKey(project.getId())).forEach(projectDto -> {
                List disabledStatus = (List)disabledExecutionStatus.get(projectDto.getId());
                projectDto.setDisabledExecutionStatus(disabledStatus);
            });
        }
    }

    private void appendProjectPermissions(List<ProjectDto> projects, UserDto currentUser) {
        if (!projects.isEmpty()) {
            List<Long> projectIds = projects.stream().map(ProjectDto::getId).toList();
            Map<Long, Multimap<String, String>> permissions = this.aclDisplayDao.findPermissions(projectIds, currentUser.getPartyIds());
            projects.stream().filter(project -> permissions.containsKey(project.getId())).forEach(project -> project.setPermissions(((Multimap)permissions.get(project.getId())).asMap()));
        }
    }

    private void appendTranslatedKeywords(List<ProjectDto> projects) {
        projects.forEach(project -> {
            Locale locale = BddScriptLanguage.valueOf((String)project.getBddScriptLanguage()).getLocale();
            project.setKeywords(this.getTranslatedKeywordsList(locale));
        });
    }

    private List<KeywordDto> getTranslatedKeywordsList(Locale locale) {
        return Arrays.stream(Keyword.values()).map(keyword -> new KeywordDto(keyword.name(), this.translateService.getMessage(keyword.i18nKeywordNameKey(), null, locale))).toList();
    }

    private void addProjectFilter(ReferentialData referentialData, UserDto currentUser) {
        ProjectFilterDto projectFilter = this.projectFilterDao.getProjectFilterByUserLogin(currentUser.getUsername());
        if (Objects.nonNull(projectFilter)) {
            referentialData.setProjectFilterStatus(projectFilter.getActivated());
            List<Long> projectsIds = this.projectFilterDao.getProjectIdsByProjectFilter(projectFilter.getId());
            referentialData.setFilteredProjectIds(projectsIds);
        }
    }

    private void appendLicenseInformation(AdminReferentialData referentialData, Map<String, String> coreConfig) {
        LicenseInformationDto licenseInfo = new LicenseInformationDto();
        licenseInfo.setPluginLicenseExpiration(coreConfig.getOrDefault("plugin.license.expiration", null));
        licenseInfo.setActivatedUserExcess(coreConfig.getOrDefault("activated.user.excess", null));
        referentialData.setLicenseInformation(licenseInfo);
    }

    private void appendAvailableTestAutomationServerKinds(AdminReferentialData referentialData) {
        referentialData.setAvailableTestAutomationServerKinds(this.testAutomationServerDisplayDao.findAllAvailableKinds());
    }

    private void appendAvailableScmServerKinds(AdminReferentialData referentialData) {
        referentialData.setAvailableScmServerKinds(this.scmServerDisplayDao.findAllAvailableKinds());
    }

    private void appendTemplateConfigurablePlugins(AdminReferentialData referentialData) {
        referentialData.setTemplateConfigurablePlugins(this.templatePlugins.stream().map(TemplateConfigurablePluginDto::fromTemplateConfigurablePlugin).toList());
    }

    private boolean isPremiumPluginInstalled() {
        return this.pluginFinderService.isPremiumPluginInstalled();
    }

    private boolean isUltimateLicenseAvailable() {
        return this.ultimateLicenseService.isAvailable();
    }

    private List<DocumentationLinkProvider.Link> getAllDocumentationLinks() {
        return this.documentationLinkProviders.stream().flatMap(provider -> provider.getDocumentationLinks().stream()).toList();
    }

    private List<ProjectPermissionDto> findProjectPermissions(UserDto currentUser) {
        return this.userDisplayService.getAllProjectPermissionsUnsecured(currentUser.getUsername());
    }

    private void appendAiServers(AdminReferentialData adminReferentialData) {
        adminReferentialData.setAiServers(this.aiServerDisplayDao.findAll());
    }
}

