/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.grid.filters;

import java.util.List;
import java.util.Objects;
import org.jooq.Condition;
import org.jooq.Field;
import org.squashtest.tm.service.internal.display.grid.GridFilterValue;
import org.squashtest.tm.service.internal.display.grid.filters.GridFilterConditionBuilder;

public class EqualConditionBuilder
implements GridFilterConditionBuilder {
    private final Field<?> field;
    private final GridFilterValue gridFilterValue;
    private final boolean invert;

    EqualConditionBuilder(Field<?> field, GridFilterValue gridFilterValue, boolean invert) {
        Objects.requireNonNull(field);
        Objects.requireNonNull(gridFilterValue);
        List<String> values = gridFilterValue.getValues();
        if (values.isEmpty()) {
            throw new IllegalArgumentException("At least one value is required to build a equal condition");
        }
        this.field = field;
        this.gridFilterValue = gridFilterValue;
        this.invert = invert;
    }

    @Override
    public Condition build() {
        List<String> values = this.gridFilterValue.getValues();
        if (this.invert) {
            return this.field.notEqualIgnoreCase(values.get(0));
        }
        return this.field.equalIgnoreCase(values.get(0));
    }
}

