/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.testcase.scripted;

import org.apache.commons.lang3.StringUtils;
import org.springframework.context.MessageSource;
import org.squashtest.tm.domain.bdd.BddImplementationTechnology;
import org.squashtest.tm.domain.testcase.KeywordTestCase;
import org.squashtest.tm.service.internal.testcase.bdd.BddScriptWriter;
import org.squashtest.tm.service.internal.testcase.bdd.CucumberScriptWriter;
import org.squashtest.tm.service.internal.testcase.bdd.RobotScriptWriter;

public enum KeywordTestCaseToFileStrategy {
    CUCUMBER_STRATEGY{

        @Override
        public String getExtension() {
            return "feature";
        }

        @Override
        public BddScriptWriter getScriptWriter() {
            return new CucumberScriptWriter();
        }
    }
    ,
    ROBOT_STRATEGY{

        @Override
        public String getExtension() {
            return "robot";
        }

        @Override
        public BddScriptWriter getScriptWriter() {
            return new RobotScriptWriter();
        }
    };

    public static final int FILENAME_MAX_SIZE = 100;
    private static final String ILLEGAL_PATTERN = "[^a-zA-Z0-9\\_\\-]";

    public static KeywordTestCaseToFileStrategy strategyFor(BddImplementationTechnology bddImplementationTechnology) {
        return switch (bddImplementationTechnology) {
            case BddImplementationTechnology.CUCUMBER_4, BddImplementationTechnology.CUCUMBER_5_PLUS -> CUCUMBER_STRATEGY;
            case BddImplementationTechnology.ROBOT -> ROBOT_STRATEGY;
            default -> throw new IllegalArgumentException("Unimplemented script dumping strategy for bdd implementation: '" + String.valueOf(bddImplementationTechnology) + "'");
        };
    }

    public abstract String getExtension();

    public abstract BddScriptWriter getScriptWriter();

    public String buildFilenameMatchPattern(KeywordTestCase testCase) {
        Long id = testCase.getId();
        String extension = this.getExtension();
        return String.format("%d(_.*)?\\.%s", id, extension);
    }

    public String createFilenameFor(KeywordTestCase testCase) {
        String extension = this.getExtension();
        String normalized = this.baseNameFromTestCase(testCase);
        String caped = StringUtils.substring((String)normalized, (int)0, (int)(100 - (extension.length() + 1)));
        return caped + "." + extension;
    }

    public String backupFilenameFor(KeywordTestCase testCase) {
        return String.valueOf(testCase.getId()) + "." + this.getExtension();
    }

    public String getWritableFileContent(KeywordTestCase testCase, MessageSource messageSource, boolean escapeArrows) {
        return this.getScriptWriter().writeBddScript(testCase, messageSource, escapeArrows);
    }

    private String baseNameFromTestCase(KeywordTestCase testCase) {
        String name = testCase.getName();
        Long id = testCase.getId();
        String deaccented = StringUtils.stripAccents((String)name);
        String normalized = deaccented.replaceAll(ILLEGAL_PATTERN, "_");
        return String.valueOf(id) + "_" + normalized;
    }
}

