/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.Record1;
import org.jooq.Record3;
import org.jooq.Record4;
import org.jooq.Record5;
import org.jooq.Record7;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.TclnRelationshipClosure;
import org.squashtest.tm.service.internal.display.dto.PathNodeDto;
import org.squashtest.tm.service.internal.repository.display.EntityPathHeaderDao;

@Repository
public class EntityPathHeaderDaoImpl
implements EntityPathHeaderDao {
    private static final String PATH_SEPARATOR = " > ";
    private static final String PROJECT_NAME = "PROJECT_NAME";
    private static final String NODE_NAME = "NODE_NAME";
    private static final String DEPTH = "DEPTH";
    private static final String PATH_TABLE = "PATH_TABLE";
    private static final String PATH = "PATH";
    private static final String TCLN_ID = "TCLN_ID";
    private static final String PROJECT_ID = "PROJECT_ID";
    private static final String FULL_PATH = "PROJECT_ID";
    @Inject
    private DSLContext dslContext;

    @Override
    public Map<Long, String> buildRequirementPathByIds(Collection<Long> requirementIds) {
        return this.dslContext.select((SelectField)Tables.REQUIREMENT.RLN_ID, (SelectField)DSL.concat((Field[])new Field[]{DSL.value((String)"/"), Tables.PROJECT.NAME, DSL.value((String)"/"), DSL.groupConcat((Field)Tables.RESOURCE.NAME).orderBy(new OrderField[]{Tables.RLN_RELATIONSHIP_CLOSURE.DEPTH.desc()}).separator("/")}).cast(SQLDataType.VARCHAR((int)10000)).as(PATH)).from((TableLike)Tables.PROJECT).innerJoin((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).on(Tables.PROJECT.PROJECT_ID.eq((Field)Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID)).innerJoin((TableLike)Tables.REQUIREMENT).on(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq((Field)Tables.REQUIREMENT.RLN_ID)).innerJoin((TableLike)Tables.RLN_RELATIONSHIP_CLOSURE).on(Tables.REQUIREMENT.RLN_ID.eq((Field)Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID)).innerJoin((TableLike)Tables.RLN_RESOURCE).on(Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.eq((Field)Tables.RLN_RESOURCE.RLN_ID)).innerJoin((TableLike)Tables.RESOURCE).on(Tables.RLN_RESOURCE.RES_ID.eq((Field)Tables.RESOURCE.RES_ID)).where(Tables.REQUIREMENT.RLN_ID.in(requirementIds)).groupBy(new GroupField[]{Tables.PROJECT.NAME, Tables.REQUIREMENT.RLN_ID}).fetchMap((Field)Tables.REQUIREMENT.RLN_ID, DSL.field((String)PATH, String.class));
    }

    @Override
    public String buildCampaignLibraryNodePathHeader(Long nodeId) {
        Table nodeTable = this.dslContext.select((SelectField)Tables.PROJECT.NAME.as(PROJECT_NAME), (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.NAME.as(NODE_NAME), (SelectField)Tables.CLN_RELATIONSHIP_CLOSURE.DEPTH.as(DEPTH)).from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).leftJoin((TableLike)Tables.PROJECT).on(Tables.PROJECT.PROJECT_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID)).leftJoin((TableLike)Tables.CLN_RELATIONSHIP_CLOSURE).on(Tables.CLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.CLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID).and(Tables.CLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.eq((Object)nodeId)).and(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.notEqual((Object)nodeId))).asTable();
        return this.buildPathHeader(nodeId, nodeTable, Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID, Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID);
    }

    @Override
    public String buildIterationPathHeader(Long iterationId) {
        Long campaignId = (Long)this.dslContext.select((SelectField)Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID).from((TableLike)Tables.CAMPAIGN_ITERATION).where(Tables.CAMPAIGN_ITERATION.ITERATION_ID.eq((Object)iterationId)).fetchOneInto(Long.class);
        return (String)this.dslContext.select(this.concatPathFromParent(this.buildCampaignLibraryNodePathHeader(campaignId), Tables.CAMPAIGN_LIBRARY_NODE.NAME)).from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).where(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Object)campaignId)).fetchOneInto(String.class);
    }

    @Override
    public String buildTestSuitePathHeader(Long testSuiteId) {
        Long iterationId = (Long)this.dslContext.select((SelectField)Tables.ITERATION_TEST_SUITE.ITERATION_ID).from((TableLike)Tables.ITERATION_TEST_SUITE).where(Tables.ITERATION_TEST_SUITE.TEST_SUITE_ID.eq((Object)testSuiteId)).fetchOneInto(Long.class);
        return this.buildIterationChildPath(iterationId);
    }

    private boolean executionIsInsideSprint(Long executionId) {
        Long testPlanItemId = (Long)this.dslContext.select((SelectField)Tables.EXECUTION.TEST_PLAN_ITEM_ID).from((TableLike)Tables.EXECUTION).innerJoin((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.EXECUTION.TEST_PLAN_ITEM_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).innerJoin((TableLike)Tables.SPRINT_REQ_VERSION).on(Tables.SPRINT_REQ_VERSION.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ID)).where(Tables.EXECUTION.EXECUTION_ID.eq((Object)executionId)).fetchOneInto(Long.class);
        return Objects.nonNull(testPlanItemId);
    }

    private List<Long> getTestSuiteParentIdsForExecution(Long executionId) {
        return this.dslContext.select((SelectField)Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID).from((TableLike)Tables.TEST_SUITE_TEST_PLAN_ITEM).innerJoin((TableLike)Tables.EXECUTION).on(Tables.EXECUTION.TEST_PLAN_ITEM_ID.eq((Field)Tables.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID)).where(Tables.EXECUTION.EXECUTION_ID.eq((Object)executionId)).fetchInto(Long.class);
    }

    private Field<String> concatPathFromParent(String parentPath, TableField<?, String> parentField) {
        return DSL.concat((Field[])new Field[]{DSL.value((String)parentPath), DSL.value((String)PATH_SEPARATOR), parentField});
    }

    private String buildIterationChildPath(Long iterationId) {
        return (String)this.dslContext.select(this.concatPathFromParent(this.buildIterationPathHeader(iterationId), Tables.ITERATION.NAME)).from((TableLike)Tables.ITERATION).where(Tables.ITERATION.ITERATION_ID.eq((Object)iterationId)).fetchOneInto(String.class);
    }

    private String buildPathHeader(Long nodeId, Table<?> nodeTable, TableField<?, Long> entityFieldId, TableField<?, Long> entityFieldProjectId) {
        String path = this.buildPathFromNodeTable(nodeTable);
        if (Objects.nonNull(path)) {
            return path;
        }
        return this.getDefaultProjectPath(entityFieldId, entityFieldProjectId, nodeId);
    }

    private String buildPathFromNodeTable(Table<?> nodeTable) {
        return (String)this.dslContext.select((SelectField)DSL.concat((Field[])new Field[]{nodeTable.field(PROJECT_NAME), DSL.value((String)PATH_SEPARATOR), DSL.groupConcat((Field)nodeTable.field(NODE_NAME)).orderBy(new OrderField[]{nodeTable.field(DEPTH).desc()}).separator(PATH_SEPARATOR)})).from(nodeTable).groupBy(new GroupField[]{nodeTable.field(PROJECT_NAME)}).fetchOneInto(String.class);
    }

    private String getDefaultProjectPath(TableField<?, Long> entityFieldId, TableField<?, Long> entityFieldProjectId, Long entityId) {
        return (String)this.dslContext.select((SelectField)Tables.PROJECT.NAME).from((TableLike)entityFieldId.getTable()).leftJoin((TableLike)Tables.PROJECT).on(Tables.PROJECT.PROJECT_ID.eq(entityFieldProjectId)).where(entityFieldId.eq((Object)entityId)).fetchOneInto(String.class);
    }

    @Override
    public Map<Long, String> buildTestCasePathByIds(Collection<Long> testCaseIds) {
        return this.buildTestCasePathByIds(testCaseIds, PATH_SEPARATOR);
    }

    @Override
    public Map<Long, String> buildTestCasePathByIds(Collection<Long> testCaseIds, String separator) {
        short zero = 0;
        TclnRelationshipClosure descendant = Tables.TCLN_RELATIONSHIP_CLOSURE.as("descendant");
        Table path = DSL.select((SelectField)Tables.PROJECT.PROJECT_ID, (SelectField)Tables.PROJECT.NAME, (SelectField)Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID, (SelectField)DSL.groupConcat((Field)Tables.TEST_CASE_LIBRARY_NODE.NAME).orderBy(new OrderField[]{Tables.TCLN_RELATIONSHIP_CLOSURE.DEPTH.desc()}).separator(separator).as(PATH)).from((TableLike)Tables.TCLN_RELATIONSHIP_CLOSURE).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TCLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).innerJoin((TableLike)Tables.PROJECT).on(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).innerJoin((TableLike)descendant).on(Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.eq((Field)descendant.ANCESTOR_ID)).leftJoin((TableLike)Tables.TEST_CASE_FOLDER).on(descendant.DESCENDANT_ID.eq((Field)Tables.TEST_CASE_FOLDER.TCLN_ID).and(Tables.TCLN_RELATIONSHIP_CLOSURE.DEPTH.ne((Object)zero))).where(Tables.TEST_CASE_FOLDER.TCLN_ID.isNull()).groupBy(new GroupField[]{Tables.PROJECT.PROJECT_ID, Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID}).asTable(PATH_TABLE, new String[]{"PROJECT_ID", PROJECT_NAME, TCLN_ID, PATH});
        return this.dslContext.select((SelectField)path.field(TCLN_ID), (SelectField)DSL.concat((Field[])new Field[]{path.field(PROJECT_NAME), DSL.value((String)separator), path.field(PATH), DSL.when((Condition)Tables.TEST_CASE_FOLDER.TCLN_ID.isNotNull(), (Field)DSL.value((String)separator)).otherwise((Object)"")}).as("PROJECT_ID")).from((TableLike)path).leftJoin((TableLike)Tables.TEST_CASE_FOLDER).on(path.field(TCLN_ID, Long.class).eq((Field)Tables.TEST_CASE_FOLDER.TCLN_ID)).where(path.field(TCLN_ID, Long.class).in(testCaseIds)).fetchMap(DSL.field((String)TCLN_ID, Long.class), DSL.field((String)"PROJECT_ID", String.class));
    }

    @Override
    public List<PathNodeDto> getRequirementBreadcrumbNodes(Long nodeId) {
        List<PathNodeDto> crumbs = this.fetchRequirementClosureNodes(nodeId);
        PathNodeDto rootLibraryNode = this.fetchRequirementRootLibraryNode(nodeId);
        crumbs.addFirst(rootLibraryNode);
        return crumbs;
    }

    private List<PathNodeDto> fetchRequirementClosureNodes(Long nodeId) {
        return this.dslContext.select((SelectField)Tables.RESOURCE.NAME, (SelectField)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.as("ID"), (SelectField)DSL.when((Condition)Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID.isNotNull(), (Object)EntityType.HIGH_LEVEL_REQUIREMENT.name()).when(Tables.RESOURCE.RES_ID.eq((Field)Tables.REQUIREMENT_FOLDER.RES_ID), (Object)EntityType.REQUIREMENT_FOLDER.name()).otherwise((Object)EntityType.REQUIREMENT.name()).as("NODE_TYPE")).from((TableLike)Tables.RLN_RESOURCE).innerJoin((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).on(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq((Field)Tables.RLN_RESOURCE.RLN_ID)).innerJoin((TableLike)Tables.RESOURCE).on(Tables.RESOURCE.RES_ID.eq((Field)Tables.RLN_RESOURCE.RES_ID)).innerJoin((TableLike)Tables.RLN_RELATIONSHIP_CLOSURE).on(Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.eq((Field)Tables.RLN_RESOURCE.RLN_ID)).leftJoin((TableLike)Tables.REQUIREMENT_FOLDER).on(Tables.REQUIREMENT_FOLDER.RLN_ID.eq((Field)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID)).leftJoin((TableLike)Tables.HIGH_LEVEL_REQUIREMENT).on(Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID.eq((Field)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID)).where(Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.eq((Object)nodeId).and(Tables.RLN_RELATIONSHIP_CLOSURE.DEPTH.notEqual((Object)0))).orderBy((OrderField)Tables.RLN_RELATIONSHIP_CLOSURE.DEPTH.desc()).fetchInto(PathNodeDto.class);
    }

    private PathNodeDto fetchRequirementRootLibraryNode(Long nodeId) {
        return (PathNodeDto)this.dslContext.select((SelectField)Tables.PROJECT.NAME, (SelectField)Tables.PROJECT.RL_ID.as("ID"), (SelectField)DSL.val((String)EntityType.REQUIREMENT_LIBRARY.name()).as("NODE_TYPE")).from((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).innerJoin((TableLike)Tables.PROJECT).on(Tables.PROJECT.PROJECT_ID.eq((Field)Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID)).where(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq((Object)nodeId)).fetchOneInto(PathNodeDto.class);
    }

    @Override
    public List<PathNodeDto> getTestCaseBreadcrumbNodes(Long nodeId, boolean excludeCurrentNode) {
        SelectConditionStep record = this.fetchTestCaseClosureNodes(nodeId);
        if (excludeCurrentNode) {
            record = record.and(Tables.TCLN_RELATIONSHIP_CLOSURE.DEPTH.notEqual((Object)0));
        }
        List crumbs = record.orderBy((OrderField)Tables.TCLN_RELATIONSHIP_CLOSURE.DEPTH.desc()).fetchInto(PathNodeDto.class);
        PathNodeDto rootLibraryNode = this.fetchTestCaseRootLibraryNode(nodeId);
        crumbs.addFirst(rootLibraryNode);
        return crumbs;
    }

    private SelectConditionStep<Record3<String, Long, String>> fetchTestCaseClosureNodes(Long nodeId) {
        return this.dslContext.select((SelectField)Tables.TEST_CASE_LIBRARY_NODE.NAME.as("NAME"), (SelectField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.as("ID"), (SelectField)DSL.when((Condition)Tables.TEST_CASE_FOLDER.TCLN_ID.isNotNull(), (Object)EntityType.TEST_CASE_FOLDER.name()).otherwise((Object)EntityType.TEST_CASE.name()).as("NODE_TYPE")).from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).innerJoin((TableLike)Tables.TCLN_RELATIONSHIP_CLOSURE).on(Tables.TCLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).leftJoin((TableLike)Tables.TEST_CASE_FOLDER).on(Tables.TEST_CASE_FOLDER.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).where(Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.eq((Object)nodeId));
    }

    private PathNodeDto fetchTestCaseRootLibraryNode(Long nodeId) {
        return (PathNodeDto)this.dslContext.select((SelectField)Tables.PROJECT.NAME, (SelectField)Tables.PROJECT.TCL_ID.as("ID"), (SelectField)DSL.val((String)EntityType.TEST_CASE_LIBRARY.name()).as("NODE_TYPE")).from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).innerJoin((TableLike)Tables.PROJECT).on(Tables.PROJECT.PROJECT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID)).where(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Object)nodeId)).fetchOneInto(PathNodeDto.class);
    }

    @Override
    public Map<Long, List<PathNodeDto>> getCampaignBreadcrumbNodes(List<Long> nodeIds, boolean excludeCurrentNode) {
        if (Objects.isNull(nodeIds) || nodeIds.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<Long, List<PathNodeDto>> pathNodesByCampaign = this.fetchCampaignBreadcrumbPathNodes(nodeIds, excludeCurrentNode);
        Map<Long, PathNodeDto> rootNodes = this.fetchCampaignRootLibraryNodes(nodeIds);
        return this.mergeRootWithPath(nodeIds, pathNodesByCampaign, rootNodes);
    }

    private Map<Long, List<PathNodeDto>> fetchCampaignBreadcrumbPathNodes(List<Long> nodeIds, boolean excludeCurrentNode) {
        SelectConditionStep query = this.fetchCampaignClosureSelectCondition(nodeIds);
        if (excludeCurrentNode) {
            query = query.and(Tables.CLN_RELATIONSHIP_CLOSURE.DEPTH.notEqual((Object)0));
        }
        return query.orderBy((OrderField)Tables.CLN_RELATIONSHIP_CLOSURE.DEPTH.desc()).fetchGroups((Field)Tables.CLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID, record -> new PathNodeDto((String)record.get("NAME"), (Long)record.get("ID"), (String)record.get("NODE_TYPE")));
    }

    private Map<Long, List<PathNodeDto>> mergeRootWithPath(List<Long> nodeIds, Map<Long, List<PathNodeDto>> pathNodes, Map<Long, PathNodeDto> rootNodes) {
        HashMap<Long, List<PathNodeDto>> result = new HashMap<Long, List<PathNodeDto>>();
        for (Long nodeId : nodeIds) {
            ArrayList<PathNodeDto> path = new ArrayList<PathNodeDto>(pathNodes.getOrDefault(nodeId, Collections.emptyList()));
            PathNodeDto root = rootNodes.get(nodeId);
            if (root != null) {
                path.addFirst(root);
            }
            result.put(nodeId, path);
        }
        return result;
    }

    private Map<Long, PathNodeDto> fetchCampaignRootLibraryNodes(List<Long> nodeIds) {
        return this.dslContext.select((SelectField)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID, (SelectField)Tables.PROJECT.NAME, (SelectField)Tables.PROJECT.CL_ID.as("ID"), (SelectField)DSL.val((String)EntityType.CAMPAIGN_LIBRARY.name()).as("NODE_TYPE")).from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).innerJoin((TableLike)Tables.PROJECT).on(Tables.PROJECT.PROJECT_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.in(nodeIds)).fetchMap(r -> (Long)r.get((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID), r -> new PathNodeDto((String)r.get((Field)Tables.PROJECT.NAME), (Long)r.get("ID"), EntityType.valueOf((String)((String)r.get("NODE_TYPE"))).name()));
    }

    @Override
    public List<PathNodeDto> getCampaignBreadcrumbNodes(Long nodeId, boolean excludeCurrentNode) {
        return this.getCampaignBreadcrumbNodes(List.of(nodeId), excludeCurrentNode).getOrDefault(nodeId, Collections.emptyList());
    }

    private SelectConditionStep<Record4<Long, String, Long, String>> fetchCampaignClosureSelectCondition(List<Long> nodeIds) {
        return this.dslContext.select((SelectField)Tables.CLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID, (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.NAME.as("NAME"), (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.as("ID"), (SelectField)DSL.when((Condition)Tables.CAMPAIGN_FOLDER.CLN_ID.isNotNull(), (Object)EntityType.CAMPAIGN_FOLDER.name()).when(Tables.SPRINT.CLN_ID.isNotNull(), (Object)EntityType.SPRINT.name()).when(Tables.SPRINT_GROUP.CLN_ID.isNotNull(), (Object)EntityType.SPRINT_GROUP.name()).otherwise((Object)EntityType.CAMPAIGN.name()).as("NODE_TYPE")).from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).innerJoin((TableLike)Tables.CLN_RELATIONSHIP_CLOSURE).on(Tables.CLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).leftJoin((TableLike)Tables.CAMPAIGN_FOLDER).on(Tables.CAMPAIGN_FOLDER.CLN_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).leftJoin((TableLike)Tables.SPRINT).on(Tables.SPRINT.CLN_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).leftJoin((TableLike)Tables.SPRINT_GROUP).on(Tables.SPRINT_GROUP.CLN_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).where(Tables.CLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.in(nodeIds));
    }

    private SelectConditionStep<Record3<String, Long, String>> fetchCampaignClosureSelectCondition(Long nodeId) {
        return this.dslContext.select((SelectField)Tables.CAMPAIGN_LIBRARY_NODE.NAME.as("NAME"), (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.as("ID"), (SelectField)DSL.when((Condition)Tables.CAMPAIGN_FOLDER.CLN_ID.isNotNull(), (Object)EntityType.CAMPAIGN_FOLDER.name()).when(Tables.SPRINT.CLN_ID.isNotNull(), (Object)EntityType.SPRINT.name()).when(Tables.SPRINT_GROUP.CLN_ID.isNotNull(), (Object)EntityType.SPRINT_GROUP.name()).otherwise((Object)EntityType.CAMPAIGN.name()).as("NODE_TYPE")).from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).innerJoin((TableLike)Tables.CLN_RELATIONSHIP_CLOSURE).on(Tables.CLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).leftJoin((TableLike)Tables.CAMPAIGN_FOLDER).on(Tables.CAMPAIGN_FOLDER.CLN_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).leftJoin((TableLike)Tables.SPRINT).on(Tables.SPRINT.CLN_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).leftJoin((TableLike)Tables.SPRINT_GROUP).on(Tables.SPRINT_GROUP.CLN_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).where(Tables.CLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.eq((Object)nodeId));
    }

    @Override
    public List<PathNodeDto> getIterationBreadcrumbNodes(Long nodeId) {
        Record1 record = (Record1)this.dslContext.select((SelectField)Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID).from((TableLike)Tables.CAMPAIGN_ITERATION).where(Tables.CAMPAIGN_ITERATION.ITERATION_ID.eq((Object)nodeId)).fetchOne();
        if (record == null) {
            return Collections.emptyList();
        }
        return this.getCampaignBreadcrumbNodes((Long)record.component1(), false);
    }

    @Override
    public List<PathNodeDto> getTestSuiteBreadcrumbNodes(Long nodeId) {
        Record5 record = (Record5)this.dslContext.select((SelectField)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID, (SelectField)Tables.PROJECT.NAME, (SelectField)Tables.PROJECT.CL_ID, (SelectField)Tables.ITERATION.NAME, (SelectField)Tables.ITERATION_TEST_SUITE.ITERATION_ID).from((TableLike)Tables.ITERATION_TEST_SUITE).innerJoin((TableLike)Tables.ITERATION).on(Tables.ITERATION_TEST_SUITE.ITERATION_ID.eq((Field)Tables.ITERATION.ITERATION_ID)).innerJoin((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.ITERATION_TEST_SUITE.ITERATION_ID.eq((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ID)).innerJoin((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).on(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).innerJoin((TableLike)Tables.PROJECT).on(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).where(Tables.ITERATION_TEST_SUITE.TEST_SUITE_ID.eq((Object)nodeId)).fetchOne();
        if (record == null) {
            return Collections.emptyList();
        }
        List crumbs = this.fetchCampaignClosureSelectCondition((Long)record.component1()).orderBy((OrderField)Tables.CLN_RELATIONSHIP_CLOSURE.DEPTH.desc()).fetchInto(PathNodeDto.class);
        crumbs.addFirst(new PathNodeDto((String)record.component2(), (Long)record.component3(), EntityType.CAMPAIGN_LIBRARY.name()));
        crumbs.add(new PathNodeDto((String)record.component4(), (Long)record.component5(), EntityType.ITERATION.name()));
        return crumbs;
    }

    @Override
    public List<PathNodeDto> getExecutionBreadcrumbNodes(Long executionId) {
        if (this.executionIsInsideSprint(executionId)) {
            return this.getSprintExecutionBreadcrumbNodes(executionId);
        }
        List<Long> testSuiteParentIds = this.getTestSuiteParentIdsForExecution(executionId);
        if (testSuiteParentIds.size() == 1) {
            return this.getTestSuiteExecutionBreadcrumbNodes(testSuiteParentIds.getFirst());
        }
        return this.getIterationExecutionBreadcrumbNodes(executionId);
    }

    private List<PathNodeDto> getIterationExecutionBreadcrumbNodes(Long executionId) {
        Record5 record = (Record5)this.dslContext.select((SelectField)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID, (SelectField)Tables.ITERATION.NAME, (SelectField)Tables.ITERATION.ITERATION_ID, (SelectField)Tables.PROJECT.NAME, (SelectField)Tables.PROJECT.CL_ID).from((TableLike)Tables.ITERATION).innerJoin((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.ITERATION.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ID)).innerJoin((TableLike)Tables.EXECUTION).on(Tables.EXECUTION.TEST_PLAN_ITEM_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).innerJoin((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.ITERATION.ITERATION_ID.eq((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ID)).leftJoin((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).on(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).leftJoin((TableLike)Tables.PROJECT).on(Tables.PROJECT.PROJECT_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID)).where(Tables.EXECUTION.EXECUTION_ID.eq((Object)executionId)).fetchOne();
        if (record == null) {
            return Collections.emptyList();
        }
        List crumbs = this.fetchCampaignClosureSelectCondition((Long)record.component1()).orderBy((OrderField)Tables.CLN_RELATIONSHIP_CLOSURE.DEPTH.desc()).fetchInto(PathNodeDto.class);
        crumbs.addFirst(new PathNodeDto((String)record.component4(), (Long)record.component5(), EntityType.CAMPAIGN_LIBRARY.name()));
        crumbs.add(new PathNodeDto((String)record.component2(), (Long)record.component3(), EntityType.ITERATION.name()));
        return crumbs;
    }

    private List<PathNodeDto> getTestSuiteExecutionBreadcrumbNodes(Long testSuiteId) {
        Record7 record = (Record7)this.dslContext.select((SelectField)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID, (SelectField)Tables.PROJECT.NAME, (SelectField)Tables.PROJECT.CL_ID, (SelectField)Tables.ITERATION.NAME, (SelectField)Tables.ITERATION_TEST_SUITE.ITERATION_ID, (SelectField)Tables.TEST_SUITE.NAME, (SelectField)Tables.TEST_SUITE.ID).from((TableLike)Tables.ITERATION_TEST_SUITE).leftJoin((TableLike)Tables.TEST_SUITE).on(Tables.ITERATION_TEST_SUITE.TEST_SUITE_ID.eq((Field)Tables.TEST_SUITE.ID)).leftJoin((TableLike)Tables.ITERATION).on(Tables.ITERATION_TEST_SUITE.ITERATION_ID.eq((Field)Tables.ITERATION.ITERATION_ID)).leftJoin((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.ITERATION_TEST_SUITE.ITERATION_ID.eq((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ID)).leftJoin((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).on(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).leftJoin((TableLike)Tables.PROJECT).on(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).where(Tables.ITERATION_TEST_SUITE.TEST_SUITE_ID.eq((Object)testSuiteId)).fetchOne();
        if (record == null) {
            return Collections.emptyList();
        }
        List crumbs = this.fetchCampaignClosureSelectCondition((Long)record.component1()).orderBy((OrderField)Tables.CLN_RELATIONSHIP_CLOSURE.DEPTH.desc()).fetchInto(PathNodeDto.class);
        crumbs.addFirst(new PathNodeDto((String)record.component2(), (Long)record.component3(), EntityType.CAMPAIGN_LIBRARY.name()));
        crumbs.add(new PathNodeDto((String)record.component4(), (Long)record.component5(), EntityType.ITERATION.name()));
        crumbs.add(new PathNodeDto((String)record.component6(), (Long)record.component7(), EntityType.TEST_SUITE.name()));
        return crumbs;
    }

    private List<PathNodeDto> getSprintExecutionBreadcrumbNodes(Long executionId) {
        Record3 record = (Record3)this.dslContext.select((SelectField)Tables.SPRINT_REQ_VERSION.SPRINT_ID, (SelectField)Tables.PROJECT.NAME, (SelectField)Tables.PROJECT.CL_ID).from((TableLike)Tables.EXECUTION).innerJoin((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.EXECUTION.TEST_PLAN_ITEM_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).innerJoin((TableLike)Tables.SPRINT_REQ_VERSION).on(Tables.SPRINT_REQ_VERSION.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ID)).innerJoin((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).on(Tables.SPRINT_REQ_VERSION.SPRINT_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).leftJoin((TableLike)Tables.PROJECT).on(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).where(Tables.EXECUTION.EXECUTION_ID.eq((Object)executionId)).fetchOne();
        if (record == null) {
            return Collections.emptyList();
        }
        List crumbs = this.fetchCampaignClosureSelectCondition((Long)record.component1()).orderBy((OrderField)Tables.CLN_RELATIONSHIP_CLOSURE.DEPTH.desc()).fetchInto(PathNodeDto.class);
        PathNodeDto rootLibraryNode = new PathNodeDto((String)record.component2(), (Long)record.component3(), EntityType.CAMPAIGN_LIBRARY.name());
        crumbs.addFirst(rootLibraryNode);
        return crumbs;
    }

    @Override
    public List<PathNodeDto> getExploratorySessionOverviewBreadcrumbNodes(Long sessionOverviewId) {
        Record3 record = (Record3)this.dslContext.select((SelectField)DSL.coalesce((Field)Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID, (Field[])new Field[]{Tables.ITERATION.ITERATION_ID, Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID}).as("ID"), (SelectField)DSL.coalesce((Field)Tables.TEST_SUITE.NAME, (Field[])new Field[]{Tables.ITERATION.NAME, Tables.CAMPAIGN_LIBRARY_NODE.NAME}).as(NODE_NAME), (SelectField)DSL.when((Condition)Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID.isNotNull(), (Object)EntityType.TEST_SUITE.name()).when(Tables.ITERATION.ITERATION_ID.isNotNull(), (Object)EntityType.ITERATION.name()).otherwise((Object)EntityType.SPRINT.name()).as("NODE_TYPE")).from((TableLike)Tables.EXPLORATORY_SESSION_OVERVIEW).innerJoin((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID.eq((Field)Tables.TEST_PLAN_ITEM.OVERVIEW_ID)).leftJoin((TableLike)Tables.TEST_SUITE_TEST_PLAN_ITEM).on(Tables.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).leftJoin((TableLike)Tables.TEST_SUITE).on(Tables.TEST_SUITE.ID.eq((Field)Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID)).leftJoin((TableLike)Tables.ITERATION).on(Tables.ITERATION.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ID)).leftJoin((TableLike)Tables.SPRINT_REQ_VERSION).on(Tables.SPRINT_REQ_VERSION.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ID)).leftJoin((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.SPRINT_REQ_VERSION.SPRINT_ID)).where(Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID.eq((Object)sessionOverviewId)).fetchOne();
        if (record == null) {
            return Collections.emptyList();
        }
        List<PathNodeDto> crumbs = switch (EntityType.valueOf((String)((String)record.component3()))) {
            case EntityType.TEST_SUITE -> this.getTestSuiteBreadcrumbNodes((Long)record.component1());
            case EntityType.ITERATION -> this.getIterationBreadcrumbNodes((Long)record.component1());
            default -> this.getCampaignBreadcrumbNodes((Long)record.component1(), true);
        };
        crumbs.add(new PathNodeDto((String)record.component2(), (Long)record.component1(), (String)record.component3()));
        return crumbs;
    }
}

