/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.grid.filters.collector;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.jooq.Condition;
import org.jooq.Field;
import org.squashtest.tm.service.internal.display.grid.GridFilterValue;
import org.squashtest.tm.service.internal.display.grid.columns.GridColumn;
import org.squashtest.tm.service.internal.display.grid.filters.GridFilterConditionBuilder;

public class DefaultFilterCollector
implements Collector<GridFilterValue, List<GridFilterValue>, Condition> {
    protected final Map<String, GridColumn> aliasToFieldDictionary;
    protected final boolean searchingOnMultiColumns;

    public DefaultFilterCollector(Map<String, GridColumn> aliasToFieldDictionary, boolean searchingOnMultiColumns) {
        this.aliasToFieldDictionary = aliasToFieldDictionary;
        this.searchingOnMultiColumns = searchingOnMultiColumns;
    }

    @Override
    public Supplier<List<GridFilterValue>> supplier() {
        return ArrayList::new;
    }

    @Override
    public BiConsumer<List<GridFilterValue>, GridFilterValue> accumulator() {
        return List::add;
    }

    @Override
    public BinaryOperator<List<GridFilterValue>> combiner() {
        return (x, y) -> {
            throw new UnsupportedOperationException();
        };
    }

    @Override
    public Function<List<GridFilterValue>, Condition> finisher() {
        return gridFilterValues -> {
            ArrayDeque filterStack = new ArrayDeque(gridFilterValues);
            Condition condition = this.convertFilterToCondition(Objects.requireNonNull((GridFilterValue)filterStack.poll()));
            while (Objects.nonNull(filterStack.peek())) {
                condition = this.searchingOnMultiColumns ? condition.or(this.convertFilterToCondition((GridFilterValue)filterStack.poll())) : condition.and(this.convertFilterToCondition((GridFilterValue)filterStack.poll()));
            }
            return condition;
        };
    }

    protected Condition convertFilterToCondition(GridFilterValue gridFilterValue) {
        String id = gridFilterValue.getId();
        GridColumn gridColumn = Objects.requireNonNull(this.aliasToFieldDictionary.get(id));
        Field<?> field = gridColumn.getNativeField();
        return GridFilterConditionBuilder.getConditionBuilder(field, gridFilterValue).build();
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return Collections.emptySet();
    }
}

