/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.deletion.jdbc;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Param;
import org.jooq.Record1;
import org.jooq.Record3;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectOnConditionStep;
import org.jooq.Table;
import org.jooq.TableField;
import org.squashtest.tm.jooq.domain.tables.WorkDeleteEntities;
import org.squashtest.tm.service.internal.deletion.jdbc.JdbcWorkingTable;

public class JdbcWorkingTables {
    private final Map<TableField<?, Long>, JdbcWorkingTable> tables = new HashMap();
    private final DSLContext dslContext;
    private final String operationId;

    public JdbcWorkingTables(DSLContext dslContext, String operationId) {
        this.dslContext = Objects.requireNonNull(dslContext);
        this.operationId = operationId;
    }

    public void addEntity(TableField<?, Long> originalField, Supplier<Select<Record3<Long, String, String>>> selector) {
        JdbcWorkingTable jdbcWorkingTable = new JdbcWorkingTable(originalField, selector, this.dslContext, this.operationId);
        this.tables.put(originalField, jdbcWorkingTable);
    }

    public SelectConditionStep<Record1<Long>> makeSelectIds(TableField<?, Long> referencedEntity) {
        return this.tables.get(referencedEntity).selectEntityIds();
    }

    public List<Long> selectIds(TableField<?, Long> referencedEntity) {
        return this.tables.get(referencedEntity).selectEntityIds().fetch((Field)WorkDeleteEntities.WORK_DELETE_ENTITIES.ENTITY_ID);
    }

    public SelectOnConditionStep<Record3<Long, String, String>> makeSelectJoin(TableField<?, Long> referencedEntity, TableField<?, Long> selectedField, TableField<?, Long> joinedField, Param<String> fieldName) {
        return this.tables.get(referencedEntity).makeSelectJoin(selectedField, joinedField, fieldName);
    }

    public void delete(TableField<?, Long> referencedEntity, TableField<?, Long> toDelete) {
        this.tables.get(referencedEntity).delete(toDelete);
    }

    public void nullify(TableField<?, Long> referencedEntity, TableField<?, Long> toNullify) {
        this.tables.get(referencedEntity).nullify(toNullify);
    }

    public void clean() {
        this.dslContext.deleteFrom((Table)WorkDeleteEntities.WORK_DELETE_ENTITIES).where(WorkDeleteEntities.WORK_DELETE_ENTITIES.OPERATION_ID.eq((Object)this.operationId)).execute();
    }
}

