/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.bugtracker;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.i18n.LocaleContext;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.csp.core.bugtracker.core.BugTrackerNoCredentialsException;
import org.squashtest.csp.core.bugtracker.core.BugTrackerRemoteException;
import org.squashtest.csp.core.bugtracker.core.UnsupportedAuthenticationModeException;
import org.squashtest.csp.core.bugtracker.spi.BugTrackerInterfaceDescriptor;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.bugtracker.advanceddomain.DelegateCommand;
import org.squashtest.tm.bugtracker.advanceddomain.RemoteIssueSearchRequest;
import org.squashtest.tm.bugtracker.definition.Attachment;
import org.squashtest.tm.bugtracker.definition.RemoteIssue;
import org.squashtest.tm.bugtracker.definition.context.RemoteIssueContext;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.bugtracker.Issue;
import org.squashtest.tm.domain.bugtracker.IssueDetector;
import org.squashtest.tm.domain.bugtracker.IssueList;
import org.squashtest.tm.domain.campaign.SprintStatus;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.servers.AuthenticationStatus;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.domain.servers.ThirdPartyServer;
import org.squashtest.tm.domain.testautomation.FailureDetail;
import org.squashtest.tm.exception.IssueAlreadyBoundException;
import org.squashtest.tm.exception.campaign.SprintClosedException;
import org.squashtest.tm.service.annotation.CheckBlockingMilestone;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.bugtracker.BugTrackersLocalService;
import org.squashtest.tm.service.bugtracker.BugTrackersService;
import org.squashtest.tm.service.campaign.SprintManagerService;
import org.squashtest.tm.service.execution.ExecutionFinder;
import org.squashtest.tm.service.execution.automatedexecution.AutomatedExecutionFlagService;
import org.squashtest.tm.service.internal.bugtracker.RemoteRequirementAndProjectId;
import org.squashtest.tm.service.internal.repository.BugTrackerDao;
import org.squashtest.tm.service.internal.repository.IssueDao;
import org.squashtest.tm.service.internal.repository.ProjectDao;
import org.squashtest.tm.service.internal.repository.RequirementSyncExtenderDao;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.security.SecurityCheckableObject;
import org.squashtest.tm.service.servers.CredentialsProvider;
import org.squashtest.tm.service.servers.ManageableCredentials;
import org.squashtest.tm.service.servers.StoredCredentialsManager;
import org.squashtest.tm.service.servers.UserCredentialsCache;

@Service(value="squashtest.tm.service.BugTrackersLocalService")
public class BugTrackersLocalServiceImpl
implements BugTrackersLocalService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BugTrackersLocalServiceImpl.class);
    @Value(value="${squashtm.bugtracker.timeout:15}")
    private long timeout;
    private final IssueDao issueDao;
    private final BugTrackersService remoteBugTrackersService;
    private final ExecutionFinder executionFinder;
    private final SprintManagerService sprintManagerService;
    private final BugTrackerDao bugTrackerDao;
    private final ProjectDao projectDao;
    private final PermissionEvaluationService permissionEvaluationService;
    private final CredentialsProvider credentialsProvider;
    private final StoredCredentialsManager storedCredentialsManager;
    private final RequirementSyncExtenderDao requirementSyncExtenderDao;
    private final AutomatedExecutionFlagService automatedExecutionFlagService;

    public BugTrackersLocalServiceImpl(IssueDao issueDao, BugTrackersService remoteBugTrackersService, ExecutionFinder executionFinder, SprintManagerService sprintManagerService, BugTrackerDao bugTrackerDao, ProjectDao projectDao, PermissionEvaluationService permissionEvaluationService, CredentialsProvider credentialsProvider, StoredCredentialsManager storedCredentialsManager, RequirementSyncExtenderDao requirementSyncExtenderDao, AutomatedExecutionFlagService automatedExecutionFlagService) {
        this.issueDao = issueDao;
        this.remoteBugTrackersService = remoteBugTrackersService;
        this.executionFinder = executionFinder;
        this.sprintManagerService = sprintManagerService;
        this.bugTrackerDao = bugTrackerDao;
        this.projectDao = projectDao;
        this.permissionEvaluationService = permissionEvaluationService;
        this.credentialsProvider = credentialsProvider;
        this.storedCredentialsManager = storedCredentialsManager;
        this.requirementSyncExtenderDao = requirementSyncExtenderDao;
        this.automatedExecutionFlagService = automatedExecutionFlagService;
    }

    @Override
    public BugTrackerInterfaceDescriptor getInterfaceDescriptor(BugTracker bugTracker) {
        return this.remoteBugTrackersService.getInterfaceDescriptor(bugTracker);
    }

    private AuthenticationStatus checkBugTrackerStatus(Project project) {
        AuthenticationStatus status = !project.isBoundToBugtracker() ? AuthenticationStatus.UNDEFINED : (this.remoteBugTrackersService.isCredentialsNeeded(project.findBugTracker()) ? AuthenticationStatus.NON_AUTHENTICATED : AuthenticationStatus.AUTHENTICATED);
        return status;
    }

    @Override
    public AuthenticationStatus checkBugTrackerStatus(Long projectId) {
        Project project = (Project)this.projectDao.getReferenceById(projectId);
        return this.checkBugTrackerStatus(project);
    }

    @Override
    public AuthenticationStatus checkAuthenticationStatus(Long bugtrackerId) {
        boolean needs;
        Optional optBugtracker = this.bugTrackerDao.findById(bugtrackerId);
        AuthenticationStatus status = optBugtracker.isPresent() ? ((needs = this.remoteBugTrackersService.isCredentialsNeeded((BugTracker)optBugtracker.get())) ? AuthenticationStatus.NON_AUTHENTICATED : AuthenticationStatus.AUTHENTICATED) : AuthenticationStatus.UNDEFINED;
        return status;
    }

    private RemoteIssue createRemoteIssue(IssueDetector entity, RemoteIssue btIssue) {
        BugTracker bugTracker = entity.getBugTracker();
        String btName = bugTracker.getName();
        btIssue.setBugtracker(btName);
        RemoteIssue createdIssue = this.remoteBugTrackersService.createIssue(btIssue, bugTracker);
        createdIssue.setBugtracker(btName);
        return createdIssue;
    }

    @Override
    public RemoteIssue createIssue(IssueDetector entity, RemoteIssue btIssue) {
        RemoteIssue createdIssue = this.createRemoteIssue(entity, btIssue);
        BugTracker bugTracker = entity.getBugTracker();
        Issue sqIssue = new Issue();
        sqIssue.setRemoteIssueId(createdIssue.getId());
        sqIssue.setBugtracker(bugTracker);
        sqIssue.setAdditionalData(createdIssue.getAdditionalData());
        IssueList list = entity.getIssueList();
        list.addIssue(sqIssue);
        this.issueDao.save(sqIssue);
        return createdIssue;
    }

    public List<RemoteIssue> getIssues(Long projectId, List<String> issueKeyList, BugTracker bugTracker) {
        try {
            Future<List<RemoteIssue>> futureIssues = this.remoteBugTrackersService.getIssues(projectId, issueKeyList, bugTracker, this.getCredentialsCache(), this.getLocaleContext(), this.getSecurityContext());
            return futureIssues.get(this.timeout, TimeUnit.SECONDS);
        }
        catch (TimeoutException timex) {
            throw new BugTrackerRemoteException((Throwable)timex);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new BugTrackerRemoteException((Throwable)e);
        }
    }

    private LocaleContext getLocaleContext() {
        return LocaleContextHolder.getLocaleContext();
    }

    private SecurityContext getSecurityContext() {
        return SecurityContextHolder.getContext();
    }

    private UserCredentialsCache getCredentialsCache() {
        return this.credentialsProvider.getCache();
    }

    @Override
    public Optional<? extends RemoteIssue> searchIssue(RemoteIssueSearchRequest searchRequest, BugTracker bugTracker) {
        return this.remoteBugTrackersService.searchIssue(searchRequest, bugTracker);
    }

    @Override
    @CheckBlockingMilestone(entityType=Execution.class)
    @PreAuthorize(value="hasPermission(#executionId, 'org.squashtest.tm.domain.execution.Execution', 'EXECUTE')  or hasRole('ROLE_ADMIN')")
    public Optional<Issue> searchAndAttachIssueToExecution(RemoteIssueSearchRequest searchRequest, @Id Long executionId) {
        Execution execution = this.executionFinder.findById(executionId);
        this.checkCanAddIssue(execution);
        BugTracker bugTracker = execution.getBugTracker();
        Optional<? extends RemoteIssue> remoteIssue = this.searchIssue(searchRequest, bugTracker);
        if (remoteIssue.isEmpty()) {
            return Optional.empty();
        }
        Issue issue = this.attachIssueUnsecured(remoteIssue.get(), (IssueDetector)execution, remoteIssue.get().getId());
        return Optional.of(issue);
    }

    private void checkCanAddIssue(Execution execution) {
        if (SprintStatus.CLOSED.equals((Object)this.sprintManagerService.getSprintStatusByExecutionId(execution.getId()))) {
            throw new SprintClosedException();
        }
    }

    @Override
    @Transactional(noRollbackFor={BugTrackerNoCredentialsException.class, UnsupportedAuthenticationModeException.class})
    public void validateCredentials(BugTracker bugTracker, Credentials credentials, boolean purgeOnFail) throws BugTrackerRemoteException {
        LOGGER.debug("BugTrackerLocalServiceImpl : validating credentials for server '{}'", new Object[]{bugTracker.getName()});
        try {
            this.remoteBugTrackersService.testCredentials(bugTracker, credentials);
            LOGGER.debug("BugTrackerLocalServiceImpl : credentials successfully validated", new Object[0]);
            this.credentialsProvider.cacheCredentials((ThirdPartyServer)bugTracker, credentials);
        }
        catch (BugTrackerNoCredentialsException | UnsupportedAuthenticationModeException ex) {
            LOGGER.debug("BugTrackerLocalServerImpl : credentials were rejected ({})", new Object[]{ex.getClass()});
            if (purgeOnFail) {
                LOGGER.debug("BugTrackerLocalServiceImpl : removing failed credentials as requested", new Object[0]);
                this.credentialsProvider.uncacheCredentials((ThirdPartyServer)bugTracker);
                this.storedCredentialsManager.deleteUserCredentials(bugTracker.getId(), this.credentialsProvider.currentUser());
            }
            throw ex;
        }
    }

    @Override
    @Transactional(noRollbackFor={BugTrackerNoCredentialsException.class, UnsupportedAuthenticationModeException.class})
    public void validateCredentials(Long bugtrackerId, Credentials credentials, boolean purgeOnFail) throws BugTrackerRemoteException {
        BugTracker server = (BugTracker)this.bugTrackerDao.getReferenceById(bugtrackerId);
        this.validateCredentials(server, credentials, purgeOnFail);
    }

    @Override
    public void validateManageableCredentials(long bugtrackerId, ManageableCredentials credentials, boolean purgeOnFail) throws BugTrackerRemoteException {
        BugTracker bt = (BugTracker)this.bugTrackerDao.getReferenceById(bugtrackerId);
        Credentials usableCredentials = credentials.build(this.storedCredentialsManager, (ThirdPartyServer)bt, null);
        if (usableCredentials == null) {
            throw new BugTrackerNoCredentialsException("credentials could not be built, either because the credentials themselves are not suitable, or because the protocol configuration is incomplete/invalid", null);
        }
        this.validateCredentials(bt, usableCredentials, purgeOnFail);
    }

    @Override
    public RemoteIssue createReportIssueTemplate(String projectName, BugTracker bugTracker, RemoteIssueContext context) {
        return this.remoteBugTrackersService.createReportIssueTemplate(projectName, bugTracker, context);
    }

    @Override
    public URL getIssueUrl(String btIssueId, BugTracker bugTracker) {
        return this.remoteBugTrackersService.getViewIssueUrl(btIssueId, bugTracker);
    }

    @Override
    public void forwardAttachments(String remoteIssueKey, String bugtrackerName, List<Attachment> attachments) {
        BugTracker bugtracker = this.bugTrackerDao.findByName(bugtrackerName);
        this.remoteBugTrackersService.forwardAttachments(remoteIssueKey, bugtracker, attachments);
    }

    @Override
    public Object forwardDelegateCommand(DelegateCommand command, String bugtrackerName) {
        BugTracker bugtracker = this.bugTrackerDao.findByName(bugtrackerName);
        return this.remoteBugTrackersService.forwardDelegateCommand(command, bugtracker);
    }

    @Override
    @PreAuthorize(value="hasPermission(#bugged, 'EXECUTE') or hasRole('ROLE_ADMIN')")
    public Issue attachIssue(RemoteIssue remoteIssue, IssueDetector bugged, String remoteIssueKey) {
        return this.attachIssueUnsecured(remoteIssue, bugged, remoteIssueKey);
    }

    private Issue attachIssueUnsecured(RemoteIssue remoteIssue, IssueDetector bugged, String remoteIssueKey) {
        IssueList issueList = bugged.getIssueList();
        if (issueList.hasRemoteIssue(remoteIssueKey)) {
            throw new IssueAlreadyBoundException();
        }
        Issue issue = new Issue();
        issue.setBugtracker(bugged.getBugTracker());
        issue.setRemoteIssueId(remoteIssueKey);
        issue.setAdditionalData(remoteIssue.getAdditionalData());
        issueList.addIssue(issue);
        this.issueDao.save(issue);
        this.updateFailureDetailLastModification(bugged);
        return issue;
    }

    private void detachIssue(long id) {
        IssueDetector bugged = this.issueDao.findIssueDetectorByIssue(id);
        this.permissionEvaluationService.checkPermission(new SecurityCheckableObject(bugged, Permissions.EXECUTE.name()));
        Issue issue = (Issue)this.issueDao.getReferenceById(id);
        this.issueDao.delete(issue);
        this.updateFailureDetailLastModification(bugged);
    }

    private void detachIssueAndUpdateFlagDateAfterExtenderId(long id, long extenderId) {
        IssueDetector bugged = this.issueDao.findIssueDetectorByIssue(id);
        this.permissionEvaluationService.checkPermission(new SecurityCheckableObject(bugged, Permissions.EXECUTE.name()));
        List<Long> extenderIds = this.getFailureDetailExtenderIds(bugged, id, extenderId);
        Issue issue = (Issue)this.issueDao.getReferenceById(id);
        this.issueDao.delete(issue);
        this.updateFailureDetailLastModification(bugged);
        if (!extenderIds.isEmpty()) {
            this.automatedExecutionFlagService.updateToBeAnalysedFlag(extenderIds);
        }
    }

    private void updateFailureDetailLastModification(IssueDetector entity) {
        if (entity instanceof FailureDetail) {
            ((FailureDetail)entity).updateLastModificationWithCurrentUser();
        }
    }

    private List<Long> getFailureDetailExtenderIds(IssueDetector bugged, long issueId, long extenderId) {
        if (bugged instanceof FailureDetail) {
            return this.automatedExecutionFlagService.findExtenderIdsWithIssueIdAndExecutionDateAfter(issueId, extenderId);
        }
        return Collections.emptyList();
    }

    @Override
    @Transactional
    public void detachIssues(List<Long> issueIds) {
        issueIds.forEach(this::detachIssue);
    }

    @Override
    @Transactional
    public void detachIssuesAndUpdateAutomationFlag(List<Long> issueIds, Long extenderId) {
        issueIds.forEach(id -> this.detachIssueAndUpdateFlagDateAfterExtenderId((long)id, extenderId));
    }

    @Override
    public Set<String> getProviderKinds() {
        return this.remoteBugTrackersService.getProviderKinds();
    }

    @Override
    public List<RemoteRequirementAndProjectId> findAllRemoteReqIdByServerUrlVerifiedByATestCase(String serverUrl, Long testCaseId) {
        return this.requirementSyncExtenderDao.findAllRemoteReqIdVerifiedByATestCaseByServerUrl(serverUrl, testCaseId);
    }

    @Override
    public void linkIssueToRemoteRequirements(String issueId, List<RemoteRequirementAndProjectId> remoteReqIds, BugTracker bugtracker) {
        this.remoteBugTrackersService.linkIssueToRemoteRequirements(issueId, remoteReqIds, bugtracker);
    }
}

