/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testcase;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.NamedReference;
import org.squashtest.tm.domain.NamedReferencePair;
import org.squashtest.tm.domain.library.structures.LibraryGraph;
import org.squashtest.tm.service.internal.repository.TestCaseDao;

@Component
public class TestCaseCallTreeFinder {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestCaseCallTreeFinder.class);
    @Inject
    private TestCaseDao testCaseDao;

    public Set<Long> getTestCaseCallTree(Long rootTcId) {
        HashSet<Long> calleesIds = new HashSet<Long>();
        List prevCalleesIds = this.testCaseDao.findAllDistinctTestCasesIdsCalledByTestCase(rootTcId);
        LOGGER.trace("TestCase #{} directly calls {}", new Object[]{rootTcId, prevCalleesIds});
        prevCalleesIds.remove(rootTcId);
        while (!prevCalleesIds.isEmpty()) {
            calleesIds.addAll(prevCalleesIds);
            prevCalleesIds = this.testCaseDao.findAllTestCasesIdsCalledByTestCases(prevCalleesIds);
            LOGGER.trace("TestCase #{} indirectly calls {}", new Object[]{rootTcId, prevCalleesIds});
            prevCalleesIds.remove(rootTcId);
        }
        return calleesIds;
    }

    public Set<Long> getTestCaseCallTree(Collection<Long> tcIds) {
        HashSet<Long> result = new HashSet<Long>();
        List process = tcIds;
        while (!process.isEmpty()) {
            List next = this.testCaseDao.findAllTestCasesIdsCalledByTestCases(process);
            next.removeAll(result);
            result.addAll(next);
            process = next;
        }
        return result;
    }

    public Set<Long> getTestCaseCallers(Long rootTcId) {
        HashSet<Long> callerIds = new HashSet<Long>();
        List prevCallerIds = this.testCaseDao.findAllDistinctTestCasesIdsCallingTestCase(rootTcId);
        LOGGER.trace("TestCase #{} directly calls {}", new Object[]{prevCallerIds, rootTcId});
        prevCallerIds.remove(rootTcId);
        while (!prevCallerIds.isEmpty()) {
            callerIds.addAll(prevCallerIds);
            prevCallerIds = this.testCaseDao.findAllTestCasesIdsCallingTestCases(prevCallerIds);
            LOGGER.trace("TestCase #{} indirectly calls {}", new Object[]{prevCallerIds, rootTcId});
            prevCallerIds.remove(rootTcId);
        }
        return callerIds;
    }

    public LibraryGraph<NamedReference, LibraryGraph.SimpleNode<NamedReference>> getCallerGraph(List<Long> calledIds) {
        HashSet<Long> allIds = new HashSet<Long>();
        allIds.addAll(calledIds);
        LinkedList allpairs = new LinkedList();
        LinkedList<Long> currentCalled = new LinkedList<Long>(calledIds);
        while (!currentCalled.isEmpty()) {
            List currentPair = this.testCaseDao.findTestCaseCallsUpstream(currentCalled);
            allpairs.addAll(currentPair);
            LinkedList<Long> nextCalled = new LinkedList<Long>();
            for (NamedReferencePair pair : currentPair) {
                Long key;
                if (pair.getCaller() == null || allIds.contains(key = pair.getCaller().getId())) continue;
                nextCalled.add(key);
                allIds.add(key);
            }
            currentCalled = nextCalled;
        }
        LibraryGraph graph = new LibraryGraph();
        for (NamedReferencePair pair : allpairs) {
            graph.addEdge(this.node(pair.getCaller()), this.node(pair.getCalled()));
        }
        return graph;
    }

    public LibraryGraph<NamedReference, LibraryGraph.SimpleNode<NamedReference>> getExtendedGraph(Collection<Long> sourceIds) {
        List existingPairs = this.testCaseDao.findRecursiveTestCasesCalls(sourceIds);
        ArrayList<NamedReferencePair> result = new ArrayList<NamedReferencePair>(existingPairs);
        Map<Long, String> caller = existingPairs.stream().map(NamedReferencePair::getCaller).collect(Collectors.toMap(NamedReference::getId, NamedReference::getName, (x, y) -> x));
        Map<Long, String> called = existingPairs.stream().map(NamedReferencePair::getCalled).collect(Collectors.toMap(NamedReference::getId, NamedReference::getName, (x, y) -> x));
        HashSet<Long> ids = new HashSet<Long>(caller.keySet());
        ids.addAll(called.keySet());
        for (Long id2 : ids) {
            if (!caller.containsKey(id2)) {
                result.add(new NamedReferencePair(id2, called.get(id2), null, null));
            }
            if (called.containsKey(id2)) continue;
            result.add(new NamedReferencePair(null, null, id2, caller.get(id2)));
        }
        Set missingIds = sourceIds.stream().filter(sourceId -> !ids.contains(sourceId)).collect(Collectors.toSet());
        if (!missingIds.isEmpty()) {
            Map missingIdByNames = this.testCaseDao.findNameByTestCaseId(missingIds);
            missingIdByNames.forEach((id, name) -> {
                result.add(new NamedReferencePair(id, name, null, null));
                result.add(new NamedReferencePair(null, null, id, name));
            });
        }
        LibraryGraph graph = new LibraryGraph();
        for (NamedReferencePair pair : result) {
            graph.addEdge(this.node(pair.getCaller()), this.node(pair.getCalled()));
        }
        return graph;
    }

    private LibraryGraph.SimpleNode<NamedReference> node(NamedReference ref) {
        return ref != null ? new LibraryGraph.SimpleNode((Object)ref) : null;
    }
}

