/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.templaterenderer;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.io.StringTemplateSource;
import com.github.jknack.handlebars.io.TemplateSource;
import java.io.IOException;
import java.util.Map;
import java.util.stream.Collectors;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.exception.templaterenderer.TemplateRenderingException;

public final class HandlebarsTemplateRenderer {
    private static final Logger LOGGER = LoggerFactory.getLogger(HandlebarsTemplateRenderer.class);

    private HandlebarsTemplateRenderer() {
    }

    public static String renderTemplate(String template, Map<String, Object> variables) {
        Map<String, Handlebars.SafeString> scope = variables.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new Handlebars.SafeString((CharSequence)String.valueOf(entry.getValue()))));
        Handlebars handlebars = new Handlebars();
        try {
            Template compiledTemplate = handlebars.compile((TemplateSource)new StringTemplateSource("template", template));
            return compiledTemplate.apply(scope);
        }
        catch (IOException e) {
            LOGGER.error("Failed to render template with {}", new Object[]{variables.keySet(), e});
            throw new TemplateRenderingException((Throwable)e);
        }
    }
}

