/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.execution.ExecutionFlag;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.repository.CustomAutomatedExecExtenderDao;

@Repository
public class CustomAutomatedExecExtenderDaoImpl
implements CustomAutomatedExecExtenderDao {
    private static final String EXTENDER_IDS = "extenderIds";
    private static final String FLAG = "flag";
    private final DSLContext dslContext;
    @PersistenceContext
    private EntityManager entityManager;

    public CustomAutomatedExecExtenderDaoImpl(DSLContext dslContext) {
        this.dslContext = dslContext;
    }

    @Override
    public String findExecutionStatusByExtenderId(long extenderId) {
        return (String)this.dslContext.select((SelectField)Tables.EXECUTION.EXECUTION_STATUS).from((TableLike)Tables.AUTOMATED_EXECUTION_EXTENDER).join((TableLike)Tables.EXECUTION).on(Tables.AUTOMATED_EXECUTION_EXTENDER.MASTER_EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).where(Tables.AUTOMATED_EXECUTION_EXTENDER.EXTENDER_ID.eq((Object)extenderId)).fetchOneInto(String.class);
    }

    @Override
    public boolean areAllFailureDetailLinkedToIssueByExtenderId(long extenderId) {
        Integer unmatchedCount = (Integer)this.dslContext.selectCount().from((TableLike)Tables.AUTOMATED_EXECUTION_FAILURE_DETAIL).join((TableLike)Tables.FAILURE_DETAIL).on(Tables.AUTOMATED_EXECUTION_FAILURE_DETAIL.FAILURE_DETAIL_ID.eq((Field)Tables.FAILURE_DETAIL.FAILURE_DETAIL_ID)).leftJoin((TableLike)Tables.ISSUE).on(Tables.FAILURE_DETAIL.ISSUE_LIST_ID.eq((Field)Tables.ISSUE.ISSUE_LIST_ID)).where(Tables.AUTOMATED_EXECUTION_FAILURE_DETAIL.EXECUTION_EXTENDER_ID.eq((Object)extenderId)).and(Tables.ISSUE.ISSUE_ID.isNull()).fetchOneInto(Integer.class);
        return (unmatchedCount = Objects.requireNonNullElse(unmatchedCount, 0)) == 0;
    }

    @Override
    public boolean isAnyFailureDetailLinkedToIssueByExtenderId(long extenderId) {
        Integer linkedCount = (Integer)this.dslContext.selectCount().from((TableLike)Tables.AUTOMATED_EXECUTION_FAILURE_DETAIL).join((TableLike)Tables.FAILURE_DETAIL).on(Tables.AUTOMATED_EXECUTION_FAILURE_DETAIL.FAILURE_DETAIL_ID.eq((Field)Tables.FAILURE_DETAIL.FAILURE_DETAIL_ID)).join((TableLike)Tables.ISSUE).on(Tables.FAILURE_DETAIL.ISSUE_LIST_ID.eq((Field)Tables.ISSUE.ISSUE_LIST_ID)).where(Tables.AUTOMATED_EXECUTION_FAILURE_DETAIL.EXECUTION_EXTENDER_ID.eq((Object)extenderId)).fetchOneInto(Integer.class);
        return (linkedCount = Objects.requireNonNullElse(linkedCount, 0)) > 0;
    }

    private List<Long> findRecentExtenderIdsByExtenderIdWithOffset(long extenderId, int recentCount, int offset) {
        Long testPlanItemId = (Long)this.dslContext.select((SelectField)Tables.EXECUTION.TEST_PLAN_ITEM_ID).from((TableLike)Tables.AUTOMATED_EXECUTION_EXTENDER).join((TableLike)Tables.EXECUTION).on(Tables.AUTOMATED_EXECUTION_EXTENDER.MASTER_EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).where(Tables.AUTOMATED_EXECUTION_EXTENDER.EXTENDER_ID.eq((Object)extenderId)).fetchOneInto(Long.class);
        return this.dslContext.select((SelectField)Tables.AUTOMATED_EXECUTION_EXTENDER.EXTENDER_ID).from((TableLike)Tables.EXECUTION).join((TableLike)Tables.AUTOMATED_EXECUTION_EXTENDER).on(Tables.EXECUTION.EXECUTION_ID.eq((Field)Tables.AUTOMATED_EXECUTION_EXTENDER.MASTER_EXECUTION_ID)).where(Tables.EXECUTION.TEST_PLAN_ITEM_ID.eq((Object)testPlanItemId)).orderBy((OrderField)Tables.EXECUTION.LAST_EXECUTED_ON.desc()).limit((Number)recentCount).offset((Number)offset).fetchInto(Long.class);
    }

    @Override
    public List<Long> findRecentExtenderIdsByExtenderId(long extenderId, int recentCount) {
        return this.findRecentExtenderIdsByExtenderIdWithOffset(extenderId, recentCount, 0);
    }

    @Override
    public Map<Long, ExecutionStatus> findExecutionStatusesByExtenderIds(List<Long> extenderIds) {
        return this.dslContext.select((SelectField)Tables.AUTOMATED_EXECUTION_EXTENDER.EXTENDER_ID, (SelectField)Tables.EXECUTION.EXECUTION_STATUS).from((TableLike)Tables.AUTOMATED_EXECUTION_EXTENDER).join((TableLike)Tables.EXECUTION).on(Tables.AUTOMATED_EXECUTION_EXTENDER.MASTER_EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).where(Tables.AUTOMATED_EXECUTION_EXTENDER.EXTENDER_ID.in(extenderIds)).fetchMap(record -> (Long)record.get((Field)Tables.AUTOMATED_EXECUTION_EXTENDER.EXTENDER_ID), record -> ExecutionStatus.valueOf((String)((String)record.get((Field)Tables.EXECUTION.EXECUTION_STATUS))));
    }

    @Override
    public Long findLastExtenderIdByExtenderId(long extenderId) {
        List<Long> extenderIds = this.findRecentExtenderIdsByExtenderIdWithOffset(extenderId, 1, 1);
        return extenderIds.isEmpty() ? null : extenderIds.get(0);
    }

    @Override
    public List<Long> findExtenderIdsWithIssueIdAndExecutionDateAfter(long issueId, long extenderId) {
        LocalDateTime lastExecutionOn = (LocalDateTime)this.dslContext.select((SelectField)Tables.EXECUTION.LAST_EXECUTED_ON).from((TableLike)Tables.AUTOMATED_EXECUTION_EXTENDER).join((TableLike)Tables.EXECUTION).on(Tables.AUTOMATED_EXECUTION_EXTENDER.MASTER_EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).where(Tables.AUTOMATED_EXECUTION_EXTENDER.EXTENDER_ID.eq((Object)extenderId)).fetchOneInto(LocalDateTime.class);
        Timestamp lastExecutionTimestamp = lastExecutionOn != null ? Timestamp.valueOf(lastExecutionOn) : Timestamp.valueOf(LocalDateTime.now());
        return this.dslContext.select((SelectField)Tables.AUTOMATED_EXECUTION_FAILURE_DETAIL.EXECUTION_EXTENDER_ID).from((TableLike)Tables.AUTOMATED_EXECUTION_FAILURE_DETAIL).join((TableLike)Tables.FAILURE_DETAIL).on(Tables.AUTOMATED_EXECUTION_FAILURE_DETAIL.FAILURE_DETAIL_ID.eq((Field)Tables.FAILURE_DETAIL.FAILURE_DETAIL_ID)).join((TableLike)Tables.ISSUE).on(Tables.FAILURE_DETAIL.ISSUE_LIST_ID.eq((Field)Tables.ISSUE.ISSUE_LIST_ID)).join((TableLike)Tables.AUTOMATED_EXECUTION_EXTENDER).on(Tables.AUTOMATED_EXECUTION_FAILURE_DETAIL.EXECUTION_EXTENDER_ID.eq((Field)Tables.AUTOMATED_EXECUTION_EXTENDER.EXTENDER_ID)).join((TableLike)Tables.EXECUTION).on(Tables.AUTOMATED_EXECUTION_EXTENDER.MASTER_EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).where(Tables.ISSUE.ISSUE_ID.eq((Object)issueId)).and(Tables.EXECUTION.LAST_EXECUTED_ON.greaterOrEqual((Object)lastExecutionTimestamp)).fetchInto(Long.class);
    }

    @Override
    public List<Long> getSomeFailureDetailDoesNotHaveIssueByExtenderId(List<Long> extenderIds) {
        return this.dslContext.select((SelectField)Tables.AUTOMATED_EXECUTION_FAILURE_DETAIL.EXECUTION_EXTENDER_ID).from((TableLike)Tables.AUTOMATED_EXECUTION_FAILURE_DETAIL).join((TableLike)Tables.FAILURE_DETAIL).on(Tables.AUTOMATED_EXECUTION_FAILURE_DETAIL.FAILURE_DETAIL_ID.eq((Field)Tables.FAILURE_DETAIL.FAILURE_DETAIL_ID)).leftJoin((TableLike)Tables.ISSUE).on(Tables.FAILURE_DETAIL.ISSUE_LIST_ID.eq((Field)Tables.ISSUE.ISSUE_LIST_ID)).where(Tables.AUTOMATED_EXECUTION_FAILURE_DETAIL.EXECUTION_EXTENDER_ID.in(extenderIds)).and(Tables.ISSUE.ISSUE_ID.isNull()).groupBy(new GroupField[]{Tables.AUTOMATED_EXECUTION_FAILURE_DETAIL.EXECUTION_EXTENDER_ID}).having(DSL.count().gt((Object)0)).fetchInto(Long.class);
    }

    @Override
    public void updateToBeAnalysedFlag(List<Long> extenderIds) {
        this.entityManager.createQuery("UPDATE AutomatedExecutionExtender extender SET extender.flag = :flag   where extender.id in :extenderIds").setParameter(FLAG, (Object)ExecutionFlag.TO_BE_ANALYSED).setParameter(EXTENDER_IDS, extenderIds).executeUpdate();
    }

    @Override
    public boolean isProjectBoundToBugtrackerByExtenderId(Long extenderId) {
        return this.dslContext.select((SelectField)Tables.PROJECT.BUGTRACKER_ID).from((TableLike)Tables.AUTOMATED_EXECUTION_EXTENDER).join((TableLike)Tables.EXECUTION).on(Tables.AUTOMATED_EXECUTION_EXTENDER.MASTER_EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).join((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.EXECUTION.TEST_PLAN_ITEM_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).join((TableLike)Tables.TEST_PLAN).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN.TEST_PLAN_ID)).join((TableLike)Tables.PROJECT).on(Tables.TEST_PLAN.CL_ID.eq((Field)Tables.PROJECT.CL_ID)).where(Tables.AUTOMATED_EXECUTION_EXTENDER.EXTENDER_ID.eq((Object)extenderId)).fetchOneInto(Long.class) != null;
    }
}

