/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.NamedReference;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.CampaignIteration;
import org.squashtest.tm.jooq.domain.tables.CampaignLibraryNode;
import org.squashtest.tm.jooq.domain.tables.Iteration;
import org.squashtest.tm.service.internal.display.dto.UserView;
import org.squashtest.tm.service.internal.display.dto.campaign.IterationDto;
import org.squashtest.tm.service.internal.repository.display.IterationDisplayDao;

@Repository
public class IterationDisplayDaoImpl
implements IterationDisplayDao {
    private final DSLContext dsl;

    public IterationDisplayDaoImpl(DSLContext dsl) {
        this.dsl = dsl;
    }

    @Override
    public IterationDto findById(long iterationId) {
        return (IterationDto)this.dsl.select((SelectField)Iteration.ITERATION.ITERATION_ID.as("ID"), (SelectField)Iteration.ITERATION.NAME, (SelectField)Iteration.ITERATION.REFERENCE, (SelectField)Iteration.ITERATION.DESCRIPTION, (SelectField)Iteration.ITERATION.UUID, (SelectField)Iteration.ITERATION.ITERATION_STATUS, (SelectField)Iteration.ITERATION.CREATED_BY, (SelectField)Iteration.ITERATION.CREATED_ON, (SelectField)Iteration.ITERATION.LAST_MODIFIED_BY, (SelectField)Iteration.ITERATION.LAST_MODIFIED_ON, (SelectField)Iteration.ITERATION.ACTUAL_END_AUTO, (SelectField)Iteration.ITERATION.ACTUAL_END_DATE, (SelectField)Iteration.ITERATION.ACTUAL_START_AUTO, (SelectField)Iteration.ITERATION.ACTUAL_START_DATE, (SelectField)Iteration.ITERATION.SCHEDULED_END_DATE, (SelectField)Iteration.ITERATION.SCHEDULED_START_DATE, (SelectField)Iteration.ITERATION.ATTACHMENT_LIST_ID, (SelectField)DSL.field((Condition)DSL.count((Field)Tables.TEST_PLAN_ITEM.DATASET_ID).gt((Object)0)).as("HAS_DATASETS"), (SelectField)CampaignLibraryNode.CAMPAIGN_LIBRARY_NODE.PROJECT_ID, (SelectField)Iteration.ITERATION.TEST_PLAN_ID).from((TableLike)Iteration.ITERATION).innerJoin((TableLike)CampaignIteration.CAMPAIGN_ITERATION).on(Iteration.ITERATION.ITERATION_ID.eq((Field)CampaignIteration.CAMPAIGN_ITERATION.ITERATION_ID)).innerJoin((TableLike)CampaignLibraryNode.CAMPAIGN_LIBRARY_NODE).on(CampaignIteration.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Field)CampaignLibraryNode.CAMPAIGN_LIBRARY_NODE.CLN_ID)).leftJoin((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Iteration.ITERATION.TEST_PLAN_ID)).where(Iteration.ITERATION.ITERATION_ID.eq((Object)iterationId)).groupBy(new GroupField[]{Iteration.ITERATION.ITERATION_ID, CampaignLibraryNode.CAMPAIGN_LIBRARY_NODE.PROJECT_ID}).fetchOneInto(IterationDto.class);
    }

    @Override
    public HashMap<Long, String> getExecutionStatusMap(Long iterationId) {
        return (HashMap)this.dsl.select((SelectField)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID, (SelectField)Tables.TEST_PLAN_ITEM.EXECUTION_STATUS).from((TableLike)Iteration.ITERATION).innerJoin((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Iteration.ITERATION.TEST_PLAN_ID)).where(Iteration.ITERATION.ITERATION_ID.eq((Object)iterationId)).fetch().intoMap((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID, (Field)Tables.TEST_PLAN_ITEM.EXECUTION_STATUS);
    }

    @Override
    public int getTestPlanItemCount(Long testPlanId, String login) {
        Integer count;
        SelectConditionStep allTestPlanItemsFromIteration = this.dsl.selectCount().from((TableLike)Tables.TEST_PLAN_ITEM).leftJoin((TableLike)Tables.CORE_USER).on(Tables.CORE_USER.PARTY_ID.eq((Field)Tables.TEST_PLAN_ITEM.ASSIGNEE_ID)).where(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Object)testPlanId));
        if (login != null) {
            allTestPlanItemsFromIteration = allTestPlanItemsFromIteration.and(Tables.CORE_USER.LOGIN.eq((Object)login));
        }
        return (count = (Integer)allTestPlanItemsFromIteration.groupBy(new GroupField[]{Tables.TEST_PLAN_ITEM.TEST_PLAN_ID}).fetchOneInto(Integer.TYPE)) != null ? count : 0;
    }

    @Override
    public List<String> retrieveFullNameByIterationIds(List<Long> iterationIds, List<Long> projectIds) {
        Field fullName = DSL.when((Condition)Iteration.ITERATION.REFERENCE.isNull().or(Iteration.ITERATION.REFERENCE.eq((Object)"")), (Field)Iteration.ITERATION.NAME).otherwise(DSL.concat((Field[])new Field[]{Iteration.ITERATION.REFERENCE, DSL.val((String)" - "), Iteration.ITERATION.NAME}));
        return this.dsl.select((SelectField)fullName).from((TableLike)Iteration.ITERATION).join((TableLike)CampaignIteration.CAMPAIGN_ITERATION).on(Iteration.ITERATION.ITERATION_ID.eq((Field)CampaignIteration.CAMPAIGN_ITERATION.ITERATION_ID)).join((TableLike)CampaignLibraryNode.CAMPAIGN_LIBRARY_NODE).on(CampaignIteration.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Field)CampaignLibraryNode.CAMPAIGN_LIBRARY_NODE.CLN_ID)).where(Iteration.ITERATION.ITERATION_ID.in(iterationIds)).and(CampaignLibraryNode.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.in(projectIds)).orderBy((OrderField)fullName).fetch(fullName);
    }

    @Override
    public List<Long> findDistinctProjectIdsByIterationIds(Set<Long> iterationIds) {
        return this.dsl.selectDistinct((SelectField)CampaignLibraryNode.CAMPAIGN_LIBRARY_NODE.PROJECT_ID).from((TableLike)CampaignIteration.CAMPAIGN_ITERATION).leftJoin((TableLike)CampaignLibraryNode.CAMPAIGN_LIBRARY_NODE).on(CampaignIteration.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Field)CampaignLibraryNode.CAMPAIGN_LIBRARY_NODE.CLN_ID)).where(CampaignIteration.CAMPAIGN_ITERATION.ITERATION_ID.in(iterationIds)).fetchInto(Long.class);
    }

    @Override
    public Set<Long> findCampaignIdsByIterationIds(Set<Long> iterationIds) {
        return this.dsl.selectDistinct((SelectField)CampaignIteration.CAMPAIGN_ITERATION.CAMPAIGN_ID).from((TableLike)CampaignIteration.CAMPAIGN_ITERATION).where(CampaignIteration.CAMPAIGN_ITERATION.ITERATION_ID.in(iterationIds)).fetchSet((Field)CampaignIteration.CAMPAIGN_ITERATION.CAMPAIGN_ID);
    }

    @Override
    public List<NamedReference> findNamedReferences(List<Long> targetIds) {
        return this.dsl.select((SelectField)Iteration.ITERATION.ITERATION_ID, (SelectField)Iteration.ITERATION.NAME).from((TableLike)Iteration.ITERATION).where(Iteration.ITERATION.ITERATION_ID.in(targetIds)).fetch().into(NamedReference.class);
    }

    @Override
    public Map<Long, List<Long>> findExecutionIdsByIterationIds(List<Long> targetIds) {
        return this.dsl.select((SelectField)Iteration.ITERATION.ITERATION_ID, (SelectField)Tables.EXECUTION.EXECUTION_ID).from((TableLike)Iteration.ITERATION).innerJoin((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Iteration.ITERATION.TEST_PLAN_ID)).innerJoin((TableLike)Tables.EXECUTION).on(Tables.EXECUTION.TEST_PLAN_ITEM_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).where(Iteration.ITERATION.ITERATION_ID.in(targetIds)).fetchGroups((Field)Iteration.ITERATION.ITERATION_ID, (Field)Tables.EXECUTION.EXECUTION_ID);
    }

    @Override
    public Long findTestPlanId(long iterationId) {
        return (Long)this.dsl.select((SelectField)Iteration.ITERATION.TEST_PLAN_ID).from((TableLike)Iteration.ITERATION).where(Iteration.ITERATION.ITERATION_ID.eq((Object)iterationId)).fetchOneInto(Long.class);
    }

    @Override
    public List<UserView> getTestPlanItemExecutors(long iterationId) {
        return this.dsl.select((SelectField)Tables.CORE_USER.PARTY_ID.as("ID"), (SelectField)Tables.CORE_USER.FIRST_NAME, (SelectField)Tables.CORE_USER.LAST_NAME, (SelectField)Tables.CORE_USER.LOGIN).from((TableLike)Iteration.ITERATION).innerJoin((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Iteration.ITERATION.TEST_PLAN_ID)).innerJoin((TableLike)Tables.CORE_USER).on(Tables.CORE_USER.LOGIN.eq((Field)Tables.TEST_PLAN_ITEM.LAST_EXECUTED_BY)).where(Iteration.ITERATION.ITERATION_ID.eq((Object)iterationId)).orderBy((OrderField)Tables.CORE_USER.LOGIN).fetchInto(UserView.class);
    }
}

