/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository;

import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.squashtest.tm.api.plugin.PluginName;
import org.squashtest.tm.api.plugin.UsedInPlugin;
import org.squashtest.tm.domain.artificialintelligence.ProjectAiConfiguration;

public interface ProjectAiConfigurationDao
extends JpaRepository<ProjectAiConfiguration, Long> {
    @Modifying
    @Query(value="UPDATE ProjectAiConfiguration p SET p.aiServer = NULL WHERE p.aiServer.id IN :aiServerIds")
    public void removeAiServersFromProjectAiConfigurations(@Param(value="aiServerIds") List<Long> var1);

    @Query(value="SELECT COUNT(p) > 0 FROM ProjectAiConfiguration p WHERE p.project.id = :projectId AND p.aiUsage.id = :aiUsageId")
    public boolean existsByProjectIdAndAiUsageId(@Param(value="projectId") long var1, @Param(value="aiUsageId") Long var3);

    @Query(value="SELECT p FROM ProjectAiConfiguration p LEFT JOIN FETCH p.promptSet ps LEFT JOIN FETCH ps.prompts WHERE p.project.id = :projectId AND p.aiUsage.id = :aiUsageId")
    public ProjectAiConfiguration findByProjectIdAndAiUsageId(@Param(value="projectId") long var1, @Param(value="aiUsageId") Long var3);

    @Modifying
    @Query(value="DELETE FROM ProjectAiConfiguration p WHERE p.project.id = :projectId AND p.aiUsage.id = :aiUsageId")
    public void removeConfiguration(@Param(value="projectId") long var1, @Param(value="aiUsageId") Long var3);

    @Modifying
    @Query(value="UPDATE ProjectAiConfiguration p SET p.promptSet = NULL WHERE p.promptSet.id IN :promptSetIds")
    public void removePromptSetsFromProjectAiConfigurations(@Param(value="promptSetIds") List<Long> var1);

    @UsedInPlugin(names={PluginName.API_REST_ADMIN})
    public Page<ProjectAiConfiguration> findAllByProjectId(long var1, Pageable var3);
}

