/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectimporter.xrayimporter;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.exception.pivot.projectimporter.xrayimporter.XrayParsingException;
import org.squashtest.tm.service.internal.dto.projectimporterxray.XrayField;
import org.squashtest.tm.service.internal.dto.projectimporterxray.jooq.dto.CustomFieldXrayDto;
import org.squashtest.tm.service.internal.dto.projectimporterxray.jooq.dto.ItemXrayDto;
import org.squashtest.tm.service.internal.dto.projectimporterxray.model.XrayInfoModel;
import org.squashtest.tm.service.pivot.projectimporter.xrayimporter.ProjectImporterXrayToTableService;
import org.squashtest.tm.service.pivot.projectimporter.xrayimporter.XrayTablesDao;

@Service
public class ProjectImporterXrayToTableServiceImpl
implements ProjectImporterXrayToTableService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProjectImporterXrayToTableServiceImpl.class);
    private final XrayTablesDao xrayTablesDao;
    private final AtomicLong itemId = new AtomicLong(0L);
    private final AtomicLong customFieldId = new AtomicLong(0L);

    public ProjectImporterXrayToTableServiceImpl(XrayTablesDao xrayTablesDao) {
        this.xrayTablesDao = xrayTablesDao;
    }

    private void parsingXml(InputStream inputStream, ActionOnParsing<XMLStreamReader, XMLStreamException> actionOnParsing) throws XMLStreamException {
        XMLStreamReader xmlsr = null;
        try {
            XMLInputFactory xmlif = XMLInputFactory.newDefaultFactory();
            xmlif.setProperty("javax.xml.stream.isReplacingEntityReferences", true);
            xmlsr = xmlif.createXMLStreamReader(inputStream);
            actionOnParsing.apply(xmlsr);
        }
        finally {
            if (Objects.nonNull(xmlsr)) {
                xmlsr.close();
            }
        }
    }

    @Override
    public void getXrayInfoFromXMLParsing(InputStream inputStream, XrayInfoModel xrayInfoModel, String filename) {
        AtomicReference name = new AtomicReference();
        ArrayList lines = new ArrayList();
        try {
            this.parsingXml(inputStream, xmlsr -> {
                XrayInfoModel.Entity xrayInfoEntity = new XrayInfoModel.Entity();
                while (xmlsr.hasNext()) {
                    xmlsr.next();
                    xrayInfoEntity = this.handleAllElement((XMLStreamReader)xmlsr, xrayInfoModel, xrayInfoEntity, name, lines, filename);
                }
            });
        }
        catch (XMLStreamException e) {
            LOGGER.error("Error reading xray file:", (Throwable)e);
            if (!lines.isEmpty()) {
                int line = (Integer)lines.get(lines.size() - 1);
                if (name.get() == null) {
                    throw new XrayParsingException(filename, line, HtmlUtils.htmlEscape((String)e.getMessage()), (Throwable)e);
                }
                throw new XrayParsingException(filename, (String)name.get(), line, HtmlUtils.htmlEscape((String)e.getMessage()), (Throwable)e);
            }
            throw new XrayParsingException(filename, HtmlUtils.htmlEscape((String)e.getMessage()), (Throwable)e);
        }
    }

    private XrayInfoModel.Entity handleAllElement(XMLStreamReader xmlsr, XrayInfoModel xrayInfoModel, XrayInfoModel.Entity xrayInfoEntity, AtomicReference<String> name, List<Integer> lines, String filename) throws XMLStreamException {
        block24: {
            if (1 != xmlsr.getEventType()) break block24;
            lines.add(xmlsr.getLocation().getLineNumber());
            switch (xmlsr.getLocalName()) {
                case "item": {
                    xrayInfoEntity = new XrayInfoModel.Entity();
                    name.set(null);
                    break;
                }
                case "key": {
                    xrayInfoEntity.setKey(this.getContentElement(xmlsr));
                    break;
                }
                case "title": {
                    name.set(this.getContentElement(xmlsr));
                    break;
                }
                case "type": {
                    xrayInfoEntity.setType(this.getContentElement(xmlsr));
                    break;
                }
                case "status": {
                    xrayInfoEntity.getStatus().add(this.getContentElement(xmlsr));
                    break;
                }
                case "priority": {
                    xrayInfoEntity.getPriorities().add(this.getContentElement(xmlsr));
                    break;
                }
            }
        }
        if (2 == xmlsr.getEventType()) {
            if ("item".equals(xmlsr.getLocalName())) {
                xrayInfoModel.addEntity(xrayInfoEntity, filename);
                xrayInfoEntity = new XrayInfoModel.Entity();
            }
            lines.remove(lines.size() - 1);
        }
        return xrayInfoEntity;
    }

    @Override
    public void convertXrayToTable(InputStream inputStream) throws XMLStreamException {
        this.parsingXml(inputStream, this::handleAndSaveItem);
    }

    private void handleAndSaveItem(XMLStreamReader xmlsr) throws XMLStreamException {
        ArrayList<ItemXrayDto> itemXrayDtos = new ArrayList<ItemXrayDto>();
        while (xmlsr.hasNext()) {
            int eventType = xmlsr.next();
            if (1 != eventType || !xmlsr.getLocalName().equalsIgnoreCase("item")) continue;
            ItemXrayDto itemXrayDto = new ItemXrayDto();
            itemXrayDto.setId(this.itemId.incrementAndGet());
            this.handleNestedElement(xmlsr, xmlsr.getLocalName(), () -> this.handleElement(xmlsr, itemXrayDto));
            itemXrayDto.addPivotId(XrayField.Type.convertType(itemXrayDto.getType()));
            itemXrayDto.setLabelFromLabels(itemXrayDto.getLabels());
            itemXrayDtos.add(itemXrayDto);
            if (itemXrayDtos.size() % 10 != 0) continue;
            this.xrayTablesDao.createItems(itemXrayDtos);
            itemXrayDtos.clear();
        }
        if (!itemXrayDtos.isEmpty()) {
            this.xrayTablesDao.createItems(itemXrayDtos);
            itemXrayDtos.clear();
        }
    }

    private void handleElement(XMLStreamReader xmlsr, ItemXrayDto itemXrayDto) throws XMLStreamException {
        block46: {
            if (1 != xmlsr.getEventType()) break block46;
            switch (xmlsr.getLocalName().toLowerCase()) {
                case "title": {
                    itemXrayDto.setTitle(this.getContentElement(xmlsr));
                    break;
                }
                case "link": {
                    itemXrayDto.setLink(this.getContentElement(xmlsr));
                    break;
                }
                case "project": {
                    itemXrayDto.setProject(this.getContentElement(xmlsr));
                    break;
                }
                case "key": {
                    itemXrayDto.setKey(this.getContentElement(xmlsr));
                    break;
                }
                case "summary": {
                    itemXrayDto.setSummary(this.getContentElement(xmlsr));
                    break;
                }
                case "type": {
                    itemXrayDto.setType(this.getContentElement(xmlsr));
                    break;
                }
                case "priority": {
                    itemXrayDto.setPriority(this.getContentElement(xmlsr));
                    break;
                }
                case "status": {
                    itemXrayDto.setStatus(this.getContentElement(xmlsr));
                    break;
                }
                case "created": {
                    itemXrayDto.setCreated(this.getContentElement(xmlsr));
                    break;
                }
                case "reporter": {
                    itemXrayDto.setReporter(this.getContentElement(xmlsr));
                    break;
                }
                case "label": {
                    itemXrayDto.getLabels().add(this.getContentElement(xmlsr));
                    break;
                }
                case "description": {
                    itemXrayDto.setDescription(this.getAllContentElement(xmlsr, false));
                    break;
                }
                case "customfield": {
                    this.handleCustomField(xmlsr, itemXrayDto);
                    break;
                }
                case "issuelinks": {
                    this.handleIssueLink(xmlsr, itemXrayDto);
                    break;
                }
            }
        }
    }

    private void handleCustomField(XMLStreamReader xmlsr, ItemXrayDto itemXrayDto) throws XMLStreamException {
        String elementName = xmlsr.getLocalName();
        CustomFieldXrayDto customFieldData = new CustomFieldXrayDto();
        if (1 == xmlsr.getEventType()) {
            customFieldData.setKey(this.getAttributeValue(xmlsr, "key"));
        }
        this.handleNestedElement(xmlsr, elementName, () -> this.getCustomFieldAttributes(xmlsr, customFieldData, itemXrayDto));
    }

    private void getCustomFieldAttributes(XMLStreamReader xmlsr, CustomFieldXrayDto customFieldData, ItemXrayDto itemXrayDto) throws XMLStreamException {
        block10: {
            if (1 != xmlsr.getEventType()) break block10;
            switch (xmlsr.getLocalName()) {
                case "customfieldname": {
                    customFieldData.setName(this.getContentElement(xmlsr));
                    break;
                }
                case "customfieldvalues": {
                    this.handleNestedElement(xmlsr, xmlsr.getLocalName(), () -> this.getCustomFieldValues(xmlsr, customFieldData, itemXrayDto));
                    break;
                }
            }
        }
    }

    private void getCustomFieldValues(XMLStreamReader xmlsr, CustomFieldXrayDto customFieldData, ItemXrayDto itemXrayDto) throws XMLStreamException {
        block13: {
            String elementName;
            if (1 != xmlsr.getEventType()) break block13;
            switch (elementName = xmlsr.getLocalName()) {
                case "customfieldvalue": {
                    this.extractCustomFieldValue(xmlsr, customFieldData, itemXrayDto);
                    break;
                }
                case "steps": {
                    this.handleCustomFieldSteps(xmlsr, elementName, customFieldData, itemXrayDto);
                    break;
                }
                case "dataset": {
                    this.handleTestCaseDataset(xmlsr, elementName, customFieldData, itemXrayDto);
                    break;
                }
                default: {
                    this.addValueToCustomFieldDto(customFieldData, itemXrayDto, this.getAllContentElement(xmlsr, true));
                }
            }
        }
    }

    private void extractCustomFieldValue(XMLStreamReader xmlsr, CustomFieldXrayDto customFieldData, ItemXrayDto itemXrayDto) throws XMLStreamException {
        String rawContent = this.getAllContentElement(xmlsr, false);
        if (rawContent.startsWith("[") && rawContent.endsWith("]")) {
            String[] contents = rawContent.substring(1, rawContent.length() - 1).split(",");
            Arrays.stream(contents).map(StringUtils::trim).forEach(content -> {
                if (StringUtils.isNotEmpty((CharSequence)content)) {
                    this.addValueToCustomFieldDto(customFieldData, itemXrayDto, (String)content);
                }
            });
        } else {
            this.addValueToCustomFieldDto(customFieldData, itemXrayDto, rawContent);
        }
    }

    private void addValueToCustomFieldDto(CustomFieldXrayDto customFieldData, ItemXrayDto itemXrayDto, String value) {
        CustomFieldXrayDto customFieldXrayDto = new CustomFieldXrayDto(customFieldData, this.itemId, this.customFieldId);
        customFieldXrayDto.setValue(value);
        itemXrayDto.getCustomFields().add(customFieldXrayDto);
    }

    private void handleCustomFieldSteps(XMLStreamReader xmlsr, String elementName, CustomFieldXrayDto customFieldData, ItemXrayDto itemXrayDto) throws XMLStreamException {
        this.handleNestedElement(xmlsr, elementName, () -> this.handleCustomFieldStep(xmlsr, customFieldData, itemXrayDto));
    }

    private void handleCustomFieldStep(XMLStreamReader xmlsr, CustomFieldXrayDto customFieldData, ItemXrayDto itemXrayDto) throws XMLStreamException {
        if (1 == xmlsr.getEventType() && xmlsr.getLocalName().equalsIgnoreCase("step")) {
            CustomFieldXrayDto customFieldXrayDto = new CustomFieldXrayDto(customFieldData, this.itemId, this.customFieldId);
            this.handleNestedElement(xmlsr, "step", () -> this.handleCustomFieldStepElements(xmlsr, customFieldXrayDto));
            itemXrayDto.getCustomFields().add(customFieldXrayDto);
        }
    }

    private void handleCustomFieldStepElements(XMLStreamReader xmlsr, CustomFieldXrayDto customFieldXrayDto) throws XMLStreamException {
        block19: {
            if (1 != xmlsr.getEventType()) break block19;
            switch (xmlsr.getLocalName().toLowerCase()) {
                case "index": {
                    customFieldXrayDto.setStepIndex(Integer.parseInt(this.getContentElement(xmlsr)));
                    break;
                }
                case "action": {
                    customFieldXrayDto.setStepAction(this.getContentElement(xmlsr));
                    break;
                }
                case "data": {
                    customFieldXrayDto.setStepData(this.getContentElement(xmlsr));
                    break;
                }
                case "expected_result": {
                    customFieldXrayDto.setStepExpectedResult(this.getContentElement(xmlsr));
                    break;
                }
                case "call-test": {
                    this.handleCallTestCase(xmlsr, customFieldXrayDto);
                    break;
                }
            }
        }
    }

    private void handleCallTestCase(XMLStreamReader xmlsr, CustomFieldXrayDto customFieldXrayDto) throws XMLStreamException {
        String elementName = xmlsr.getLocalName();
        customFieldXrayDto.setStepCalledTestKey(this.getAttributeValue(xmlsr, "key"));
        HashMap<String, String> callTestParameters = new HashMap<String, String>();
        this.handleNestedElement(xmlsr, elementName, () -> this.handleCallTestCaseParameter(xmlsr, callTestParameters));
        customFieldXrayDto.setToStringStepCalledTestParameters(callTestParameters);
    }

    private void handleCallTestCaseParameter(XMLStreamReader xmlsr, Map<String, String> callTestParameters) throws XMLStreamException {
        if (1 == xmlsr.getEventType() && xmlsr.getLocalName().equalsIgnoreCase("parameter")) {
            callTestParameters.put(this.getAttributeValue(xmlsr, "name"), this.getContentElement(xmlsr));
        }
    }

    private void handleTestCaseDataset(XMLStreamReader xmlsr, String elementName, CustomFieldXrayDto customFieldData, ItemXrayDto itemXrayDto) throws XMLStreamException {
        AtomicInteger row = new AtomicInteger(0);
        this.handleNestedElement(xmlsr, elementName, () -> this.getDatasetAttributes(xmlsr, customFieldData, itemXrayDto, row));
    }

    private void getDatasetAttributes(XMLStreamReader xmlsr, CustomFieldXrayDto customFieldData, ItemXrayDto itemXrayDto, AtomicInteger row) throws XMLStreamException {
        if (1 == xmlsr.getEventType()) {
            if (xmlsr.getLocalName().equalsIgnoreCase("row")) {
                row.getAndIncrement();
            }
            if (xmlsr.getLocalName().equalsIgnoreCase("parameter")) {
                CustomFieldXrayDto customFieldXrayDto = new CustomFieldXrayDto(customFieldData, this.itemId, this.customFieldId);
                this.handleNestedElement(xmlsr, xmlsr.getLocalName(), () -> this.getDatasetParameter(xmlsr, customFieldXrayDto, row));
                itemXrayDto.getCustomFields().add(customFieldXrayDto);
            }
        }
    }

    private void getDatasetParameter(XMLStreamReader xmlsr, CustomFieldXrayDto customFieldXrayDto, AtomicInteger row) throws XMLStreamException {
        block10: {
            if (1 != xmlsr.getEventType()) break block10;
            switch (xmlsr.getLocalName().toLowerCase()) {
                case "name": {
                    customFieldXrayDto.setDatasetName(this.getContentElement(xmlsr));
                    break;
                }
                case "value": {
                    customFieldXrayDto.setDatasetValue(this.getContentElement(xmlsr));
                    break;
                }
            }
        }
        customFieldXrayDto.setDatasetRow(row.get());
    }

    private void handleIssueLink(XMLStreamReader xmlsr, ItemXrayDto itemXrayDto) throws XMLStreamException {
        String elementName = xmlsr.getLocalName();
        this.handleNestedElement(xmlsr, elementName, () -> this.handleIssueLinkType(xmlsr, itemXrayDto));
    }

    private void handleIssueLinkType(XMLStreamReader xmlsr, ItemXrayDto itemXrayDto) throws XMLStreamException {
        if (1 == xmlsr.getEventType() && xmlsr.getLocalName().equalsIgnoreCase("issuelinktype")) {
            CustomFieldXrayDto customFieldData = new CustomFieldXrayDto();
            customFieldData.setKey("issuelinks-key");
            this.handleNestedElement(xmlsr, xmlsr.getLocalName(), () -> this.handleIssueRelationship(xmlsr, customFieldData, itemXrayDto));
        }
    }

    private void handleIssueRelationship(XMLStreamReader xmlsr, CustomFieldXrayDto customFieldData, ItemXrayDto itemXrayDto) throws XMLStreamException {
        block12: {
            if (xmlsr.getEventType() != 1) break block12;
            switch (xmlsr.getLocalName().toLowerCase()) {
                case "name": {
                    customFieldData.setIssueLinkName(this.getContentElement(xmlsr));
                    break;
                }
                case "inwardlinks": 
                case "outwardlinks": {
                    this.handleIssueLinkKeys(xmlsr, customFieldData, itemXrayDto);
                    break;
                }
            }
        }
    }

    private void handleIssueLinkKeys(XMLStreamReader xmlsr, CustomFieldXrayDto customFieldData, ItemXrayDto itemXrayDto) throws XMLStreamException {
        String elementName = xmlsr.getLocalName();
        this.handleNestedElement(xmlsr, elementName, () -> this.extractIssueLinkKey(xmlsr, elementName, customFieldData, itemXrayDto));
    }

    private void extractIssueLinkKey(XMLStreamReader xmlsr, String elementName, CustomFieldXrayDto customFieldData, ItemXrayDto itemXrayDto) throws XMLStreamException {
        if (xmlsr.getEventType() == 1 && xmlsr.getLocalName().equalsIgnoreCase("issuekey")) {
            CustomFieldXrayDto customFieldXrayDto = new CustomFieldXrayDto(customFieldData, this.itemId, this.customFieldId);
            customFieldXrayDto.setIssueLinkKey(this.getContentElement(xmlsr));
            customFieldXrayDto.setIssueLinkRelationship(elementName);
            itemXrayDto.getCustomFields().add(customFieldXrayDto);
        }
    }

    private String getContentElement(XMLStreamReader xmlsr) throws XMLStreamException {
        String elementName = xmlsr.getLocalName();
        StringBuilder stringBuilder = new StringBuilder();
        this.handleNestedElement(xmlsr, elementName, () -> this.appendContentElement(xmlsr, stringBuilder));
        return this.formatContent(stringBuilder.toString());
    }

    private String getAllContentElement(XMLStreamReader xmlsr, boolean includeLoopElement) throws XMLStreamException {
        StringBuilder stringBuilder = new StringBuilder();
        if (includeLoopElement) {
            this.extractElementData(xmlsr, stringBuilder);
        }
        this.extractAllElementData(xmlsr, includeLoopElement, stringBuilder);
        return this.formatContent(stringBuilder.toString());
    }

    private String formatContent(String content) {
        content = StringUtils.trim((String)content);
        return HtmlUtils.htmlUnescape((String)content).replace("\u00a0", " ");
    }

    private void appendContentElement(XMLStreamReader xmlsr, StringBuilder stringBuilder) {
        if (4 == xmlsr.getEventType()) {
            stringBuilder.append(xmlsr.getText().replaceAll("\\R+", " ").replaceAll("\\s{2,}", " "));
        }
    }

    private void extractAllElementData(XMLStreamReader xmlsr, boolean includeLoopElement, StringBuilder stringBuilder) throws XMLStreamException {
        String elementName = xmlsr.getLocalName();
        boolean nextContent = true;
        while (nextContent) {
            int eventType = xmlsr.next();
            if (2 == eventType && xmlsr.getLocalName().equalsIgnoreCase(elementName)) {
                nextContent = false;
                if (!includeLoopElement) continue;
                stringBuilder.append("</").append(xmlsr.getLocalName()).append(">");
                continue;
            }
            this.extractElementData(xmlsr, stringBuilder);
        }
    }

    private void extractElementData(XMLStreamReader xmlsr, StringBuilder stringBuilder) {
        switch (xmlsr.getEventType()) {
            case 1: {
                this.buildStartElement(xmlsr, stringBuilder);
                break;
            }
            case 4: {
                stringBuilder.append(xmlsr.getText().replaceAll("\\R+", " ").replaceAll("\\s{2,}", " "));
                break;
            }
            case 2: {
                stringBuilder.append("</").append(xmlsr.getLocalName()).append(">");
                break;
            }
            case 9: {
                if (!"nbsp".equalsIgnoreCase(xmlsr.getLocalName())) break;
                stringBuilder.append(" ");
                break;
            }
        }
    }

    private void buildStartElement(XMLStreamReader xmlsr, StringBuilder stringBuilder) {
        stringBuilder.append("<").append(xmlsr.getLocalName());
        int i = 0;
        while (i < xmlsr.getAttributeCount()) {
            stringBuilder.append(" ").append(xmlsr.getAttributeLocalName(i)).append("=\"").append(xmlsr.getAttributeValue(i)).append("\"");
            ++i;
        }
        stringBuilder.append(">");
    }

    private String getAttributeValue(XMLStreamReader xmlsr, String attributeName) {
        int i = 0;
        while (i < xmlsr.getAttributeCount()) {
            if (xmlsr.getAttributeLocalName(i).equalsIgnoreCase(attributeName)) {
                return xmlsr.getAttributeValue(i);
            }
            ++i;
        }
        return null;
    }

    private void handleNestedElement(XMLStreamReader xmlsr, String elementName, ActionNestedElement action) throws XMLStreamException {
        boolean nestedElement = true;
        while (nestedElement) {
            int eventType = xmlsr.next();
            if (2 == eventType && xmlsr.getLocalName().equalsIgnoreCase(elementName)) {
                nestedElement = false;
                continue;
            }
            action.apply();
        }
    }

    @FunctionalInterface
    private static interface ActionNestedElement {
        public void apply() throws XMLStreamException;
    }

    @FunctionalInterface
    private static interface ActionOnParsing<T, U extends Throwable> {
        public void apply(T var1) throws U;
    }
}

