/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.search;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import jakarta.persistence.EntityManager;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.testcase.TestCaseAutomatable;
import org.squashtest.tm.domain.testcase.TestCaseExecutionMode;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.domain.testcase.TestCaseStatus;
import org.squashtest.tm.service.display.search.TestCaseSearchModificationService;
import org.squashtest.tm.service.internal.display.search.TestCaseMassUpdatePatch;
import org.squashtest.tm.service.internal.repository.TestCaseDao;
import org.squashtest.tm.service.testcase.TestCaseModificationService;

@Service
@Transactional
public class TestCaseSearchModificationServiceImpl
implements TestCaseSearchModificationService {
    private final EntityManager entityManager;
    private final TestCaseModificationService testCaseModificationService;
    private final TestCaseDao testCaseDao;

    public TestCaseSearchModificationServiceImpl(EntityManager entityManager, TestCaseModificationService testCaseModificationService, TestCaseDao testCaseDao) {
        this.entityManager = entityManager;
        this.testCaseModificationService = testCaseModificationService;
        this.testCaseDao = testCaseDao;
    }

    @Override
    public void massUpdate(TestCaseMassUpdatePatch patch) {
        Map testCasesMap = this.testCaseDao.findTestCaseExecutionModesByTestCaseIds(patch.getTestCaseIds());
        List partitionedIds = Lists.partition(patch.getTestCaseIds(), (int)10);
        for (List ids : partitionedIds) {
            this.updateProperties(ids, patch, testCasesMap);
            this.entityManager.flush();
            this.entityManager.clear();
        }
    }

    private void updateProperties(List<Long> testCaseIds, TestCaseMassUpdatePatch patch, Map<Long, String> testCasesMap) {
        for (Long id : testCaseIds) {
            boolean isExploratory = TestCaseExecutionMode.EXPLORATORY.name().equals(testCasesMap.get(id));
            this.updateCommonProperties(patch, id);
            if (isExploratory) continue;
            this.updatePropertiesForNonExploratoryTestCases(patch, id);
        }
    }

    private void updateCommonProperties(TestCaseMassUpdatePatch patch, Long id) {
        if (patch.getType() != null) {
            this.testCaseModificationService.changeType((long)id, patch.getType());
        }
        if (patch.getNature() != null) {
            this.testCaseModificationService.changeNature((long)id, patch.getNature());
        }
        if (!Strings.isNullOrEmpty((String)patch.getStatus())) {
            this.testCaseModificationService.changeStatus(id, TestCaseStatus.valueOf((String)patch.getStatus()));
        }
        if (!Strings.isNullOrEmpty((String)patch.getImportance())) {
            this.testCaseModificationService.changeImportanceAuto(id, patch.isImportanceAuto());
            if (!patch.isImportanceAuto()) {
                this.testCaseModificationService.changeImportance(id, TestCaseImportance.valueOf((String)patch.getImportance()));
            }
        }
    }

    private void updatePropertiesForNonExploratoryTestCases(TestCaseMassUpdatePatch patch, Long id) {
        if (patch.isChangeAutomatedTestTechnology()) {
            if (patch.getAutomatedTestTechnology() == null) {
                this.testCaseModificationService.unbindAutomatedTestTechnology(id);
            } else {
                this.testCaseModificationService.changeAutomatedTestTechnology(id, patch.getAutomatedTestTechnology());
            }
        }
        if (patch.isChangeScmRepository()) {
            if (patch.getScmRepository() == null) {
                this.testCaseModificationService.unbindSourceCodeRepository(id);
            } else {
                this.testCaseModificationService.changeSourceCodeRepository(id, patch.getScmRepository());
            }
        }
        if (!Strings.isNullOrEmpty((String)patch.getAutomatable())) {
            this.testCaseModificationService.changeAutomatable(TestCaseAutomatable.valueOf((String)patch.getAutomatable()), id);
        }
    }
}

