/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.dto;

import java.util.List;

public class ProjectDataInfo {
    public static final String DELETABLE_PROJECT_I18N_KEY = "sqtm-core.administration-workspace.projects.dialog.message.delete-project";
    public static final String NO_DELETABLE_PROJECT_I18N_KEY = "sqtm-core.administration-workspace.projects.dialog.message.cannot-delete-project-with-data";
    public static final String DELETABLE_PROJECT_I18N_KEY_WITH_LINKED_JOBS = "sqtm-core.administration-workspace.projects.dialog.message.delete-project-with-linked-jobs";
    public static final String CANNOT_COERCE_INTO_TEMPLATE_I18N_KEY = "sqtm-core.administration-workspace.projects.dialog.message.cannot-coerce-into-template";
    public static final String COERCE_INTO_TEMPLATE_I18N_KEY = "sqtm-core.administration-workspace.projects.dialog.message.coerce-into-template";
    private boolean hasData;
    private String i18nMessageKey;
    private List<NonEmptyWorkspaceModel> nonEmptyWorkspaces;

    public ProjectDataInfo(boolean hasData, String i18nMessageKey) {
        this.hasData = hasData;
        this.i18nMessageKey = i18nMessageKey;
    }

    public ProjectDataInfo(boolean hasData, String i18nMessageKey, List<NotEmptyWorkspace> nonEmptyWorkspaces) {
        this.hasData = hasData;
        this.i18nMessageKey = i18nMessageKey;
        this.nonEmptyWorkspaces = this.getNonEmptyWorkspaces(nonEmptyWorkspaces);
    }

    public ProjectDataInfo() {
    }

    public boolean isHasData() {
        return this.hasData;
    }

    public void setHasData(boolean hasData) {
        this.hasData = hasData;
    }

    public String getI18nMessageKey() {
        return this.i18nMessageKey;
    }

    public void setI18nMessageKey(String i18nMessageKey) {
        this.i18nMessageKey = i18nMessageKey;
    }

    public List<NonEmptyWorkspaceModel> getNonEmptyWorkspaces() {
        return this.nonEmptyWorkspaces;
    }

    public List<NonEmptyWorkspaceModel> getNonEmptyWorkspaces(List<NotEmptyWorkspace> nonEmptyWorkspaces) {
        return nonEmptyWorkspaces.stream().map(workspace -> new NonEmptyWorkspaceModel((NotEmptyWorkspace)((Object)workspace), workspace.getI18nKey())).toList();
    }

    public record NonEmptyWorkspaceModel(NotEmptyWorkspace id, String i18nKey) {
    }

    public static enum NotEmptyWorkspace {
        REQUIREMENT("sqtm-core.requirement-workspace.label.short"),
        TEST_CASE("sqtm-core.test-case-workspace.label.short"),
        CAMPAIGN("sqtm-core.campaign-workspace.label.short"),
        CUSTOM_REPORT("sqtm-core.custom-report-workspace.label.short"),
        ACTION_WORD("sqtm-core.action-word-workspace.label.short");

        private final String i18nKey;

        private NotEmptyWorkspace(String i18nKey) {
            this.i18nKey = i18nKey;
        }

        public String getI18nKey() {
            return this.i18nKey;
        }
    }

    public static enum ProjectAction {
        TRANSFORMATION,
        DELETION;

    }
}

