/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.deletion;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.attachment.AttachmentHolder;
import org.squashtest.tm.domain.attachment.AttachmentList;
import org.squashtest.tm.domain.attachment.ExternalContentCoordinates;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.testcase.ActionTestStep;
import org.squashtest.tm.domain.testcase.CallTestStep;
import org.squashtest.tm.domain.testcase.KeywordTestStep;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseFolder;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNode;
import org.squashtest.tm.domain.testcase.TestStep;
import org.squashtest.tm.domain.testcase.TestStepVisitor;
import org.squashtest.tm.service.deletion.OperationReport;
import org.squashtest.tm.service.deletion.SuppressionPreviewReport;
import org.squashtest.tm.service.internal.attachment.AttachmentManagerServiceImpl;
import org.squashtest.tm.service.internal.campaign.LockedTestCaseNodeDetectionService;
import org.squashtest.tm.service.internal.customfield.PrivateCustomFieldValueService;
import org.squashtest.tm.service.internal.deletion.AbstractNodeDeletionHandler;
import org.squashtest.tm.service.internal.deletion.JdbcTestCaseNodeDeletionHandlerFactory;
import org.squashtest.tm.service.internal.deletion.LockedNodeInferenceTree;
import org.squashtest.tm.service.internal.repository.AutomatedTestDao;
import org.squashtest.tm.service.internal.repository.AutomationRequestDao;
import org.squashtest.tm.service.internal.repository.CustomSprintReqVersionDao;
import org.squashtest.tm.service.internal.repository.TestCaseDeletionDao;
import org.squashtest.tm.service.internal.repository.TestCaseLibraryNodeDao;
import org.squashtest.tm.service.internal.testcase.TestCaseNodeDeletionHandler;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;
import org.squashtest.tm.service.testcase.CallStepManagerService;
import org.squashtest.tm.service.testcase.DatasetModificationService;
import org.squashtest.tm.service.testcase.ParameterModificationService;
import org.squashtest.tm.service.testcase.TestCaseImportanceManagerService;

@Component(value="squashtest.tm.service.deletion.TestCaseNodeDeletionHandler")
@Transactional
public class TestCaseNodeDeletionHandlerImpl
extends AbstractNodeDeletionHandler<TestCaseLibraryNode, TestCaseFolder>
implements TestCaseNodeDeletionHandler {
    private static final String FOLDER_IDS = "folderIds";
    private static final String NODE_IDS = "nodeIds";
    private final LockedTestCaseNodeDetectionService lockedTestCaseNodeDetectionService;
    private final TestCaseLibraryNodeDao testCaseLibraryNodeDao;
    private final TestCaseDeletionDao deletionDao;
    private final TestCaseImportanceManagerService testCaseImportanceManagerService;
    private final DatasetModificationService datasetService;
    private final ParameterModificationService parameterService;
    private final PrivateCustomFieldValueService customValueService;
    private final AutomatedTestDao autoTestDao;
    private final ActiveMilestoneHolder activeMilestoneHolder;
    private final AutomationRequestDao requestDao;
    private final CallStepManagerService callStepManagerService;
    private final CustomSprintReqVersionDao customSprintReqVersionDao;
    private final JdbcTestCaseNodeDeletionHandlerFactory testCaseDeletionHandler;

    public TestCaseNodeDeletionHandlerImpl(LockedTestCaseNodeDetectionService lockedTestCaseNodeDetectionService, TestCaseLibraryNodeDao testCaseLibraryNodeDao, TestCaseDeletionDao deletionDao, TestCaseImportanceManagerService testCaseImportanceManagerService, DatasetModificationService datasetService, ParameterModificationService parameterService, PrivateCustomFieldValueService customValueService, AutomatedTestDao autoTestDao, ActiveMilestoneHolder activeMilestoneHolder, AutomationRequestDao requestDao, CallStepManagerService callStepManagerService, CustomSprintReqVersionDao customSprintReqVersionDao, JdbcTestCaseNodeDeletionHandlerFactory testCaseDeletionHandler, AttachmentManagerServiceImpl attachmentManagerService, MessageSource messageSource) {
        super(attachmentManagerService, messageSource, deletionDao);
        this.lockedTestCaseNodeDetectionService = lockedTestCaseNodeDetectionService;
        this.testCaseLibraryNodeDao = testCaseLibraryNodeDao;
        this.deletionDao = deletionDao;
        this.testCaseImportanceManagerService = testCaseImportanceManagerService;
        this.datasetService = datasetService;
        this.parameterService = parameterService;
        this.customValueService = customValueService;
        this.autoTestDao = autoTestDao;
        this.activeMilestoneHolder = activeMilestoneHolder;
        this.requestDao = requestDao;
        this.callStepManagerService = callStepManagerService;
        this.customSprintReqVersionDao = customSprintReqVersionDao;
        this.testCaseDeletionHandler = testCaseDeletionHandler;
    }

    @Override
    public OperationReport deleteNodes(List<Long> targetIds) {
        if (targetIds.isEmpty()) {
            return new OperationReport();
        }
        LockedNodeInferenceTree tree = this.createLockedTree(targetIds);
        List<Long> deletableNodeIds = tree.collectDeletableIds();
        OperationReport deleteReport = !deletableNodeIds.isEmpty() ? this.testCaseDeletionHandler.build(deletableNodeIds).delete() : new OperationReport();
        if (this.isMilestoneMode()) {
            List<Long> candidateNodeIds = tree.collectIds();
            OperationReport unbindReport = this.batchUnbindFromMilestone(candidateNodeIds);
            deleteReport.mergeWith(unbindReport);
        }
        return deleteReport;
    }

    private LockedNodeInferenceTree createLockedTree(List<Long> targetIds) {
        Map<Long, List<Long>> descendantByAncestor = this.testCaseLibraryNodeDao.findContentIdsByNodeIds(targetIds);
        LockedNodeInferenceTree tree = new LockedNodeInferenceTree(descendantByAncestor, targetIds);
        List<Long> lockedNodeIds = this.detectLockedNodes(tree.collectIds());
        tree.markLockedNodes(lockedNodeIds);
        return tree;
    }

    @Override
    protected List<SuppressionPreviewReport> diagnoseSuppression(List<Long> nodeIds) {
        ArrayList<SuppressionPreviewReport> reportList = new ArrayList<SuppressionPreviewReport>();
        reportList.addAll(this.lockedTestCaseNodeDetectionService.detectLockedByExecutedTestCases(nodeIds));
        reportList.addAll(this.lockedTestCaseNodeDetectionService.detectLockedByMilestone(nodeIds));
        reportList.addAll(this.lockedTestCaseNodeDetectionService.detectLockedWithActiveMilestone(nodeIds));
        reportList.addAll(this.lockedTestCaseNodeDetectionService.detectLockedByCallSteps(nodeIds, reportList));
        return reportList;
    }

    @Override
    protected OperationReport batchDeleteNodes(List<Long> ids) {
        OperationReport report = new OperationReport();
        if (!ids.isEmpty()) {
            DeletableIds deletableIds = this.findSeparateIds(ids);
            List<Long> folderIds = deletableIds.getFolderIds();
            List<Long> tcIds = deletableIds.getTestCaseIds();
            List<Long> stepIds = this.deletionDao.findTestSteps(tcIds);
            List<Long> testCaseAttachmentIds = this.deletionDao.findTestCaseAttachmentListIds(tcIds);
            List<Long> testStepAttachmentIds = this.deletionDao.findTestStepAttachmentListIds(stepIds);
            List<Long> testCaseFolderAttachmentIds = this.deletionDao.findTestCaseFolderAttachmentListIds(folderIds);
            testCaseAttachmentIds.addAll(testStepAttachmentIds);
            testCaseAttachmentIds.addAll(testCaseFolderAttachmentIds);
            List<ExternalContentCoordinates> listPairContentIDListID = this.attachmentManager.getListIDbyContentIdForAttachmentLists(testCaseAttachmentIds);
            List automationRequestIds = this.requestDao.getReqIdsByTcIds(tcIds);
            this.deletionDao.removeAutomationRequestLibraryContent(automationRequestIds);
            this.deletionDao.removeCampaignTestPlanInboundReferences(tcIds);
            this.deletionDao.removeOrSetIterationTestPlanInboundReferencesToNull(tcIds);
            this.deletionDao.setExecutionInboundReferencesToNull(tcIds);
            this.deletionDao.setExecStepInboundReferencesToNull(stepIds);
            this.deletionDao.removeFromVerifyingTestStepsList(stepIds);
            this.deletionDao.removeFromVerifyingTestCaseLists(tcIds);
            this.customValueService.deleteAllCustomFieldValues(BindableEntity.TEST_STEP, stepIds);
            this.deletionDao.removeAllSteps(stepIds);
            this.attachmentManager.removeAttachmentsAndLists(testStepAttachmentIds);
            this.customValueService.deleteAllCustomFieldValues(BindableEntity.TESTCASE_FOLDER, folderIds);
            this.customValueService.deleteAllCustomFieldValues(BindableEntity.TEST_CASE, tcIds);
            this.datasetService.removeAllByTestCaseIds(tcIds);
            this.parameterService.removeAllByTestCaseIds(tcIds);
            this.customSprintReqVersionDao.removeTestPlanItemOrNullifyReferencedTestCase(tcIds);
            this.deletionDao.removeEntities(deletableIds.getAllIds());
            this.attachmentManager.deleteContents(listPairContentIDListID);
            report.addRemoved(folderIds, "folder");
            report.addRemoved(tcIds, "test-case");
            this.autoTestDao.pruneOrphans();
        }
        return report;
    }

    @Override
    protected OperationReport batchUnbindFromMilestone(List<Long> ids) {
        List<Long> remainingIds = this.deletionDao.findRemainingTestCaseIds(ids);
        Optional<Milestone> activeMilestone = this.activeMilestoneHolder.getActiveMilestone();
        List<Long> lockedIds = this.deletionDao.findTestCasesWhichMilestonesForbidsDeletion(remainingIds);
        remainingIds.removeAll(lockedIds);
        OperationReport report = new OperationReport();
        activeMilestone.ifPresent(milestone -> this.deletionDao.unbindFromMilestone(remainingIds, milestone.getId()));
        report.addRemoved(remainingIds, "test-case");
        return report;
    }

    @Override
    public void deleteStep(final TestCase owner, TestStep step) {
        int index = owner.getPositionOfStep(step.getId().longValue());
        if (index == -1) {
            return;
        }
        owner.getSteps().remove(index);
        LinkedList<Long> stepId = new LinkedList<Long>();
        stepId.add(step.getId());
        this.deletionDao.setExecStepInboundReferencesToNull(stepId);
        TestStepVisitor testStepVisitor = new TestStepVisitor(){

            public void visit(ActionTestStep visited) {
                TestCaseNodeDeletionHandlerImpl.this.customValueService.deleteAllCustomFieldValues((BoundEntity)visited);
                TestCaseNodeDeletionHandlerImpl.this.deleteActionStep(visited);
                TestCaseNodeDeletionHandlerImpl.this.customValueService.deleteAllCustomFieldValues((BoundEntity)visited);
            }

            public void visit(CallTestStep visited) {
                TestCaseNodeDeletionHandlerImpl.this.doDeleteTestStep((TestStep)visited);
                TestCaseNodeDeletionHandlerImpl.this.deleteOrphanDatasetParamValues(visited.isDelegateParameterValues(), owner.getId());
                TestCaseNodeDeletionHandlerImpl.this.testCaseImportanceManagerService.changeImportanceIfCallStepRemoved(visited.getCalledTestCase(), owner);
            }

            public void visit(KeywordTestStep visited) {
                TestCaseNodeDeletionHandlerImpl.this.doDeleteTestStep((TestStep)visited);
            }
        };
        step.accept(testStepVisitor);
    }

    private void deleteActionStep(ActionTestStep step) {
        AttachmentList attachmentList = step.getAttachmentList();
        List<ExternalContentCoordinates> listPairContenIDListID = this.getExternalAttachmentContentCoordinatesOfObject((AttachmentHolder)step);
        this.doDeleteTestStep((TestStep)step);
        this.attachmentManager.removeAttachmentsAndLists(this.makeListAttachmentListIdFordAttachmentList(attachmentList));
        this.attachmentManager.deleteContents(listPairContenIDListID);
    }

    private void doDeleteTestStep(TestStep step) {
        this.deletionDao.removeEntity(step);
    }

    private DeletableIds findSeparateIds(List<Long> ids) {
        Map<String, List<Long>> separatedIds = this.deletionDao.separateFolderFromTestCaseIds(ids);
        return new DeletableIds(separatedIds.get(FOLDER_IDS), separatedIds.get(NODE_IDS));
    }

    private void deleteOrphanDatasetParamValues(boolean isDelegateParameterValues, Long testCaseCallerId) {
        if (isDelegateParameterValues) {
            this.callStepManagerService.deleteOrphanDatasetParamValuesByTestCaseCallerId(testCaseCallerId);
        }
    }

    @Override
    protected boolean isMilestoneMode() {
        return this.activeMilestoneHolder.getActiveMilestone().isPresent();
    }

    private static final class DeletableIds {
        private final List<Long> folderIds;
        private final List<Long> testCaseIds;

        public DeletableIds(List<Long> folderIds, List<Long> testCaseIds) {
            this.folderIds = folderIds;
            this.testCaseIds = testCaseIds;
        }

        public List<Long> getFolderIds() {
            return this.folderIds;
        }

        public List<Long> getTestCaseIds() {
            return this.testCaseIds;
        }

        public List<Long> getAllIds() {
            ArrayList<Long> all = new ArrayList<Long>(this.folderIds.size() + this.testCaseIds.size());
            all.addAll(this.folderIds);
            all.addAll(this.testCaseIds);
            return all;
        }
    }
}

