/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.artificialintelligence.testcasegeneration;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import dev.langchain4j.service.Result;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minidev.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.aiserver.AiProvider;
import org.squashtest.tm.domain.servers.TokenAuthCredentials;
import org.squashtest.tm.exception.artificialintelligence.server.AiServerJsonResponseParsingException;
import org.squashtest.tm.exception.artificialintelligence.testcasegeneration.AiServerBadPayloadTemplateException;
import org.squashtest.tm.exception.artificialintelligence.testcasegeneration.AiServerInitializeRemoteActionException;
import org.squashtest.tm.exception.artificialintelligence.testcasegeneration.AiServerMalformedUrlException;
import org.squashtest.tm.exception.artificialintelligence.testcasegeneration.AiServerNotConfiguredException;
import org.squashtest.tm.exception.artificialintelligence.testcasegeneration.AiServerResponseInoperableException;
import org.squashtest.tm.exception.artificialintelligence.testcasegeneration.AiServerWrongTokenException;
import org.squashtest.tm.exception.artificialintelligence.testcasegeneration.AiServerWrongUrlException;
import org.squashtest.tm.exception.artificialintelligence.testcasegeneration.RemoteAiServerActionException;
import org.squashtest.tm.exception.artificialintelligence.testcasegeneration.UnextractableAiServerResponseException;
import org.squashtest.tm.service.annotation.IsUltimateLicenseAvailable;
import org.squashtest.tm.service.artificialintelligence.AiChatClientProvider;
import org.squashtest.tm.service.artificialintelligence.testcasegeneration.AiTestCaseGenerationService;
import org.squashtest.tm.service.internal.artificialintelligence.AiChatClient;
import org.squashtest.tm.service.internal.display.dto.aiserver.AiServerConfiguration;
import org.squashtest.tm.service.internal.display.dto.aiserver.AiServerDto;
import org.squashtest.tm.service.internal.display.dto.aiserver.CustomAiServerConfiguration;
import org.squashtest.tm.service.internal.dto.TestCaseFromAiDto;
import org.squashtest.tm.service.internal.repository.AiTestCaseGenerationDao;
import org.squashtest.tm.service.internal.repository.RequirementVersionDao;
import org.squashtest.tm.service.internal.templaterenderer.HandlebarsTemplateRenderer;
import org.squashtest.tm.service.internal.utils.HTMLCleanupUtils;
import org.squashtest.tm.service.servers.StoredCredentialsManager;

@Service
@Transactional
public class AiTestCaseGenerationServiceImpl
implements AiTestCaseGenerationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AiTestCaseGenerationServiceImpl.class);
    private static final String NO_RESPONSE_FROM_SERVER = "sqtm-core.exception.artificial-intelligence.generate-test-case.cannot-get-response";
    private static final String NO_RESPONSE_MESSAGE_FROM_SERVER = "sqtm-core.exception.artificial-intelligence.generate-test-case.cannot-get-response-message";
    private static final String REQUIREMENT = "requirement";
    private final RequirementVersionDao requirementVersionDao;
    private final AiTestCaseGenerationDao aiTestCaseGenerationDao;
    private final StoredCredentialsManager credentialsManager;
    private final AiChatClientProvider aiChatClientProvider;

    public AiTestCaseGenerationServiceImpl(RequirementVersionDao requirementVersionDao, AiTestCaseGenerationDao aiTestCaseGenerationDao, StoredCredentialsManager credentialsManager, AiChatClientProvider aiChatClientProvider) {
        this.requirementVersionDao = requirementVersionDao;
        this.aiTestCaseGenerationDao = aiTestCaseGenerationDao;
        this.credentialsManager = credentialsManager;
        this.aiChatClientProvider = aiChatClientProvider;
    }

    @Override
    @IsUltimateLicenseAvailable
    public List<TestCaseFromAiDto> generateTestCaseFromRequirementUsingAiUserSide(long requirementVersionId, String userMessage, Long promptId) {
        Long projectIdLinkedToRequirement = this.requirementVersionDao.findProjectIdByRequirementVersionId(requirementVersionId);
        AiServerDto aiServerDto = this.aiTestCaseGenerationDao.findAiServerDtoByProjectId(projectIdLinkedToRequirement);
        AiTestCaseGenerationServiceImpl.checkIfAiServerIsConfigured(aiServerDto);
        String parsedUserMessage = HTMLCleanupUtils.htmlToLayoutAwareText(userMessage, true);
        return this.doGenerateTestCaseFromRequirementUsingAi(aiServerDto, parsedUserMessage, promptId);
    }

    private List<TestCaseFromAiDto> doGenerateTestCaseFromRequirementUsingAi(AiServerDto aiServerDto, String userMessage, Long promptId) {
        AiChatClient aiChatClient = this.aiChatClientProvider.createAiChatClient(aiServerDto, promptId);
        LOGGER.info("Starting to generate test cases from requirement", new Object[0]);
        Result<String> response = aiChatClient.doChat(userMessage);
        String cleanedResponse = this.cleanServerResponse((String)response.content(), (String)response.content());
        return this.extractGeneratedTestCases(cleanedResponse);
    }

    private static void checkIfAiServerIsConfigured(AiServerDto aiServerDto) {
        AiProvider provider = aiServerDto.getProvider();
        switch (provider) {
            case NONE: {
                AiTestCaseGenerationServiceImpl.validateNoneProviderConfiguration(aiServerDto);
                break;
            }
            case CUSTOM: {
                AiTestCaseGenerationServiceImpl.validateCustomProviderConfiguration(aiServerDto);
                break;
            }
            case GOOGLE_VERTEX_AI: {
                AiTestCaseGenerationServiceImpl.validateGoogleVertexAiProviderConfiguration(aiServerDto);
                break;
            }
            default: {
                AiTestCaseGenerationServiceImpl.validateGenericProviderConfiguration(aiServerDto);
            }
        }
    }

    private static void validateNoneProviderConfiguration(AiServerDto aiServerDto) {
        if (AiTestCaseGenerationServiceImpl.isMissingPayloadOrJsonPath(aiServerDto)) {
            AiTestCaseGenerationServiceImpl.handleServerNotConfiguredException();
        }
    }

    private static void handleServerNotConfiguredException() {
        LOGGER.error("The AI server is not properly configured", new Object[0]);
        throw new AiServerNotConfiguredException();
    }

    private static void validateCustomProviderConfiguration(AiServerDto aiServerDto) {
        CustomAiServerConfiguration conf = (CustomAiServerConfiguration)aiServerDto.getConfiguration();
        if (AiTestCaseGenerationServiceImpl.isBlank(conf.getPayloadTemplate()) || AiTestCaseGenerationServiceImpl.isBlank(conf.getGeneratedTextJsonPath())) {
            AiTestCaseGenerationServiceImpl.handleServerNotConfiguredException();
        }
    }

    private static void validateGoogleVertexAiProviderConfiguration(AiServerDto aiServerDto) {
        AiServerConfiguration conf = (AiServerConfiguration)aiServerDto.getConfiguration();
        if (AiTestCaseGenerationServiceImpl.isBlank(aiServerDto.getModelName()) || AiTestCaseGenerationServiceImpl.isBlank(conf.getRegion()) || AiTestCaseGenerationServiceImpl.isBlank(conf.getProjectId())) {
            AiTestCaseGenerationServiceImpl.handleServerNotConfiguredException();
        }
    }

    private static void validateGenericProviderConfiguration(AiServerDto aiServerDto) {
        if (AiTestCaseGenerationServiceImpl.isBlank(aiServerDto.getModelName())) {
            AiTestCaseGenerationServiceImpl.handleServerNotConfiguredException();
        }
    }

    private static boolean isBlank(String str) {
        return StringUtils.isBlank((CharSequence)str);
    }

    public String cleanServerResponse(String originalResponse, String extractedServerResponse) {
        String testCasesPattern;
        Pattern patternTestCases;
        Matcher matcherForTestCases;
        Pattern patternMarkDown = Pattern.compile("```json\\s*\\n([^`]*)```", 32);
        Matcher matcherMarkDown = patternMarkDown.matcher(extractedServerResponse);
        if (matcherMarkDown.find()) {
            extractedServerResponse = matcherMarkDown.group(1);
        }
        if ((matcherForTestCases = (patternTestCases = Pattern.compile(testCasesPattern = "\\{\\s*\"testCases\"\\s*:\\s*\\[.*]\\s*}", 32)).matcher(extractedServerResponse)).find()) {
            return matcherForTestCases.group();
        }
        LOGGER.error("Server response does not contain test cases: {}", new Object[]{originalResponse});
        throw new AiServerResponseInoperableException(originalResponse);
    }

    private List<TestCaseFromAiDto> extractGeneratedTestCases(String response) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            TestCasesResponse wrapper = (TestCasesResponse)objectMapper.readValue(response, TestCasesResponse.class);
            return wrapper.testCases();
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Cannot parse response from server", (Throwable)e);
            throw new RemoteAiServerActionException(e.getMessage(), response);
        }
    }

    @Override
    @IsUltimateLicenseAvailable
    public String generateTestCaseFromRequirementUsingAiUserSideLegacy(long requirementVersionId, String userMessage) {
        Long projectIdLinkedToRequirement = this.requirementVersionDao.findProjectIdByRequirementVersionId(requirementVersionId);
        AiServerDto aiServerDto = this.aiTestCaseGenerationDao.findAiServerDtoByProjectId(projectIdLinkedToRequirement);
        AiTestCaseGenerationServiceImpl.checkIfAiServerIsConfigured(aiServerDto);
        String parsedUserMessage = HTMLCleanupUtils.htmlToLayoutAwareText(userMessage, true);
        return this.doGenerateTestCaseFromRequirementUsingAiLegacy(aiServerDto, parsedUserMessage);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public String testLegacyAiServerConfiguration(long serverId, String requirement) {
        AiServerDto aiServerDto = this.aiTestCaseGenerationDao.findAiServerDtoByAiServerId(serverId);
        return this.doGenerateTestCaseFromRequirementUsingAiLegacy(aiServerDto, requirement);
    }

    private String doGenerateTestCaseFromRequirementUsingAiLegacy(AiServerDto aiServerDto, String requirementDescription) {
        int responseCode;
        TokenAuthCredentials credentials = (TokenAuthCredentials)this.credentialsManager.unsecuredFindAppLevelCredentials(aiServerDto.getId());
        HttpURLConnection connection = AiTestCaseGenerationServiceImpl.prepareConnection(credentials, aiServerDto.getUrl());
        String jsonPayload = HandlebarsTemplateRenderer.renderTemplate(aiServerDto.getPayloadTemplate(), Map.of(REQUIREMENT, JSONObject.escape((String)requirementDescription)));
        StringBuilder response = AiTestCaseGenerationServiceImpl.buildAndSendRequest(jsonPayload, connection);
        try {
            responseCode = connection.getResponseCode();
        }
        catch (IOException e) {
            LOGGER.error("Cannot get response code from server", (Throwable)e);
            throw new RemoteAiServerActionException(e.getMessage(), response.toString());
        }
        if (responseCode == 200 || responseCode == 201) {
            String extractedServerResponse = this.extractServerResponse(aiServerDto.getJsonPath(), response.toString());
            return this.cleanServerResponse(response.toString(), extractedServerResponse);
        }
        LOGGER.error("Expected code 200. Response received is: {}", new Object[]{response});
        throw new RemoteAiServerActionException(String.valueOf(responseCode), response.toString());
    }

    private static boolean isMissingPayloadOrJsonPath(AiServerDto dto) {
        return AiTestCaseGenerationServiceImpl.isBlank(dto.getPayloadTemplate()) || AiTestCaseGenerationServiceImpl.isBlank(dto.getJsonPath());
    }

    public String extractServerResponse(String jsonPath, String originalServerResponse) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            JsonNode responseRoot = objectMapper.readTree(originalServerResponse);
            String transformedJsonPath = this.transformToJsonPointer(jsonPath);
            JsonNode result = responseRoot.at(transformedJsonPath);
            if (!result.isMissingNode()) {
                return result.asText();
            }
            throw new UnextractableAiServerResponseException(originalServerResponse);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Cannot parse the response into a JSON tree structure", (Throwable)e);
            throw new AiServerJsonResponseParsingException(originalServerResponse);
        }
    }

    public String transformToJsonPointer(String jsonPath) {
        String firstChar = "[".equals(jsonPath.substring(0, 1)) ? "" : "/";
        return firstChar + jsonPath.replace(".", "/").replace("[", "/").replace("]", "");
    }

    private static HttpURLConnection prepareConnection(TokenAuthCredentials credentials, String apiUrl) {
        URL url;
        try {
            url = new URI(apiUrl).toURL();
        }
        catch (IllegalArgumentException | MalformedURLException | URISyntaxException e) {
            LOGGER.error("The URl is not correctly formed.", (Throwable)e);
            throw new AiServerMalformedUrlException();
        }
        return AiTestCaseGenerationServiceImpl.getHttpUrlConnection(credentials, url);
    }

    private static HttpURLConnection getHttpUrlConnection(TokenAuthCredentials credentials, URL url) {
        HttpURLConnection connection;
        try {
            connection = (HttpURLConnection)url.openConnection();
        }
        catch (IOException e) {
            LOGGER.error("Cannot open https connection.", (Throwable)e);
            throw new AiServerInitializeRemoteActionException();
        }
        try {
            connection.setRequestMethod("POST");
        }
        catch (IOException e) {
            LOGGER.error("Cannot set the POST method for the request.", (Throwable)e);
            throw new AiServerInitializeRemoteActionException();
        }
        connection.setDoOutput(true);
        if (credentials != null) {
            connection.setRequestProperty("Authorization", "Bearer " + credentials.getToken());
        }
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("Accept-Charset", StandardCharsets.UTF_8.name());
        connection.setRequestProperty("Accept", "application/json");
        return connection;
    }

    private static StringBuilder buildAndSendRequest(String jsonPayload, HttpURLConnection connection) {
        byte[] input = jsonPayload.getBytes(StandardCharsets.UTF_8);
        connection.setRequestProperty("Content-Length", String.valueOf(input.length));
        try {
            Throwable throwable = null;
            Object var4_7 = null;
            try (OutputStream os = connection.getOutputStream();){
                os.write(input, 0, input.length);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.error("Cannot send the request to the remote server", (Throwable)e);
            throw new AiServerInitializeRemoteActionException();
        }
        int responseCode = AiTestCaseGenerationServiceImpl.getResponseCode(connection);
        String responseMessage = AiTestCaseGenerationServiceImpl.getResponseMessage(connection, responseCode);
        StringBuilder response = new StringBuilder();
        if (responseCode >= 400) {
            AiTestCaseGenerationServiceImpl.handleErrorResponseFromServer(connection, response, responseCode, responseMessage);
        } else {
            AiTestCaseGenerationServiceImpl.handleServerResponse(connection, response, responseCode, responseMessage);
        }
        return response;
    }

    private static int getResponseCode(HttpURLConnection connection) {
        int responseCode;
        try {
            responseCode = connection.getResponseCode();
        }
        catch (IOException e) {
            LOGGER.error("Error getting response code from the server", (Throwable)e);
            throw new RemoteAiServerActionException(NO_RESPONSE_FROM_SERVER, null);
        }
        return responseCode;
    }

    private static String getResponseMessage(HttpURLConnection connection, int responseCode) {
        String responseMessage;
        try {
            responseMessage = connection.getResponseMessage();
        }
        catch (IOException e) {
            LOGGER.error("Error getting response message from the server", (Throwable)e);
            throw new RemoteAiServerActionException(NO_RESPONSE_MESSAGE_FROM_SERVER, String.valueOf(responseCode));
        }
        return responseMessage;
    }

    private static void handleErrorResponseFromServer(HttpURLConnection connection, StringBuilder response, int responseCode, String responseMessage) {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedReader errorReader = new BufferedReader(new InputStreamReader(connection.getErrorStream(), StandardCharsets.UTF_8));){
                String errorLine;
                while ((errorLine = errorReader.readLine()) != null) {
                    response.append(errorLine);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.error("Error reading the error response from the server", (Throwable)e);
            throw new RemoteAiServerActionException(responseCode + " " + responseMessage, response.toString());
        }
        LOGGER.error("Error response from the server. HTTP Status Code: {}. Error message: {}. Server response: {}", new Object[]{responseCode, responseMessage, response.toString()});
        switch (responseCode) {
            case 401: {
                throw new AiServerWrongTokenException(responseCode + " " + responseMessage, response.toString());
            }
            case 404: {
                throw new AiServerWrongUrlException(responseCode + " " + responseMessage, response.toString());
            }
            case 400: {
                throw new AiServerBadPayloadTemplateException(responseCode + " " + responseMessage, response.toString());
            }
        }
        throw new RemoteAiServerActionException(responseCode + " " + responseMessage, response.toString());
    }

    private static void handleServerResponse(HttpURLConnection connection, StringBuilder response, int responseCode, String responseMessage) {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.error("Remote server cannot finalize the request", (Throwable)e);
            throw new RemoteAiServerActionException(responseCode + " " + responseMessage, response.toString());
        }
    }

    private record TestCasesResponse(List<TestCaseFromAiDto> testCases) {
    }
}

