/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.requirement;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.plugin.UsedInPlugin;
import org.squashtest.tm.domain.requirement.HighLevelRequirement;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.exception.requirement.CannotConvertIntoHighLevelRequirementException;
import org.squashtest.tm.exception.requirement.CannotConvertIntoStandardRequirementException;
import org.squashtest.tm.service.annotation.CheckBlockingMilestone;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.internal.repository.RequirementDao;
import org.squashtest.tm.service.internal.requirement.RequirementFactory;
import org.squashtest.tm.service.plugin.ConfigurablePluginManager;
import org.squashtest.tm.service.requirement.HighLevelRequirementConversionService;
import org.squashtest.tm.service.requirement.HighLevelRequirementService;

@Component
@Transactional
public class HighLevelRequirementConversionServiceImpl
implements HighLevelRequirementConversionService {
    @PersistenceContext
    private final EntityManager entityManager;
    private final RequirementDao requirementDao;
    private final RequirementFactory requirementFactory;
    private final ConfigurablePluginManager configurablePluginManager;
    private final HighLevelRequirementService highLevelRequirementService;

    public HighLevelRequirementConversionServiceImpl(EntityManager entityManager, RequirementDao requirementDao, RequirementFactory requirementFactory, ConfigurablePluginManager configurablePluginManager, HighLevelRequirementService highLevelRequirementService) {
        this.entityManager = entityManager;
        this.requirementDao = requirementDao;
        this.requirementFactory = requirementFactory;
        this.configurablePluginManager = configurablePluginManager;
        this.highLevelRequirementService = highLevelRequirementService;
    }

    @Override
    @PreAuthorize(value="hasPermission(#requirementId, 'org.squashtest.tm.domain.requirement.Requirement', 'CREATE') or hasRole('ROLE_ADMIN')")
    @CheckBlockingMilestone(entityType=Requirement.class)
    @UsedInPlugin(value="rest-api")
    public void convertIntoHighLevelRequirement(@Id long requirementId) {
        Requirement req = (Requirement)this.requirementDao.findById(requirementId);
        if (req == null) {
            throw new IllegalArgumentException(String.format("Cannot find requirement with ID %d", requirementId));
        }
        if (this.shouldBlockConversion(req)) {
            throw new CannotConvertIntoHighLevelRequirementException("Requirement with id " + requirementId + " is synchronized. It cannot be converted.");
        }
        boolean isChild = this.requirementDao.checkIfRequirementIsChild(requirementId);
        boolean isAlreadyHighLevel = req.isHighLevel();
        if (isChild || isAlreadyHighLevel) {
            throw new CannotConvertIntoHighLevelRequirementException();
        }
        this.requirementFactory.convertIntoHighLevelRequirement(requirementId);
        HighLevelRequirement highLevelRequirement = (HighLevelRequirement)this.entityManager.find(HighLevelRequirement.class, (Object)requirementId);
        this.highLevelRequirementService.addHighLevelRequirementLinkToChildren(requirementId, highLevelRequirement);
    }

    @Override
    @PreAuthorize(value="hasPermission(#requirementId, 'org.squashtest.tm.domain.requirement.Requirement', 'CREATE') or hasRole('ROLE_ADMIN')")
    @CheckBlockingMilestone(entityType=Requirement.class)
    @UsedInPlugin(value="rest-api")
    public void convertIntoStandardRequirement(@Id long requirementId) {
        Requirement req = (Requirement)this.requirementDao.findById(requirementId);
        if (req == null) {
            throw new IllegalArgumentException(String.format("Cannot find requirement with ID %d", requirementId));
        }
        if (this.shouldBlockConversion(req)) {
            throw new CannotConvertIntoStandardRequirementException("Requirement with id " + requirementId + " is synchronized. It cannot be converted.");
        }
        if (!req.isHighLevel()) {
            throw new CannotConvertIntoStandardRequirementException();
        }
        this.removeHighLevelRequirementLinkToLinkedLowLvlReqs(requirementId);
        this.requirementFactory.convertIntoStandardRequirement(requirementId);
    }

    private boolean shouldBlockConversion(Requirement requirement) {
        if (requirement.isSynchronizedInCurrentPerimeter()) {
            String syncKind = requirement.getSyncExtender().getRemoteSynchronisation().getKind();
            return this.configurablePluginManager.isPluginFoundAndActivated(requirement.getProject().getId(), syncKind);
        }
        return false;
    }

    private void removeHighLevelRequirementLinkToLinkedLowLvlReqs(Long requirementId) {
        List<Requirement> linkedLowLvlReqs = this.highLevelRequirementService.findStandardRequirementsByHighLvlReqId(requirementId);
        linkedLowLvlReqs.forEach(linkedLowLvlReq -> linkedLowLvlReq.setHighLevelRequirement(null));
    }
}

