/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.service.internal.repository.CustomProjectDao;

public interface ProjectDao
extends CustomProjectDao,
JpaRepository<Project, Long> {
    public Project findByName(String var1);

    public List<Project> findByIdIn(List<Long> var1);

    public List<Project> findByIdInOrderByName(List<Long> var1);

    @Query
    public Collection<Project> findAllBoundToTemplate(@Param(value="templateId") long var1);

    @Query
    public Collection<Long> findAllIdsBoundToTemplate(@Param(value="templateId") long var1);

    @Query
    @Modifying
    public void unbindAllFromTemplate(@Param(value="templateId") long var1);

    @Query(value="select p.testCaseLibrary.id from Project p where p.name = :name")
    public Long findTestCaseLibraryIdByName(@Param(value="name") String var1);

    @Query(value="select p.requirementLibrary.id from Project p where p.name = :name")
    public Long findRequirementLibraryIdByName(@Param(value="name") String var1);

    @Query(value="SELECT p.*\nFROM PROJECT p\nINNER JOIN TEST_PLAN tp ON tp.CL_ID = p.CL_ID\nINNER JOIN TEST_PLAN_ITEM tpi ON tpi.TEST_PLAN_ID = tp.TEST_PLAN_ID\nINNER JOIN FAILURE_DETAIL fd ON fd.TEST_PLAN_ITEM_ID = tpi.TEST_PLAN_ITEM_ID\nWHERE fd.FAILURE_DETAIL_ID = :failureDetailId\n", nativeQuery=true)
    public Optional<Project> findProjectByFailureDetailId(@Param(value="failureDetailId") Long var1);
}

