/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.execution;

import java.util.Date;
import java.util.List;
import java.util.Set;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.campaign.SprintStatus;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.execution.ExecutionStatusReport;
import org.squashtest.tm.domain.execution.ExecutionStep;
import org.squashtest.tm.domain.testautomation.AutomatedExecutionExtender;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.exception.campaign.SprintClosedException;
import org.squashtest.tm.service.annotation.CheckBlockingMilestone;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.campaign.CustomTestSuiteModificationService;
import org.squashtest.tm.service.execution.ExecutionProcessingService;
import org.squashtest.tm.service.internal.repository.ExecutionDao;
import org.squashtest.tm.service.internal.repository.ExecutionStepDao;
import org.squashtest.tm.service.internal.repository.UserDao;
import org.squashtest.tm.service.internal.repository.display.SprintDisplayDao;
import org.squashtest.tm.service.security.UserContextService;

@Service(value="squashtest.tm.service.ExecutionProcessingService")
@Transactional
public class ExecutionProcessingServiceImpl
implements ExecutionProcessingService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutionProcessingServiceImpl.class);
    private final UserContextService userContextService;
    private final ExecutionDao executionDao;
    private final ExecutionStepDao executionStepDao;
    private final CustomTestSuiteModificationService customTestSuiteModificationService;
    private final UserDao userDao;
    private final SprintDisplayDao sprintDisplayDao;

    public ExecutionProcessingServiceImpl(UserContextService userContextService, ExecutionDao executionDao, ExecutionStepDao executionStepDao, CustomTestSuiteModificationService customTestSuiteModificationService, UserDao userDao, SprintDisplayDao sprintDisplayDao) {
        this.userContextService = userContextService;
        this.executionDao = executionDao;
        this.executionStepDao = executionStepDao;
        this.customTestSuiteModificationService = customTestSuiteModificationService;
        this.userDao = userDao;
        this.sprintDisplayDao = sprintDisplayDao;
    }

    @Override
    @Transactional(readOnly=true)
    public ExecutionStep findStepAt(long executionId, int executionStepIndex) {
        Execution execution = this.executionDao.findAndInit(executionId);
        return (ExecutionStep)execution.getSteps().get(executionStepIndex);
    }

    @Override
    @PreAuthorize(value="hasPermission(#executionStepId, 'org.squashtest.tm.domain.execution.ExecutionStep', 'EXECUTE')  or hasRole('ROLE_ADMIN')")
    @CheckBlockingMilestone(entityType=ExecutionStep.class)
    public void changeExecutionStepStatus(@Id Long executionStepId, ExecutionStatus status) {
        ExecutionStep step = (ExecutionStep)this.executionStepDao.findById(executionStepId);
        ExecutionStatus formerStatus = step.getExecutionStatus();
        Set disabledStatusList = step.getCampaignLibrary().getDisabledStatuses();
        if (disabledStatusList.contains(status)) {
            throw new RuntimeException("Unable to set this status: " + status.getCanonicalStatus().name() + ". It's a optional status, check your project settings");
        }
        step.setExecutionStatus(status);
        this.forwardAndUpdateStatus(step, formerStatus);
    }

    @Override
    @CheckBlockingMilestone(entityType=ExecutionStep.class)
    public void setExecutionStepComment(@Id Long executionStepId, String comment) {
        ExecutionStep step = (ExecutionStep)this.executionStepDao.findById(executionStepId);
        this.checkParentSprintStatus(step.getExecution().getId());
        step.setComment(comment);
    }

    @Override
    public ExecutionStatusReport getExecutionStatusReport(Long executionId) {
        return this.executionDao.getStatusReport(executionId);
    }

    private void forwardAndUpdateStatus(ExecutionStep executionStep, ExecutionStatus formerStepStatus) {
        this.checkParentSprintStatus(executionStep.getExecution().getId());
        this.updateStepExecutionData(executionStep);
        Execution execution = this.executionStepDao.findParentExecution(executionStep.getId());
        ExecutionStatus formerExecutionStatus = execution.getExecutionStatus();
        ExecutionStatus newStepStatus = executionStep.getExecutionStatus();
        ExecutionStatus newExecutionStatus = newStepStatus.deduceNewStatus(formerExecutionStatus, formerStepStatus);
        if (newExecutionStatus == null) {
            ExecutionStatusReport report = this.executionDao.getStatusReport(execution.getId());
            newExecutionStatus = ExecutionStatus.computeNewStatus((ExecutionStatusReport)report);
        }
        execution.setExecutionStatus(newExecutionStatus);
        this.updateExecutionMetadata(execution);
        TestPlanItem testPlanItem = execution.getTestPlanItem();
        if (testPlanItem != null) {
            this.customTestSuiteModificationService.updateExecutionStatus(testPlanItem.getTestSuites());
        }
    }

    @Override
    public void updateStepExecutionData(ExecutionStep executionStep) {
        if (executionStep.getExecutionStatus().compareTo((Enum)ExecutionStatus.READY) == 0) {
            executionStep.setLastExecutedBy(null);
            executionStep.setLastExecutedOn(null);
        } else {
            executionStep.setLastExecutedBy(this.userContextService.getUsername());
            executionStep.setLastExecutedOn(new Date());
        }
    }

    private void updateExecutionMetadata(Execution execution) {
        LOGGER.debug("update the executed by/on for given execution and it's test plan.", new Object[0]);
        ExecutionStep mostRecentStep = this.getMostRecentExecutionStep(execution);
        if (mostRecentStep != null) {
            execution.setLastExecutedBy(mostRecentStep.getLastExecutedBy());
            execution.setLastExecutedOn(mostRecentStep.getLastExecutedOn());
        } else {
            execution.setLastExecutedBy(null);
            execution.setLastExecutedOn(null);
        }
        TestPlanItem testPlanItem = execution.getTestPlanItem();
        Execution latestExecution = testPlanItem.getLatestExecution();
        if (latestExecution != null && latestExecution.getLastExecutedBy() != null) {
            User assignee = this.userDao.findUserByLogin(latestExecution.getLastExecutedBy());
            testPlanItem.updateLastExecutionAndAssignee(latestExecution.getLastExecutedOn(), assignee);
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#extender, 'EXECUTE') or hasRole('ROLE_TA_API_CLIENT') or hasRole('ROLE_ADMIN')")
    public void updateExecutionMetadata(AutomatedExecutionExtender extender) {
        Execution execution = extender.getExecution();
        execution.setLastExecutedOn(new Date());
        execution.setLastExecutedBy(this.userContextService.getUsername());
        User assignee = this.userDao.findUserByLogin(execution.getLastExecutedBy());
        execution.getTestPlanItem().updateLastExecutionAndAssignee(execution.getLastExecutedOn(), assignee);
    }

    private ExecutionStep getMostRecentExecutionStep(Execution givenExecution) {
        ExecutionStep mostRecentExecutionStep = (ExecutionStep)givenExecution.getSteps().get(0);
        List stepList = givenExecution.getSteps();
        for (ExecutionStep executionStep : stepList) {
            if (executionStep.getExecutionStatus().compareTo((Enum)ExecutionStatus.READY) == 0) continue;
            if (mostRecentExecutionStep.getLastExecutedOn() == null) {
                mostRecentExecutionStep = executionStep;
                continue;
            }
            if (executionStep.getLastExecutedOn() == null || mostRecentExecutionStep.getLastExecutedOn().compareTo(executionStep.getLastExecutedOn()) >= 0) continue;
            mostRecentExecutionStep = executionStep;
        }
        return mostRecentExecutionStep;
    }

    @Override
    public void setExecutionStatus(Long executionId, ExecutionStatusReport report) {
        this.checkParentSprintStatus(executionId);
        Execution execution = this.executionDao.findAndInit(executionId);
        ExecutionStatus newStatus = ExecutionStatus.computeNewStatus((ExecutionStatusReport)report);
        execution.setExecutionStatus(newStatus);
    }

    private void checkParentSprintStatus(Long executionId) {
        SprintStatus sprintStatus = this.sprintDisplayDao.getSprintStatusByExecutionId(executionId);
        if (SprintStatus.CLOSED.equals((Object)sprintStatus)) {
            throw new SprintClosedException();
        }
    }
}

