/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.campaign;

import java.util.List;
import org.jooq.DSLContext;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.core.foundation.exception.ActionException;
import org.squashtest.tm.domain.campaign.Sprint;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.exception.execution.SprintOverallTestPlanHasDeletedTestCaseException;
import org.squashtest.tm.service.campaign.ExecutionCreationService;
import org.squashtest.tm.service.internal.campaign.AbstractTestPlanExecutionProcessingService;
import org.squashtest.tm.service.internal.campaign.CampaignNodeDeletionHandler;
import org.squashtest.tm.service.internal.display.campaign.ReadUnassignedTestPlanHelper;
import org.squashtest.tm.service.internal.display.dto.execution.TestPlanResume;
import org.squashtest.tm.service.internal.display.grid.GridFilterValue;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.internal.display.grid.campaign.SprintOverallExecPlanGrid;
import org.squashtest.tm.service.internal.repository.SprintDao;
import org.squashtest.tm.service.internal.repository.TestPlanItemDao;
import org.squashtest.tm.service.security.PermissionEvaluationService;

@Service
@Transactional
public class SprintExecutionProcessingServiceImpl
extends AbstractTestPlanExecutionProcessingService<Sprint, TestPlanResume.SprintTestPlanResume> {
    private static final String CAN_EXECUTE_BY_SPRINT_ID = "hasPermission(#sprintId, 'org.squashtest.tm.domain.campaign.Sprint', 'EXECUTE') or hasRole('ROLE_ADMIN')";
    private final ReadUnassignedTestPlanHelper readUnassignedTestPlanHelper;
    private final SprintDao sprintDao;

    SprintExecutionProcessingServiceImpl(CampaignNodeDeletionHandler campaignDeletionHandler, PermissionEvaluationService permissionEvaluationService, TestPlanItemDao testPlanItemDao, DSLContext dslContext, ExecutionCreationService executionCreationService, ReadUnassignedTestPlanHelper readUnassignedTestPlanHelper, SprintDao sprintDao) {
        super(campaignDeletionHandler, permissionEvaluationService, testPlanItemDao, dslContext, executionCreationService);
        this.readUnassignedTestPlanHelper = readUnassignedTestPlanHelper;
        this.sprintDao = sprintDao;
    }

    @Override
    @PreAuthorize(value="hasPermission(#sprintId, 'org.squashtest.tm.domain.campaign.Sprint', 'EXECUTE') or hasRole('ROLE_ADMIN')")
    public TestPlanResume.SprintTestPlanResume startResume(long sprintId) {
        return (TestPlanResume.SprintTestPlanResume)this.commonStartResume(sprintId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#sprintId, 'org.squashtest.tm.domain.campaign.Sprint', 'EXECUTE') or hasRole('ROLE_ADMIN')")
    public TestPlanResume.SprintTestPlanResume relaunch(long sprintId) {
        return (TestPlanResume.SprintTestPlanResume)super.relaunch(sprintId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#sprintId, 'org.squashtest.tm.domain.campaign.Sprint', 'EXECUTE') or hasRole('ROLE_ADMIN')")
    public TestPlanResume relaunchFilteredTestPlan(long sprintId, List<GridFilterValue> filters) {
        return super.relaunchFilteredTestPlan(sprintId, filters);
    }

    @Override
    @PreAuthorize(value="hasPermission(#sprintId, 'org.squashtest.tm.domain.campaign.Sprint', 'EXECUTE') or hasRole('ROLE_ADMIN')")
    public TestPlanResume.SprintTestPlanResume startResumeNextExecution(long sprintId, long testPlanItemId) {
        return (TestPlanResume.SprintTestPlanResume)super.startResumeNextExecution(sprintId, testPlanItemId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#sprintId, 'org.squashtest.tm.domain.campaign.Sprint', 'EXECUTE') or hasRole('ROLE_ADMIN')")
    public void deleteAllExecutions(long sprintId) {
        super.deleteAllExecutions(sprintId);
    }

    @Override
    Sprint createTransientTestPlanOwnerWithFilteredTestPlan(long sprintId, List<TestPlanItem> filteredTestPlan) {
        Sprint sprint = this.getTestPlanOwner(sprintId);
        return sprint.createCopyWithFilteredTestPlan(filteredTestPlan);
    }

    @Override
    public List<TestPlanItem> getFilteredTestPlan(long sprintId, List<GridFilterValue> filters) {
        String userToRestrictTo = this.readUnassignedTestPlanHelper.getUserToRestrictTo(sprintId, Sprint.class.getName());
        SprintOverallExecPlanGrid testPlanGrid = new SprintOverallExecPlanGrid(sprintId, userToRestrictTo);
        GridRequest gridRequest = this.prepareNonPaginatedGridRequest(filters);
        GridResponse gridResponse = testPlanGrid.getRows(gridRequest, this.dslContext);
        List<Long> itemIds = this.extractItemIdsFromGridResponse(gridResponse);
        return this.testPlanItemDao.findAllById(itemIds);
    }

    @Override
    public ActionException getTestPlanHasDeletedTestCaseException() {
        return new SprintOverallTestPlanHasDeletedTestCaseException();
    }

    @Override
    protected Sprint getTestPlanOwner(long sprintId) {
        return this.sprintDao.loadForExecutionResume(sprintId);
    }

    @Override
    protected TestPlanResume createNewTestPlanResume(long testPlanOwnerId, Execution execution, boolean hasNextTestCase, List<Long> partialTestPlanItemIds) {
        return new TestPlanResume.SprintTestPlanResume(testPlanOwnerId, execution, hasNextTestCase, partialTestPlanItemIds);
    }

    @Override
    protected TestPlanResume.SprintTestPlanResume createNewTestPlanResume(long testPlanOwnerId, Execution execution, boolean hasNextTestCase) {
        return new TestPlanResume.SprintTestPlanResume(testPlanOwnerId, execution, hasNextTestCase);
    }

    @Override
    public boolean hasDeletedTestCaseInTestPlan(long testPlanOwnerId) {
        return this.sprintDao.hasDeletedTestCaseInTestPlan(testPlanOwnerId);
    }
}

