/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport.instruction.container;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.service.importer.ImportMode;
import org.squashtest.tm.service.importer.Target;
import org.squashtest.tm.service.internal.batchimport.Facility;
import org.squashtest.tm.service.internal.batchimport.instruction.Instruction;

public abstract class InstructionContainer<T extends Instruction<? extends Target>> {
    private final List<T> createInstructions;
    private final List<T> updateInstructions;
    private final List<T> deleteInstructions;

    protected InstructionContainer(List<T> instructions) {
        Map instructionsByMode = instructions.stream().collect(Collectors.groupingBy(Instruction::getMode, Collectors.toList()));
        this.createInstructions = instructionsByMode.getOrDefault((Object)ImportMode.CREATE, Collections.emptyList());
        this.updateInstructions = instructionsByMode.getOrDefault((Object)ImportMode.UPDATE, Collections.emptyList());
        this.deleteInstructions = instructionsByMode.getOrDefault((Object)ImportMode.DELETE, Collections.emptyList());
    }

    public List<T> getCreateInstructions() {
        return this.createInstructions;
    }

    public List<T> getUpdateInstructions() {
        return this.updateInstructions;
    }

    public List<T> getDeleteInstructions() {
        return this.deleteInstructions;
    }

    public List<T> executeInstructions(Facility facility, Project project) {
        if (!this.createInstructions.isEmpty()) {
            this.executeCreate(facility, project);
        }
        if (!this.updateInstructions.isEmpty()) {
            this.executeUpdate(facility, project);
        }
        if (!this.deleteInstructions.isEmpty()) {
            this.executeDelete(facility);
        }
        return this.getAllInstructions();
    }

    public List<T> getAllInstructions() {
        ArrayList<T> instructions = new ArrayList<T>();
        instructions.addAll(this.createInstructions);
        instructions.addAll(this.updateInstructions);
        instructions.addAll(this.deleteInstructions);
        return instructions;
    }

    protected void executeUpdate(Facility facility, Project project) {
        this.executeInstructions(this.getUpdateInstructions(), facility);
    }

    protected void executeDelete(Facility facility) {
        this.executeInstructions(this.getDeleteInstructions(), facility);
    }

    protected void executeCreate(Facility facility, Project project) {
        this.executeInstructions(this.getCreateInstructions(), facility);
    }

    private void executeInstructions(List<T> instructions, Facility facility) {
        instructions.forEach(instruction -> instruction.execute(facility));
    }
}

