/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testautomation.resultimport;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.squashtest.tm.service.attachment.UploadedData;
import org.squashtest.tm.service.internal.dto.resultimport.AttachmentDto;

public interface ResultImportHelper {
    public static void deduplicateAttachmentNames(List<AttachmentDto> attachments) {
        List<String> attachmentNames = attachments.stream().map(AttachmentDto::getName).toList();
        List uniqueAttachmentNames = attachmentNames.stream().distinct().toList();
        HashMap<String, Integer> uniqueNameCounts = new HashMap<String, Integer>();
        for (String name : uniqueAttachmentNames) {
            uniqueNameCounts.put(name, 1);
        }
        if (attachmentNames.size() != uniqueAttachmentNames.size()) {
            int i = 0;
            while (i < attachments.size()) {
                AttachmentDto attachment = attachments.get(i);
                String filename = attachment.getName();
                if (attachmentNames.indexOf(filename) != i) {
                    String baseName = FilenameUtils.getBaseName((String)filename);
                    String extension = FilenameUtils.getExtension((String)filename);
                    attachment.setName(baseName + "(" + String.valueOf(uniqueNameCounts.get(filename)) + ")." + extension);
                    uniqueNameCounts.merge(filename, 1, Integer::sum);
                }
                ++i;
            }
        }
    }

    public static UploadedData decodeBase64AttachmentContent(AttachmentDto attachmentDto) {
        ByteArrayInputStream stream = new ByteArrayInputStream(Base64.getDecoder().decode(attachmentDto.getContent().getBytes(StandardCharsets.UTF_8)));
        String name = attachmentDto.getName();
        long sizeInBytes = attachmentDto.getContent().length();
        return new UploadedData(stream, name, sizeInBytes);
    }
}

