/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.grid.filters;

import java.sql.Timestamp;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import org.jooq.Condition;
import org.jooq.Field;
import org.squashtest.tm.service.internal.display.grid.GridFilterValue;
import org.squashtest.tm.service.internal.display.grid.filters.GridFilterConditionBuilder;

public class BetweenConditionBuilder<T>
implements GridFilterConditionBuilder {
    private final Field<T> field;
    private final GridFilterValue gridFilterValue;

    BetweenConditionBuilder(Field<T> field, GridFilterValue gridFilterValue) {
        Objects.requireNonNull(field);
        Objects.requireNonNull(gridFilterValue);
        List<String> values = gridFilterValue.getValues();
        if (values.isEmpty() || Objects.isNull(values.get(0))) {
            throw new IllegalArgumentException("At least one non null value is required to build a between condition");
        }
        this.field = field;
        this.gridFilterValue = gridFilterValue;
    }

    @Override
    public Condition build() {
        List<String> values = this.gridFilterValue.getValues();
        if (values.size() < 2) {
            throw new IllegalArgumentException(" 2 values are needed for a BETWEEN operation");
        }
        if (this.field.getDataType().getType().equals(Timestamp.class)) {
            return this.buildTimestamp(values);
        }
        T value1 = GridFilterConditionBuilder.getGridFilterValueConvert(this.field, this.gridFilterValue.getValues().get(0));
        T value2 = GridFilterConditionBuilder.getGridFilterValueConvert(this.field, this.gridFilterValue.getValues().get(1));
        return this.field.between(value1, value2);
    }

    private Condition buildTimestamp(List<String> values) {
        LocalDate date1 = LocalDate.parse(values.get(0));
        LocalDate date2 = LocalDate.parse(values.get(1));
        date2 = date2.plusDays(1L);
        return this.field.between((Object)date1, (Object)date2);
    }
}

