/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport.instruction.targets;

import org.squashtest.tm.core.foundation.lang.PathUtils;
import org.squashtest.tm.service.importer.EntityType;
import org.squashtest.tm.service.importer.Target;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.HighLevelRequirementTarget;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.RequirementTarget;

public class LinkedLowLevelRequirementTarget
implements Target {
    private String highLevelReqPath;
    private HighLevelRequirementTarget highLevelRequirementTarget;
    private String standardReqPath;
    private RequirementTarget standardRequirementTarget;

    public String getHighLevelReqPath() {
        return this.highLevelReqPath;
    }

    public void setHighLevelReqPath(String highLevelReqPath) {
        String sanitizedPath = highLevelReqPath.trim();
        this.highLevelReqPath = PathUtils.cleanMultipleSlashes((String)sanitizedPath);
    }

    public String getStandardReqPath() {
        return this.standardReqPath;
    }

    public void setStandardReqPath(String standardReqPath) {
        String sanitizedPath = standardReqPath.trim();
        this.standardReqPath = PathUtils.cleanMultipleSlashes((String)sanitizedPath);
    }

    public boolean isHighLevelReqPathWellFormed() {
        return PathUtils.isPathWellFormed((String)this.highLevelReqPath);
    }

    public boolean isStandardReqPathWellFormed() {
        return PathUtils.isPathWellFormed((String)this.standardReqPath);
    }

    @Override
    public EntityType getType() {
        return EntityType.LINKED_LOW_LEVEL_REQ;
    }

    @Override
    public boolean isWellFormed() {
        return this.isHighLevelReqPathWellFormed() && this.isStandardReqPathWellFormed();
    }

    @Override
    public String getSourcePath() {
        return this.standardReqPath;
    }

    @Override
    public String getLinkPath() {
        return this.highLevelReqPath;
    }

    public HighLevelRequirementTarget getHighLevelRequirementTarget() {
        return this.highLevelRequirementTarget;
    }

    public void setHighLevelRequirementTarget(HighLevelRequirementTarget highLevelRequirementTarget) {
        this.highLevelRequirementTarget = highLevelRequirementTarget;
    }

    public RequirementTarget getStandardRequirementTarget() {
        return this.standardRequirementTarget;
    }

    public void setStandardRequirementTarget(RequirementTarget standardRequirementTarget) {
        this.standardRequirementTarget = standardRequirementTarget;
    }
}

