/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.testautomation.resultpublisher;

import jakarta.inject.Inject;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.testautomation.execution.dto.TestExecutionStatus;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.security.UserContextHolder;
import org.squashtest.tm.service.campaign.CustomTestSuiteModificationService;
import org.squashtest.tm.service.internal.repository.TestPlanItemDao;
import org.squashtest.tm.service.internal.repository.UserDao;
import org.squashtest.tm.service.testautomation.model.AutomatedExecutionState;

@Service
@Transactional
public class RestITPIManagerService {
    @Inject
    private TestPlanItemDao testPlanItemDao;
    @Inject
    private UserDao userDao;
    @Inject
    private CustomTestSuiteModificationService customTestSuiteModificationService;

    @PreAuthorize(value="hasRole('ROLE_TA_API_CLIENT') or hasRole('ROLE_ADMIN') or hasPermission(#id, 'org.squashtest.tm.domain.campaign.testplan.TestPlanItem' ,'EXECUTE')")
    public void forceExecutionStatus(long id, @NotNull AutomatedExecutionState stateChange) {
        AutomatedExecutionState automatedExecutionState = stateChange;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$2$7531eba5((Object)automatedExecutionState);
        TestPlanItem item = this.getById(id);
        String login = UserContextHolder.getUsername();
        User user = this.userDao.findUserByLogin(login);
        TestExecutionStatus testExecutionStatus = stateChange.getTfTestExecutionStatus().tfTestExecutionStatusToTmTestExecutionStatus();
        item.applyFastPass(ExecutionStatus.valueOf((String)testExecutionStatus.getStatus().name()), user);
        ArrayList<TestSuite> testSuitesToUpdate = new ArrayList<TestSuite>(item.getTestSuites());
        this.customTestSuiteModificationService.updateExecutionStatus(testSuitesToUpdate);
    }

    public TestPlanItem getById(long id) {
        return this.testPlanItemDao.findByIdWithTestCase(id);
    }
}

