/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.testautomation.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.squashtest.tm.service.testautomation.model.AutomatedSuiteCreationSpecification;

public class AutomatedSuitePreview {
    private boolean manualServerSelection = false;
    private AutomatedSuiteCreationSpecification specification = null;
    private Collection<TestAutomationProjectPreview> projects = new ArrayList<TestAutomationProjectPreview>();
    private Collection<SquashAutomProjectPreview> squashAutomProjects = new ArrayList<SquashAutomProjectPreview>();

    public boolean isManualServerSelection() {
        return this.manualServerSelection;
    }

    public void setManualServerSelection(boolean manualServerSelection) {
        this.manualServerSelection = manualServerSelection;
    }

    public AutomatedSuiteCreationSpecification getSpecification() {
        return this.specification;
    }

    public void setSpecification(AutomatedSuiteCreationSpecification specification) {
        this.specification = specification;
    }

    public Collection<TestAutomationProjectPreview> getProjects() {
        return this.projects;
    }

    public void setProjects(Collection<TestAutomationProjectPreview> projects) {
        this.projects = projects;
    }

    public Collection<SquashAutomProjectPreview> getSquashAutomProjects() {
        return this.squashAutomProjects;
    }

    public void setSquashAutomProjects(Collection<SquashAutomProjectPreview> squashAutomProjects) {
        this.squashAutomProjects = squashAutomProjects;
    }

    public static final class SquashAutomProjectPreview {
        private long projectId;
        private String projectName;
        private long serverId;
        private String serverName;
        private List<TestCasePreviewInfo> testCases;

        public SquashAutomProjectPreview(long projectId, String projectName, long serverId, String serverName) {
            this.projectId = projectId;
            this.projectName = projectName;
            this.serverId = serverId;
            this.serverName = serverName;
            this.testCases = new ArrayList<TestCasePreviewInfo>();
        }

        public long getServerId() {
            return this.serverId;
        }

        public void setServerId(long serverId) {
            this.serverId = serverId;
        }

        public String getServerName() {
            return this.serverName;
        }

        public void setServerName(String serverName) {
            this.serverName = serverName;
        }

        public long getProjectId() {
            return this.projectId;
        }

        public void setProjectId(long projectId) {
            this.projectId = projectId;
        }

        public String getProjectName() {
            return this.projectName;
        }

        public void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        public List<TestCasePreviewInfo> getTestCases() {
            return this.testCases;
        }

        public void setTestCases(List<TestCasePreviewInfo> testCases) {
            this.testCases = testCases;
        }
    }

    public static final class TestAutomationProjectPreview {
        private long projectId;
        private String label;
        private String server;
        private Collection<String> nodes;
        private long testCount = 0L;
        private boolean orderGuaranteed = true;

        public TestAutomationProjectPreview() {
        }

        public TestAutomationProjectPreview(long projectId, String label, String server, Collection<String> nodes, long testCount) {
            this.projectId = projectId;
            this.label = label;
            this.server = server;
            this.nodes = nodes;
            this.testCount = testCount;
        }

        public TestAutomationProjectPreview(long projectId, String label, String server, String nodesAsCsv, long testCount) {
            this.projectId = projectId;
            this.label = label;
            this.server = server;
            this.setNodes(nodesAsCsv);
            this.testCount = testCount;
        }

        public long getProjectId() {
            return this.projectId;
        }

        public void setProjectId(long projectId) {
            this.projectId = projectId;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public Collection<String> getNodes() {
            return this.nodes;
        }

        public void setNodes(Collection<String> nodes) {
            this.nodes = nodes;
        }

        public String getServer() {
            return this.server;
        }

        public void setServer(String server) {
            this.server = server;
        }

        public boolean isOrderGuaranteed() {
            return this.orderGuaranteed;
        }

        public void setOrderGuaranteed(boolean orderGuaranteed) {
            this.orderGuaranteed = orderGuaranteed;
        }

        public long getTestCount() {
            return this.testCount;
        }

        public void setTestCount(long testCount) {
            this.testCount = testCount;
        }

        private void setNodes(String asCsv) {
            String[] nodesArray = asCsv.trim().replaceAll("\\s*;\\s*", ";").split(";");
            this.nodes = Arrays.asList(nodesArray);
        }
    }

    public static final class TestCasePreviewInfo {
        private String reference;
        private String name;
        private String dataset;
        private String importance;

        public TestCasePreviewInfo(String reference, String name, String dataset, String importance) {
            this.reference = reference;
            this.name = name;
            this.dataset = dataset;
            this.importance = importance;
        }

        public String getReference() {
            return this.reference;
        }

        public void setReference(String reference) {
            this.reference = reference;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDataset() {
            return this.dataset;
        }

        public void setDataset(String dataset) {
            this.dataset = dataset;
        }

        public String getImportance() {
            return this.importance;
        }

        public void setImportance(String importance) {
            this.importance = importance;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestCasePreviewInfo that = (TestCasePreviewInfo)o;
            return this.reference.equals(that.reference) && this.name.equals(that.name);
        }

        public int hashCode() {
            return Objects.hash(this.reference, this.name);
        }
    }
}

