/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testcase.bdd.robot.keywords;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.squashtest.tm.domain.bdd.ActionWordParameterValue;
import org.squashtest.tm.domain.testcase.KeywordTestCase;
import org.squashtest.tm.domain.testcase.KeywordTestStep;
import org.squashtest.tm.service.internal.testcase.bdd.TextGridFormatter;
import org.squashtest.tm.service.internal.testcase.bdd.robot.RobotSyntaxHelpers;
import org.squashtest.tm.service.internal.testcase.bdd.robot.SectionBuilderHelpers;

public final class RetrieveDatasetKeywordBuilder {
    private static final List<String> RETRIEVE_DATASET_DOCUMENTATION_LINES = Arrays.asList("Retrieves Squash TM's datasets and stores them in a dictionary.", "", "For instance, datasets containing 3 parameters \"city\", \"country\" and \"currency\"", "have been defined in Squash TM.", "", "First, this keyword retrieves parameter values from Squash TM", "and stores them into variables, using the keyword 'Get Test Param':", "${city} =    Get Test Param    DS_city", "", "Then, this keyword stores the parameters into the &{dataset} dictionary", "with each parameter name as key, and each parameter value as value:", "&{dataset} =    Create Dictionary    city=${city}    country=${country}    currency=${currency}");

    private RetrieveDatasetKeywordBuilder() {
    }

    public static String buildRetrieveDataset(KeywordTestCase keywordTestCase) {
        boolean isDatasetEnabled = SectionBuilderHelpers.isTestCaseUsingDatasets(keywordTestCase);
        if (isDatasetEnabled) {
            SectionBuilderHelpers.MultiLineStringBuilder stringBuilder = new SectionBuilderHelpers.MultiLineStringBuilder();
            List<String> parameterNames = RetrieveDatasetKeywordBuilder.extractDistinctDatasetParameterNames(keywordTestCase);
            return stringBuilder.appendNewLine().appendLine("Retrieve Dataset").append(SectionBuilderHelpers.formatDocumentationSettingLines(RETRIEVE_DATASET_DOCUMENTATION_LINES)).appendNewLine().append(RetrieveDatasetKeywordBuilder.formatTestCaseParameters(parameterNames)).appendNewLine().append(RetrieveDatasetKeywordBuilder.formatDatasetDictionaryCreation(parameterNames)).appendNewLine().appendLine("    RETURN    " + RobotSyntaxHelpers.dictionaryVariable("dataset")).toString();
        }
        return "";
    }

    private static String formatDatasetDictionaryCreation(List<String> parameterNames) {
        int numLines = (int)Math.ceil((double)parameterNames.size() / 4.0);
        TextGridFormatter textGridFormatter = new TextGridFormatter();
        int lineIndex = 0;
        while (lineIndex < numLines) {
            ArrayList<String> row = new ArrayList<String>();
            if (lineIndex == 0) {
                row.add(RobotSyntaxHelpers.assignment(RobotSyntaxHelpers.dictionaryVariable("dataset")));
                row.add("Create Dictionary");
            } else {
                row.add("...");
                row.add("");
            }
            int startIndex = lineIndex * 4;
            int endIndex = Math.min(parameterNames.size(), startIndex + 4);
            List<String> paramsForThisRow = parameterNames.subList(startIndex, endIndex);
            List<String> dictionaryEntries = paramsForThisRow.stream().map(paramName -> String.format("%s=%s", paramName, RobotSyntaxHelpers.scalarVariable(paramName))).toList();
            row.addAll(dictionaryEntries);
            textGridFormatter.addRow(row);
            ++lineIndex;
        }
        return textGridFormatter.format(TextGridFormatter.withRowPrefix("    "));
    }

    private static List<String> extractDistinctDatasetParameterNames(KeywordTestCase keywordTestCase) {
        return keywordTestCase.getSteps().stream().flatMap(step -> ((KeywordTestStep)step).getParamValues().stream().sorted(Comparator.comparingDouble(ActionWordParameterValue::getId))).filter(RetrieveDatasetKeywordBuilder.distinctByKey(ActionWordParameterValue::getValue)).filter(ActionWordParameterValue::isLinkedToTestCaseParam).map(paramValue -> {
            String value = paramValue.getValue();
            return value.substring(1, value.length() - 1);
        }).toList();
    }

    private static String formatTestCaseParameters(List<String> parameterNames) {
        TextGridFormatter textGridFormatter = new TextGridFormatter();
        textGridFormatter.addRows(RetrieveDatasetKeywordBuilder.buildTestCaseParametersLines(parameterNames));
        return textGridFormatter.format(TextGridFormatter.withRowPrefix("    "));
    }

    private static List<List<String>> buildTestCaseParametersLines(List<String> parameterNames) {
        return parameterNames.stream().map(paramName -> List.of(RobotSyntaxHelpers.assignment(RobotSyntaxHelpers.scalarVariable(paramName)), "Get Test Param", String.format("DS_%s", paramName))).toList();
    }

    private static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        HashSet seen = new HashSet();
        return t -> seen.add(keyExtractor.apply(t));
    }
}

