/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testcase.bdd;

import java.util.ArrayList;
import java.util.List;
import org.squashtest.tm.domain.bdd.ActionWordFragment;
import org.squashtest.tm.domain.bdd.ActionWordParameter;
import org.squashtest.tm.domain.bdd.ActionWordParameterValue;
import org.squashtest.tm.domain.bdd.ActionWordText;
import org.squashtest.tm.domain.bdd.util.ActionWordUtil;
import org.squashtest.tm.exception.actionword.InvalidActionWordInputException;
import org.squashtest.tm.exception.actionword.InvalidActionWordParameterNameException;
import org.squashtest.tm.service.internal.testcase.bdd.ActionWordTokenizer;
import org.squashtest.tm.service.internal.testcase.bdd.ContextualizedActionWordException;

public abstract class AbstractActionWordParser {
    private static final String ACTION_WORD_PARAM_NAME_PREFIX = "param";
    private final List<ActionWordParameterValue> parameterValues = new ArrayList<ActionWordParameterValue>();
    protected final List<String> paramNames = new ArrayList<String>();
    private int generatedParamIndex = 0;
    protected final List<ActionWordFragment> fragments = new ArrayList<ActionWordFragment>();

    public List<ActionWordParameterValue> getParameterValues() {
        return this.parameterValues;
    }

    protected List<ActionWordTokenizer.AWToken> checkInputAndParseTokens(String trimmedInput, boolean allowsNamedParameters) {
        this.resetState();
        this.checkIfInputNullOrEmpty(trimmedInput);
        this.checkIfActionWordContainsIllegalEscapeSequences(trimmedInput);
        this.checkIfInputExceed255Char(trimmedInput);
        ActionWordTokenizer tokenizer = new ActionWordTokenizer(trimmedInput, allowsNamedParameters);
        List<ActionWordTokenizer.AWToken> tokens = tokenizer.tokenize();
        this.checkIfActionWordHasText(tokens);
        return tokens;
    }

    private void resetState() {
        this.parameterValues.clear();
        this.paramNames.clear();
        this.fragments.clear();
        this.generatedParamIndex = 0;
    }

    protected void addTextFragment(ActionWordTokenizer.AWToken token) {
        ActionWordText text = new ActionWordText(token.getLexeme());
        this.fragments.add((ActionWordFragment)text);
    }

    protected void addNumberFragment(ActionWordTokenizer.AWToken token) {
        String value = token.getLexeme();
        this.addParameter(this.getNextParamName(), value, value);
    }

    protected void addParameter(String paramName, String defaultValue, String currentValue) {
        if (this.paramNames.contains(paramName)) {
            throw new InvalidActionWordParameterNameException("Action word parameter name must be unique.");
        }
        ActionWordParameter param = new ActionWordParameter(paramName, defaultValue);
        ActionWordParameterValue paramValue = new ActionWordParameterValue(currentValue);
        this.paramNames.add(paramName);
        this.parameterValues.add(paramValue);
        this.fragments.add((ActionWordFragment)param);
    }

    protected String getNextParamName() {
        String candidate;
        while (this.paramNames.contains(candidate = ACTION_WORD_PARAM_NAME_PREFIX + ++this.generatedParamIndex)) {
        }
        return candidate;
    }

    private void checkIfInputNullOrEmpty(String trimmedInput) {
        if (trimmedInput == null || trimmedInput.isEmpty()) {
            throw new InvalidActionWordInputException("Action word cannot be empty.");
        }
    }

    private void checkIfInputExceed255Char(String trimmedInput) {
        if (trimmedInput.length() > 255) {
            throw new InvalidActionWordInputException("Action word cannot exceed 255 characters.");
        }
    }

    protected void checkIfActionWordHasText(List<ActionWordTokenizer.AWToken> tokens) {
        long textCount = tokens.stream().map(ActionWordTokenizer.AWToken::getType).filter(ActionWordTokenizer.AWTokenType.PLAIN_TEXT::equals).count();
        if (textCount == 0L) {
            throw new InvalidActionWordInputException("Action word must contain at least some texts.");
        }
    }

    /*
     * Unable to fully structure code
     */
    private void checkIfActionWordContainsIllegalEscapeSequences(String trimmedInput) {
        charIndex = 0;
        if (trimmedInput.indexOf(92) >= 0) ** GOTO lbl13
        return;
lbl-1000:
        // 1 sources

        {
            if (charIndex == trimmedInput.length() - 1) {
                throw new InvalidEscapeSequenceException(charIndex + 1, trimmedInput);
            }
            nextChar = trimmedInput.charAt(charIndex + 1);
            if (!ActionWordUtil.isEscapableCharacter((char)nextChar)) {
                throw new InvalidEscapeSequenceException(charIndex + 1, trimmedInput);
            }
            if (nextChar == '\\') {
                charIndex += 2;
                continue;
            }
            ++charIndex;
lbl13:
            // 3 sources

            ** while ((charIndex = trimmedInput.indexOf((int)92, (int)charIndex)) >= 0)
        }
lbl14:
        // 1 sources

    }

    static class InvalidEscapeSequenceException
    extends ContextualizedActionWordException {
        private static final long serialVersionUID = 1399716200984978704L;

        InvalidEscapeSequenceException(int illegalEscapeSequencePosition, String textInput) {
            super(String.format("Invalid escape sequence at position %s.", illegalEscapeSequencePosition), textInput, illegalEscapeSequencePosition);
        }

        public String getI18nKey() {
            return "sqtm-core.error.action-word.invalid-escape-sequence";
        }
    }
}

