/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testautomation;

import jakarta.inject.Inject;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;
import org.squashtest.csp.core.bugtracker.core.UnsupportedAuthenticationModeException;
import org.squashtest.tm.api.plugin.EntityType;
import org.squashtest.tm.core.foundation.lang.Couple;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.servers.AuthenticationProtocol;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.domain.servers.ThirdPartyServer;
import org.squashtest.tm.domain.servers.TokenAuthCredentials;
import org.squashtest.tm.domain.testautomation.AutomatedExecutionExtender;
import org.squashtest.tm.domain.testautomation.AutomatedSuite;
import org.squashtest.tm.domain.testautomation.AutomatedSuiteWorkflow;
import org.squashtest.tm.domain.testautomation.AutomatedTest;
import org.squashtest.tm.domain.testautomation.TestAutomationProject;
import org.squashtest.tm.domain.testautomation.TestAutomationServer;
import org.squashtest.tm.domain.testautomation.TestAutomationServerKind;
import org.squashtest.tm.domain.users.ApiTokenPermission;
import org.squashtest.tm.security.UserContextHolder;
import org.squashtest.tm.service.internal.configuration.CallbackUrlProvider;
import org.squashtest.tm.service.internal.dto.WorkflowDto;
import org.squashtest.tm.service.internal.repository.AutomatedSuiteDao;
import org.squashtest.tm.service.internal.repository.display.EntityPathHeaderDao;
import org.squashtest.tm.service.internal.testautomation.BuildDef;
import org.squashtest.tm.service.internal.testautomation.ConfigurationVerifier;
import org.squashtest.tm.service.internal.testautomation.StartTestExecutionProvider;
import org.squashtest.tm.service.internal.testautomation.httpclient.BusClientFactory;
import org.squashtest.tm.service.internal.testautomation.httpclient.ClientRuntimeException;
import org.squashtest.tm.service.internal.testautomation.httpclient.MessageRefusedException;
import org.squashtest.tm.service.internal.testautomation.httpclient.SquashAutomWorkflowClient;
import org.squashtest.tm.service.internal.testautomation.httpclient.UnexpectedServerResponseException;
import org.squashtest.tm.service.internal.testautomation.httpclient.WorkflowClientFactory;
import org.squashtest.tm.service.internal.testautomation.model.IterationTestPlanItemWithCustomFields;
import org.squashtest.tm.service.internal.testautomation.model.TestAutomationServerAndNamespace;
import org.squashtest.tm.service.internal.testautomation.model.TestPlanContext;
import org.squashtest.tm.service.license.UltimateLicenseAvailabilityService;
import org.squashtest.tm.service.orchestrator.model.NameAndVersion;
import org.squashtest.tm.service.orchestrator.model.OrchestratorConfVersions;
import org.squashtest.tm.service.orchestrator.model.OrchestratorResponse;
import org.squashtest.tm.service.servers.CredentialsProvider;
import org.squashtest.tm.service.servers.StoredCredentialsManager;
import org.squashtest.tm.service.testautomation.model.AutomatedExecutionEnvironment;
import org.squashtest.tm.service.testautomation.model.SquashAutomExecutionConfiguration;
import org.squashtest.tm.service.testautomation.spi.InvalidSquashOrchestratorConfigurationException;
import org.squashtest.tm.service.testautomation.spi.OutdatedSquashOrchestratorException;
import org.squashtest.tm.service.testautomation.spi.ServerConnectionFailed;
import org.squashtest.tm.service.testautomation.spi.TestAutomationConnector;
import org.squashtest.tm.service.testautomation.spi.TestAutomationException;
import org.squashtest.tm.service.testautomation.spi.TestAutomationServerNoCredentialsException;
import org.squashtest.tm.service.user.ApiTokenService;

@Service
public class TestAutomationSquashAutomConnector
implements TestAutomationConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestAutomationSquashAutomConnector.class);
    private static final TestAutomationServerKind CONNECTOR_KIND = TestAutomationServerKind.squashOrchestrator;
    private static final String GENERIC_REST_CALL_ERROR_MESSAGE = "Failed to manage REST call for technical reasons";
    private static final String AUTOMATED_SUITE_TOKEN_SUFFIX = "-token";
    private static final long MILLSECONDS_IN_THREE_DAYS = 259200000L;
    private static final String TEMPORARY_TOKEN_DATE_FORMAT = "yyyyMMddHHmmss";
    @Value(value="${squashtm.testautomationserver.timeout:15}")
    private int requestTimeoutSeconds;
    @Inject
    private CredentialsProvider credentialsProvider;
    @Inject
    private StoredCredentialsManager storedCredentialsManager;
    @Inject
    private MessageSource i18nHelper;
    @Inject
    private CallbackUrlProvider callbackUrlProvider;
    @Inject
    private ApiTokenService apiTokenService;
    @Inject
    private StartTestExecutionProvider startTestExecutionProvider;
    @Inject
    private AutomatedSuiteDao autoSuiteDao;
    @Inject
    private EntityPathHeaderDao entityPathHeaderDao;
    @Value(value="${info.app.version:#{null}}")
    private String squashTMVersion;
    @Inject
    private UltimateLicenseAvailabilityService ultimateLicenseService;
    private final BusClientFactory busClientFactory = new BusClientFactory();
    private final WorkflowClientFactory workflowClientFactory = new WorkflowClientFactory();

    private String getMessage(String i18nKey) {
        Locale locale = LocaleContextHolder.getLocale();
        return this.i18nHelper.getMessage(i18nKey, null, locale);
    }

    @Override
    public TestAutomationServerKind getConnectorKind() {
        return CONNECTOR_KIND;
    }

    @Override
    public boolean checkCredentials(TestAutomationServer testAutomationServer, String login, String password) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean checkCredentials(TestAutomationServer testAutomationServer, Credentials credentials) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<TestAutomationProject> listProjectsOnServer(TestAutomationServer testAutomationServer, Credentials credentials) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<AutomatedTest> listTestsInProject(TestAutomationProject testAutomationProject, String username) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void executeParameterizedTests(Collection<Couple<AutomatedExecutionExtender, Map<String, Object>>> tests, String externalId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<AutomatedSuiteWorkflow> executeParameterizedTestsBasedOnITPICollection(Collection<IterationTestPlanItemWithCustomFields> tests, Long suiteId, Collection<SquashAutomExecutionConfiguration> configurations) {
        Map<Long, String> namespaceByTmProjectId = this.computeNamespaceByTmProjectId(configurations);
        Map<TestAutomationServerAndNamespace, List<IterationTestPlanItemWithCustomFields>> itemsByServerAndNamespace = this.mapParametrizedItemsByServerAndNamespace(tests, namespaceByTmProjectId);
        List<BuildDef> buildDefList = this.mapToBuildDef(itemsByServerAndNamespace);
        String callbackUrl = this.callbackUrlProvider.getCallbackUrl().toExternalForm();
        TestPlanContext testPlanContext = this.buildTestPlanContext(suiteId);
        String uuid = this.autoSuiteDao.findById(suiteId).getUuid();
        String token = this.createTemporaryApiTokenForAutomatedSuite(uuid);
        try {
            ArrayList<AutomatedSuiteWorkflow> workflows = new ArrayList<AutomatedSuiteWorkflow>();
            for (BuildDef buildDef : buildDefList) {
                Long projectId = buildDef.getProjectId();
                if (projectId == null) {
                    throw new IllegalArgumentException("Cannot have a null project id in workflow");
                }
                String workflowId = this.startTestExecutionProvider.create(buildDef, configurations, uuid, suiteId, testPlanContext, callbackUrl, token, this.workflowClientFactory, this.busClientFactory, this.entityPathHeaderDao, this.ultimateLicenseService.isAvailable()).run();
                AutomatedSuiteWorkflow workflow = new AutomatedSuiteWorkflow(workflowId, projectId);
                workflows.add(workflow);
            }
            return workflows;
        }
        catch (MessageRefusedException ex) {
            LOGGER.error(GENERIC_REST_CALL_ERROR_MESSAGE, (Throwable)ex);
            Object[] args = new Object[]{ex.getEndpoint(), ex.getHttpErrorCode()};
            throw new ServerConnectionFailed(this.i18nHelper.getMessage("testautomation.exceptions.connection.error", args, "the orchestrator is unreachable", LocaleContextHolder.getLocale()));
        }
        catch (ClientRuntimeException ex) {
            LOGGER.error(GENERIC_REST_CALL_ERROR_MESSAGE, (Throwable)ex);
            Object[] args = new Object[]{ex.getEndpoint()};
            throw new ServerConnectionFailed(this.i18nHelper.getMessage("testautomation.exceptions.connection.timeout", args, "the orchestrator is unreachable", LocaleContextHolder.getLocale()));
        }
        catch (InvalidSquashOrchestratorConfigurationException ex) {
            LOGGER.error(ex.getMessage(), (Throwable)((Object)ex));
            Object[] args = new Object[]{ex.getArgs().getFirst()};
            throw new InvalidSquashOrchestratorConfigurationException(this.i18nHelper.getMessage(ex.getI18nKey(), args, LocaleContextHolder.getLocale()));
        }
        catch (OutdatedSquashOrchestratorException ex) {
            LOGGER.error(ex.getMessage(), (Throwable)((Object)ex));
            throw new OutdatedSquashOrchestratorException(ex.getMessage());
        }
        catch (Exception ex) {
            throw new TestAutomationException(GENERIC_REST_CALL_ERROR_MESSAGE, ex);
        }
    }

    private String createTemporaryApiTokenForAutomatedSuite(String uuid) {
        long nowMillis = System.currentTimeMillis();
        Date threeDaysFromNow = new Date(nowMillis + 259200000L);
        return this.apiTokenService.generateApiToken(this.generateTokenName(uuid, nowMillis), threeDaysFromNow, String.valueOf(ApiTokenPermission.READ_WRITE)).generatedJwtToken();
    }

    private String generateTokenName(String uuid, long nowMillis) {
        SimpleDateFormat formatter = new SimpleDateFormat(TEMPORARY_TOKEN_DATE_FORMAT);
        String timestamp = formatter.format(new Date(nowMillis));
        return timestamp + "-" + uuid + AUTOMATED_SUITE_TOKEN_SUFFIX;
    }

    private TestPlanContext buildTestPlanContext(Long suiteId) {
        AutomatedSuite automatedSuite = this.autoSuiteDao.findById(suiteId);
        if (automatedSuite.getIteration() != null) {
            Iteration iteration = automatedSuite.getIteration();
            String path = this.entityPathHeaderDao.buildIterationPathHeader(iteration.getId());
            String entityName = iteration.getName();
            return new TestPlanContext(EntityType.ITERATION, entityName, path, iteration.getUuid(), this.squashTMVersion);
        }
        if (automatedSuite.getTestSuite() != null) {
            TestSuite testSuite = automatedSuite.getTestSuite();
            String path = this.entityPathHeaderDao.buildTestSuitePathHeader(testSuite.getId());
            String entityName = testSuite.getName();
            return new TestPlanContext(EntityType.TEST_SUITE, entityName, path, testSuite.getUuid(), this.squashTMVersion);
        }
        throw new IllegalArgumentException("Automated suite is not attached to any iteration nor test suite.");
    }

    private Map<Long, String> computeNamespaceByTmProjectId(Collection<SquashAutomExecutionConfiguration> configurations) {
        Map<String, List<Long>> projectIdsByNamespace = this.computeProjectIdsByNamespaceMap(configurations);
        ArrayList<Map.Entry<String, List<Long>>> projectIdsByNamespaceEntryList = new ArrayList<Map.Entry<String, List<Long>>>(projectIdsByNamespace.entrySet());
        HashMap<Long, String> namespaceByProjectId = new HashMap<Long, String>();
        while (!projectIdsByNamespaceEntryList.isEmpty()) {
            Map.Entry<String, List<Long>> entryWithTheMostProjectIds = this.removeEntryWithMostProjectIds(projectIdsByNamespaceEntryList);
            this.fillResultMapAndUpdateTransientList(projectIdsByNamespaceEntryList, entryWithTheMostProjectIds, namespaceByProjectId);
        }
        return namespaceByProjectId;
    }

    private void fillResultMapAndUpdateTransientList(List<Map.Entry<String, List<Long>>> projectIdsByNamespaceEntryList, Map.Entry<String, List<Long>> entryWithTheMostProjectIds, Map<Long, String> namespaceByProjectId) {
        entryWithTheMostProjectIds.getValue().forEach(projectId -> {
            namespaceByProjectId.put((Long)projectId, (String)entryWithTheMostProjectIds.getKey());
            projectIdsByNamespaceEntryList.forEach(entry -> {
                List projectIdsList = (List)entry.getValue();
                projectIdsList.remove(projectId);
            });
            projectIdsByNamespaceEntryList.removeIf(entry -> ((List)entry.getValue()).isEmpty());
        });
    }

    private Map.Entry<String, List<Long>> removeEntryWithMostProjectIds(List<Map.Entry<String, List<Long>>> projectIdsByNamespaceEntryList) {
        projectIdsByNamespaceEntryList.sort(Comparator.comparingInt(entry -> ((List)entry.getValue()).size()).reversed());
        return projectIdsByNamespaceEntryList.remove(0);
    }

    private Map<String, List<Long>> computeProjectIdsByNamespaceMap(Collection<SquashAutomExecutionConfiguration> configurations) {
        HashMap<String, List<Long>> projectIdsByNamespace = new HashMap<String, List<Long>>();
        configurations.forEach(configuration -> {
            Long projectId = configuration.getProjectId();
            configuration.getNamespaces().forEach(namespace -> {
                List projectIdsForTag = (List)projectIdsByNamespace.get(namespace);
                if (Objects.isNull(projectIdsForTag)) {
                    projectIdsByNamespace.put((String)namespace, new ArrayList());
                    projectIdsForTag = (List)projectIdsByNamespace.get(namespace);
                }
                projectIdsForTag.add(projectId);
            });
        });
        return projectIdsByNamespace;
    }

    @Override
    public URL findTestAutomationProjectURL(TestAutomationProject testAutomationProject) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean testListIsOrderGuaranteed(Collection<AutomatedTest> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AuthenticationProtocol[] getSupportedProtocols() {
        return new AuthenticationProtocol[]{AuthenticationProtocol.TOKEN_AUTH};
    }

    private Map<TestAutomationServerAndNamespace, List<IterationTestPlanItemWithCustomFields>> mapParametrizedItemsByServerAndNamespace(Collection<IterationTestPlanItemWithCustomFields> tests, Map<Long, String> namespaceByProjectId) {
        Map serverMap = tests.stream().map(item -> item.getIterationTestPlanItem().getReferencedTestCase().getProject().getTestAutomationServer()).collect(Collectors.toMap(ThirdPartyServer::getId, server -> server, (existing, replacement) -> existing, LinkedHashMap::new));
        return tests.stream().collect(Collectors.groupingBy(item -> {
            Project project = item.getIterationTestPlanItem().getReferencedTestCase().getProject();
            Long serverId = project.getTestAutomationServer().getId();
            String namespace = (String)namespaceByProjectId.get(project.getId());
            return new TestAutomationServerAndNamespace((TestAutomationServer)serverMap.get(serverId), namespace);
        }, LinkedHashMap::new, Collectors.toList()));
    }

    private List<BuildDef> mapToBuildDef(Map<TestAutomationServerAndNamespace, List<IterationTestPlanItemWithCustomFields>> itemsByServerAndNamespace) {
        return itemsByServerAndNamespace.entrySet().stream().map(entry -> {
            String namespace = ((TestAutomationServerAndNamespace)entry.getKey()).getNamespace();
            Project project = ((IterationTestPlanItemWithCustomFields)((List)entry.getValue()).get(0)).getIterationTestPlanItem().getReferencedTestCase().getProject();
            TestAutomationServer automationServer = ((TestAutomationServerAndNamespace)entry.getKey()).getTestAutomationServer();
            Optional<TokenAuthCredentials> projectCredentials = this.getOptionalTmProjectCredentials(automationServer.getId(), project.getId());
            TokenAuthCredentials credentials = projectCredentials.orElseGet(() -> this.getAutomationServerCredentials(automationServer));
            return new BuildDef(automationServer, credentials, namespace, (List)entry.getValue());
        }).toList();
    }

    private TokenAuthCredentials getAutomationServerCredentials(TestAutomationServer automationServer) {
        Optional<Credentials> maybeCredentials = this.credentialsProvider.getAppLevelCredentials((ThirdPartyServer)automationServer);
        Supplier<TestAutomationServerNoCredentialsException> throwIfNull = () -> {
            throw new TestAutomationServerNoCredentialsException(String.format(this.getMessage("message.testAutomationServer.noCredentials"), automationServer.getName()));
        };
        Credentials credentials = maybeCredentials.orElseThrow(throwIfNull);
        return this.asTokenAuthCredentials(credentials);
    }

    private Optional<TokenAuthCredentials> getOptionalTmProjectCredentials(Long serverId, Long projectId) {
        return Optional.ofNullable(this.storedCredentialsManager.findProjectCredentials(serverId, projectId)).filter(TokenAuthCredentials.class::isInstance).map(TokenAuthCredentials.class::cast);
    }

    private TokenAuthCredentials asTokenAuthCredentials(Credentials credentials) {
        AuthenticationProtocol protocol = credentials.getImplementedProtocol();
        if (!this.supports(protocol)) {
            throw new UnsupportedAuthenticationModeException(protocol.toString());
        }
        return (TokenAuthCredentials)credentials;
    }

    Authentication getUserAuthentication() {
        return UserContextHolder.getAuthentication();
    }

    @Override
    public List<AutomatedExecutionEnvironment> getAllAccessibleEnvironments(TestAutomationServer testAutomationServer) {
        String token = this.getAutomationServerCredentials(testAutomationServer).getToken();
        this.checkConfigurationValidity(testAutomationServer, token);
        return this.getAllAccessibleEnvironmentsWithToken(testAutomationServer, token);
    }

    private void checkConfigurationValidity(TestAutomationServer testAutomationServer, String token) {
        ConfigurationVerifier.verify(token, testAutomationServer, this.i18nHelper);
        List<NameAndVersion> nameAndVersions = this.getOrchestratorConfVersionsWithToken(testAutomationServer, token).getResponse().getBaseImages();
        if (nameAndVersions == null) {
            LOGGER.warn("Squash orchestrator version could not be retrieved, which may cause issues.", new Object[0]);
            return;
        }
        String squashOrchestratorAllinoneVersion = nameAndVersions.get(0).getVersion();
        ConfigurationVerifier.checkSquashOrchestratorVersionValidity(squashOrchestratorAllinoneVersion, this.squashTMVersion, this.i18nHelper);
    }

    @Override
    public List<AutomatedExecutionEnvironment> getAllAccessibleEnvironments(TestAutomationServer testAutomationServer, Credentials credentials) {
        TokenAuthCredentials tokenAuthCredentials = this.asTokenAuthCredentials(credentials);
        this.checkConfigurationValidity(testAutomationServer, tokenAuthCredentials.getToken());
        return this.getAllAccessibleEnvironmentsWithToken(testAutomationServer, tokenAuthCredentials.getToken());
    }

    private List<AutomatedExecutionEnvironment> getAllAccessibleEnvironmentsWithToken(TestAutomationServer testAutomationServer, String token) {
        try {
            SquashAutomWorkflowClient workflowClient = this.workflowClientFactory.getClient(testAutomationServer.getUrl(), testAutomationServer.getObserverUrl(), testAutomationServer.getKillswitchUrl(), token, this.requestTimeoutSeconds);
            return workflowClient.getAllAccessibleEnvironments(testAutomationServer);
        }
        catch (MessageRefusedException ex) {
            throw new TestAutomationException(ex.getMessage(), ex);
        }
    }

    @Override
    public boolean supportsAutomatedExecutionEnvironments() {
        return true;
    }

    @Override
    public OrchestratorResponse<OrchestratorConfVersions> getOrchestratorConfVersions(TestAutomationServer server) {
        return this.getOrchestratorConfVersionsWithToken(server, this.getAutomationServerCredentials(server).getToken());
    }

    @Override
    public OrchestratorResponse<List<WorkflowDto>> getProjectWorkflows(TestAutomationServer server, Long projectId, Credentials credentials) {
        String token = Objects.nonNull(credentials) ? this.asTokenAuthCredentials(credentials).getToken() : this.getAutomationServerCredentials(server).getToken();
        try {
            SquashAutomWorkflowClient workflowClient = this.workflowClientFactory.getClient(server.getUrl(), server.getObserverUrl(), server.getKillswitchUrl(), token, this.requestTimeoutSeconds);
            return workflowClient.fetchProjectWorkflows(server, projectId);
        }
        catch (MessageRefusedException ex) {
            throw new TestAutomationException(ex.getMessage(), ex);
        }
    }

    @Override
    public OrchestratorResponse<String> getWorkflowLogs(TestAutomationServer server, TokenAuthCredentials credentials, String workflowId) {
        String token = Objects.nonNull(credentials) ? this.asTokenAuthCredentials((Credentials)credentials).getToken() : this.getAutomationServerCredentials(server).getToken();
        try {
            SquashAutomWorkflowClient workflowClient = this.workflowClientFactory.getClient(server.getUrl(), server.getObserverUrl(), server.getKillswitchUrl(), token, this.requestTimeoutSeconds);
            return workflowClient.fetchWorkflowLogs(workflowId);
        }
        catch (MessageRefusedException ex) {
            throw new TestAutomationException(ex.getMessage(), ex);
        }
    }

    @Override
    public OrchestratorResponse<Void> killWorkflow(TestAutomationServer server, Long projectId, TokenAuthCredentials credentials, String workflowId) {
        String token = Objects.nonNull(credentials) ? this.asTokenAuthCredentials((Credentials)credentials).getToken() : this.getAutomationServerCredentials(server).getToken();
        try {
            SquashAutomWorkflowClient workflowClient = this.workflowClientFactory.getClient(server.getUrl(), server.getObserverUrl(), server.getKillswitchUrl(), token, this.requestTimeoutSeconds);
            return workflowClient.killWorkflow(server, projectId, workflowId);
        }
        catch (MessageRefusedException ex) {
            int httpErrorCode = ex.getHttpErrorCode();
            if (httpErrorCode == 404) {
                LOGGER.error("An error occurred while stopping the workflow. The workflow was not found and the error code is {}.", new Object[]{httpErrorCode});
            } else {
                LOGGER.error("An error occurred while stopping the workflow. Unauthorized access and the error code is {}.", new Object[]{httpErrorCode});
            }
            throw new TestAutomationException(ex.getMessage(), ex);
        }
    }

    private OrchestratorResponse<OrchestratorConfVersions> getOrchestratorConfVersionsWithToken(TestAutomationServer server, String token) {
        try {
            SquashAutomWorkflowClient workflowClient = this.workflowClientFactory.getClient(server.getUrl(), server.getObserverUrl(), server.getKillswitchUrl(), token, this.requestTimeoutSeconds);
            return workflowClient.fetchOrchestratorConfVersions(server);
        }
        catch (MessageRefusedException | UnexpectedServerResponseException ex) {
            throw new TestAutomationException(ex.getMessage(), ex);
        }
    }
}

