/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.TypedQuery;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementStatus;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.service.internal.repository.CustomRequirementVersionDao;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;

@Repository(value="squashtest.tm.repository.RequirementVersionDaoImpl")
@Primary
public class RequirementVersionDaoImpl
implements CustomRequirementVersionDao {
    @PersistenceContext
    private EntityManager em;
    @Inject
    private ActiveMilestoneHolder activeMilestoneHolder;

    @Override
    public Requirement findRequirementById(long requirementId) {
        return (Requirement)this.em.getReference(Requirement.class, (Object)requirementId);
    }

    @Override
    public RequirementVersion findByRequirementIdAndMilestone(long requirementId) {
        Optional<Milestone> active = this.activeMilestoneHolder.getActiveMilestone();
        if (active.isPresent()) {
            TypedQuery q = this.em.createNamedQuery("requirementVersion.findVersionByRequirementAndMilestone", RequirementVersion.class);
            q.setParameter("requirementId", (Object)requirementId);
            q.setParameter("milestoneId", (Object)active.get().getId());
            return (RequirementVersion)q.getSingleResult();
        }
        TypedQuery q = this.em.createNamedQuery("requirementVersion.findLatestRequirementVersion", RequirementVersion.class);
        q.setParameter("requirementId", (Object)requirementId);
        return (RequirementVersion)q.getSingleResult();
    }

    @Override
    public Map<Long, RequirementStatus> findRequirementStatusesByVersionIds(Collection<Long> versionIds) {
        return this.em.createQuery("select rv.id, rv.requirement.resource.status from RequirementVersion rv where rv.id in :versionIds", Object[].class).setParameter("versionIds", versionIds).getResultStream().collect(Collectors.toMap(r -> (Long)r[0], r -> (RequirementStatus)r[1]));
    }

    @Override
    public Map<Long, RequirementStatus> findRequirementStatusesByRequirementIds(Collection<Long> requirementIds) {
        return this.em.createQuery("select req.id, req.resource.status from Requirement req where req.id in :requirementIds", Object[].class).setParameter("requirementIds", requirementIds).getResultStream().collect(Collectors.toMap(r -> (Long)r[0], r -> (RequirementStatus)r[1]));
    }

    @Override
    public List<RequirementVersion> loadForCoverageAddition(Collection<Long> versionIds) {
        return this.em.createQuery("select rv from RequirementVersion rv join fetch rv.requirement left join fetch rv.requirementVersionCoverages where rv.id in :versionIds", RequirementVersion.class).setParameter("versionIds", versionIds).getResultList();
    }

    @Override
    public RequirementVersion loadForCoverageAddition(Long versionId) {
        return (RequirementVersion)this.em.createQuery("select rv from RequirementVersion rv\njoin fetch rv.requirement\nleft join fetch rv.requirementVersionCoverages\nwhere rv.id = :versionId", RequirementVersion.class).setParameter("versionId", (Object)versionId).getSingleResult();
    }

    @Override
    public RequirementVersion findByRemoteSyncIdAndIssueKey(Long remoteSyncId, String issueKey) {
        return this.em.createQuery("select reqVersion from RequirementVersion reqVersion\ninner join reqVersion.requirement.syncExtender extender\nwhere extender.remoteSynchronisation.id = :remoteSyncId\nand extender.remoteReqId = :issueKey", RequirementVersion.class).setParameter("remoteSyncId", (Object)remoteSyncId).setParameter("issueKey", (Object)issueKey).getResultStream().findFirst().orElse(null);
    }
}

