/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipFile;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.stereotype.Service;
import org.squashtest.tm.core.foundation.lang.DateUtils;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.CampaignTestPlanItem;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.Sprint;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.campaign.testplan.TestPlan;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStep;
import org.squashtest.tm.domain.projectimporter.PivotFormatImport;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.campaign.CampaignLibraryNavigationService;
import org.squashtest.tm.service.campaign.CustomIterationModificationService;
import org.squashtest.tm.service.campaign.IterationModificationService;
import org.squashtest.tm.service.internal.customfield.PrivateCustomFieldValueService;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AbstractPivotObject;
import org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.CampaignPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.ExecutionPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.ExecutionStepPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.IterationPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.SprintPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.TestPlanItemPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.TestSuitePivot;
import org.squashtest.tm.service.internal.dto.projectimporter.JsonImportFile;
import org.squashtest.tm.service.internal.dto.projectimporter.PivotImportMetadata;
import org.squashtest.tm.service.internal.dto.projectimporter.ProjectIdsReferences;
import org.squashtest.tm.service.internal.dto.projectimporter.TestSuiteInfo;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.AbstractPivotImport;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.AttachmentHolderInfo;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.PivotFormatLoggerHelper;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.PivotImportStrategy;
import org.squashtest.tm.service.internal.repository.TestCaseDao;
import org.squashtest.tm.service.internal.repository.UserDao;
import org.squashtest.tm.service.pivot.PivotFileManager;
import org.squashtest.tm.service.pivot.converters.AdminPivotConverterService;
import org.squashtest.tm.service.pivot.converters.ExecutionWorkspaceConverterService;
import org.squashtest.tm.service.pivot.projectimporter.pivotimporter.AttachmentPivotImportService;
import org.squashtest.tm.service.pivot.projectimporter.pivotimporter.ExecutionWorkspacePivotImporterService;

@Service
public class ExecutionWorkspacePivotImporterServiceImpl
extends AbstractPivotImport
implements ExecutionWorkspacePivotImporterService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutionWorkspacePivotImporterService.class);
    private final CampaignLibraryNavigationService campaignLibraryNavigationService;
    private final IterationModificationService iterationModificationService;
    private final PrivateCustomFieldValueService privateCustomFieldValueService;
    private final CustomIterationModificationService customIterationModificationService;
    private final AttachmentPivotImportService attachmentPivotImportService;
    private final UserDao userDao;
    private final ExecutionWorkspaceConverterService executionWorkspaceConverterService;
    private final AdminPivotConverterService adminPivotConverterService;
    private final TestCaseDao testCaseDao;
    private final DSLContext dsl;
    @PersistenceContext
    private EntityManager entityManager;

    public ExecutionWorkspacePivotImporterServiceImpl(CampaignLibraryNavigationService campaignLibraryNavigationService, IterationModificationService iterationModificationService, PrivateCustomFieldValueService privateCustomFieldValueService, CustomIterationModificationService customIterationModificationService, AttachmentPivotImportService attachmentPivotImportService, UserDao userDao, ExecutionWorkspaceConverterService executionWorkspaceConverterService, AdminPivotConverterService adminPivotConverterService, TestCaseDao testCaseDao, DSLContext dsl) {
        super(LOGGER);
        this.campaignLibraryNavigationService = campaignLibraryNavigationService;
        this.iterationModificationService = iterationModificationService;
        this.privateCustomFieldValueService = privateCustomFieldValueService;
        this.customIterationModificationService = customIterationModificationService;
        this.userDao = userDao;
        this.attachmentPivotImportService = attachmentPivotImportService;
        this.executionWorkspaceConverterService = executionWorkspaceConverterService;
        this.adminPivotConverterService = adminPivotConverterService;
        this.testCaseDao = testCaseDao;
        this.dsl = dsl;
    }

    private <T extends AbstractPivotObject> void createEntities(List<T> entities, String entityKind, PivotFormatImport pivotFormatImport, PivotFileManager.ConsumerThrowing<T, Exception> createEntity) {
        for (AbstractPivotObject entity : entities) {
            PivotFormatLoggerHelper.logEntityCreationStarted(LOGGER, entityKind, entity.getPivotId(), pivotFormatImport);
            try {
                createEntity.accept(entity);
                PivotFormatLoggerHelper.logEntityCreatedSuccessfully(LOGGER, entityKind, entity, pivotFormatImport);
            }
            catch (Exception e) {
                PivotFormatLoggerHelper.handleEntityCreationFailed(LOGGER, entityKind, entity, pivotFormatImport, e);
            }
        }
        entities.clear();
        this.entityManager.flush();
        this.entityManager.clear();
    }

    @Override
    public void importCampaignsFromZipArchive(ZipFile zipFile, ProjectIdsReferences projectIdsReferences, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) throws IOException {
        this.importEntitiesFromZipArchive(zipFile, JsonImportFile.CAMPAIGNS, pivotFormatImport, pivotImportMetadata, "campaigns", "campaign", this.getCampaignPivotImportStrategy(projectIdsReferences, pivotImportMetadata, pivotFormatImport));
    }

    private PivotImportStrategy<CampaignPivot> getCampaignPivotImportStrategy(final ProjectIdsReferences projectIdsReferences, final PivotImportMetadata pivotImportMetadata, final PivotFormatImport pivotFormatImport) {
        return new PivotImportStrategy<CampaignPivot>(){

            @Override
            public Class<CampaignPivot> getPivotClazz() {
                return CampaignPivot.class;
            }

            @Override
            public void create(List<CampaignPivot> entities) {
                ExecutionWorkspacePivotImporterServiceImpl.this.createEntities(entities, "campaign", pivotFormatImport, campaignPivot -> ExecutionWorkspacePivotImporterServiceImpl.this.createCampaign((CampaignPivot)campaignPivot, projectIdsReferences, pivotImportMetadata, pivotFormatImport));
            }
        };
    }

    private void createCampaign(CampaignPivot campaignPivot, ProjectIdsReferences projectIdsReferences, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) throws IOException, ParseException {
        Long squashFolderTargetId = pivotImportMetadata.getCampaignFoldersIdsMap().get(campaignPivot.getParentId());
        Map<Long, RawValue> customFields = this.adminPivotConverterService.pivotToCustomFieldValues(campaignPivot.getCustomFields(), pivotImportMetadata);
        Campaign campaignFromPivot = this.executionWorkspaceConverterService.pivotToCampaign(campaignPivot);
        Campaign squashCampaign = switch (campaignPivot.getParentType()) {
            case EntityType.CAMPAIGN_LIBRARY -> this.campaignLibraryNavigationService.addCampaignToCampaignLibraryUnsecured(projectIdsReferences.getCampaignLibraryId(), campaignFromPivot, customFields);
            case EntityType.CAMPAIGN_FOLDER -> this.campaignLibraryNavigationService.addCampaignToCampaignFolderUnsecured(squashFolderTargetId, campaignFromPivot, customFields);
            default -> throw new IllegalArgumentException("This entity has an entity type that is not handled " + String.valueOf(campaignPivot.getParentType()));
        };
        pivotImportMetadata.getCampaignIdsMap().put(campaignPivot.getPivotId(), squashCampaign.getId());
        List<TestPlanItemBindingDto> testPlanItemBindingDtos = this.getTestPlanItemBindingDtos(campaignPivot.getTestPlanItems(), pivotImportMetadata);
        this.addTestPlanItemToCampaign(testPlanItemBindingDtos, squashCampaign);
        this.attachmentPivotImportService.addAttachmentsToEntity(campaignPivot.getAttachments(), new AttachmentHolderInfo(squashCampaign.getId(), squashCampaign.getAttachmentList().getId(), EntityType.CAMPAIGN, campaignPivot.getPivotId()), pivotFormatImport, pivotImportMetadata);
    }

    private void addTestPlanItemToCampaign(List<TestPlanItemBindingDto> testPlanItemBindingDtos, Campaign campaign) {
        testPlanItemBindingDtos.forEach(tpi -> {
            CampaignTestPlanItem campaignTestPlanItem = new CampaignTestPlanItem(tpi.testCase(), tpi.dataset());
            campaign.addToTestPlan(campaignTestPlanItem);
        });
    }

    @Override
    public void importIterationsFromZipArchive(ZipFile zipFile, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) throws IOException {
        this.importEntitiesFromZipArchive(zipFile, JsonImportFile.ITERATIONS, pivotFormatImport, pivotImportMetadata, "iterations", "iteration", this.getIterationPivotImportStrategy(pivotImportMetadata, pivotFormatImport));
    }

    private PivotImportStrategy<IterationPivot> getIterationPivotImportStrategy(final PivotImportMetadata pivotImportMetadata, final PivotFormatImport pivotFormatImport) {
        return new PivotImportStrategy<IterationPivot>(){

            @Override
            public Class<IterationPivot> getPivotClazz() {
                return IterationPivot.class;
            }

            @Override
            public void create(List<IterationPivot> entities) {
                ExecutionWorkspacePivotImporterServiceImpl.this.createEntities(entities, "iteration", pivotFormatImport, iterationPivot -> ExecutionWorkspacePivotImporterServiceImpl.this.createIteration((IterationPivot)iterationPivot, pivotImportMetadata, pivotFormatImport));
            }
        };
    }

    private void createIteration(IterationPivot iterationPivot, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) throws IOException, ParseException {
        Long squashTargetId = pivotImportMetadata.getCampaignIdsMap().get(iterationPivot.getParentId());
        Map<Long, RawValue> customFields = this.adminPivotConverterService.pivotToCustomFieldValues(iterationPivot.getCustomFields(), pivotImportMetadata);
        Iteration iterationFromPivot = this.executionWorkspaceConverterService.pivotToIteration(iterationPivot);
        Iteration squashIteration = this.customIterationModificationService.addIterationToCampaignUnsecured(iterationFromPivot, squashTargetId, false, customFields);
        pivotImportMetadata.getIterationIdsMap().put(iterationPivot.getPivotId(), squashIteration.getId());
        List<TestPlanItemBindingDto> testPlanItemBindingDtos = this.getTestPlanItemBindingDtos(iterationPivot.getTestPlanItems(), pivotImportMetadata);
        this.addTestPlanItemToIteration(testPlanItemBindingDtos, squashIteration, pivotImportMetadata);
        this.attachmentPivotImportService.addAttachmentsToEntity(iterationPivot.getAttachments(), new AttachmentHolderInfo(squashIteration.getId(), squashIteration.getAttachmentList().getId(), EntityType.ITERATION, iterationPivot.getPivotId()), pivotFormatImport, pivotImportMetadata);
    }

    private void addTestPlanItemToIteration(List<TestPlanItemBindingDto> testPlanItemBindingDtos, Iteration iteration, PivotImportMetadata pivotImportMetadata) {
        TestPlan testPlan = iteration.getTestPlan();
        testPlanItemBindingDtos.forEach(tpi -> this.addTestPlanItemToIteration((TestPlanItemBindingDto)tpi, testPlan, pivotImportMetadata));
    }

    private void addTestPlanItemToIteration(TestPlanItemBindingDto testPlanItemBindingDto, TestPlan testPlan, PivotImportMetadata pivotImportMetadata) {
        TestPlanItem createdTestPlanItem = testPlanItemBindingDto.testCase() == null ? testPlan.createAndAddItemWithoutTestCase(testPlanItemBindingDto.testCaseLabel()) : testPlan.createAndAddTestPlanItem(testPlanItemBindingDto.testCase(), testPlanItemBindingDto.dataset(), null);
        this.entityManager.persist((Object)createdTestPlanItem);
        pivotImportMetadata.getTestPlanItemIdsMap().put(testPlanItemBindingDto.testPlanItemPivotId(), createdTestPlanItem.getId());
    }

    private List<TestPlanItemBindingDto> getTestPlanItemBindingDtos(List<TestPlanItemPivot> testPlanItemPivots, PivotImportMetadata pivotImportMetadata) {
        Set testCaseIds = testPlanItemPivots.stream().map(tpi -> pivotImportMetadata.getTestCaseIdsMap().get(tpi.getTestCaseId())).collect(Collectors.toSet());
        Map testCaseByIds = this.testCaseDao.findTestCasesWithDatasetsByIds(testCaseIds);
        return testPlanItemPivots.stream().map(testPlanItemPivot -> this.getTestPlanItemBindingDto((TestPlanItemPivot)testPlanItemPivot, testCaseByIds, pivotImportMetadata)).toList();
    }

    private TestPlanItemBindingDto getTestPlanItemBindingDto(TestPlanItemPivot testPlanItemPivot, Map<Long, TestCase> testCaseByIds, PivotImportMetadata pivotImportMetadata) {
        if (Objects.isNull(testPlanItemPivot.getTestCaseId())) {
            return new TestPlanItemBindingDto(null, null, testPlanItemPivot.getTestCaseLabel(), testPlanItemPivot.getPivotId());
        }
        Long testCaseId = pivotImportMetadata.getTestCaseIdsMap().get(testPlanItemPivot.getTestCaseId());
        TestCase testCase = testCaseByIds.get(testCaseId);
        Dataset ds = null;
        if (testPlanItemPivot.getDatasetId() != null) {
            Long datasetId = pivotImportMetadata.getDatasetIdsMap().get(testPlanItemPivot.getDatasetId());
            ds = testCase.getDatasets().stream().filter(d -> d.getId().equals(datasetId)).findFirst().orElse(null);
        }
        return new TestPlanItemBindingDto(testCase, ds, null, testPlanItemPivot.getPivotId());
    }

    @Override
    public void importTestSuitesFromZipArchive(ZipFile zipFile, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) throws IOException {
        this.importEntitiesFromZipArchive(zipFile, JsonImportFile.TEST_SUITES, pivotFormatImport, pivotImportMetadata, "test suites", "test suite", this.getTestSuitePivotImportStrategy(pivotImportMetadata, pivotFormatImport));
    }

    private PivotImportStrategy<TestSuitePivot> getTestSuitePivotImportStrategy(final PivotImportMetadata pivotImportMetadata, final PivotFormatImport pivotFormatImport) {
        return new PivotImportStrategy<TestSuitePivot>(){

            @Override
            public Class<TestSuitePivot> getPivotClazz() {
                return TestSuitePivot.class;
            }

            @Override
            public void create(List<TestSuitePivot> entities) {
                ExecutionWorkspacePivotImporterServiceImpl.this.createEntities(entities, "test suite", pivotFormatImport, testSuitePivot -> ExecutionWorkspacePivotImporterServiceImpl.this.createTestSuite((TestSuitePivot)testSuitePivot, pivotImportMetadata, pivotFormatImport));
            }
        };
    }

    private void createTestSuite(TestSuitePivot testSuitePivot, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) throws IOException {
        Long squashTargetId = pivotImportMetadata.getIterationIdsMap().get(testSuitePivot.getParentId());
        Map<Long, RawValue> customFields = this.adminPivotConverterService.pivotToCustomFieldValues(testSuitePivot.getCustomFields(), pivotImportMetadata);
        TestSuite testSuiteFromPivot = this.executionWorkspaceConverterService.pivotToTestSuite(testSuitePivot);
        TestSuite squashTestSuite = this.campaignLibraryNavigationService.addTestSuiteToIterationUnsecured(squashTargetId, testSuiteFromPivot, customFields);
        pivotImportMetadata.getTestSuiteIdsMap().put(testSuitePivot.getPivotId(), new TestSuiteInfo(squashTestSuite.getId(), testSuitePivot.getStatus()));
        this.bindTestPlanItemsToTestSuite(testSuitePivot.getTestPlanItemBindings(), pivotImportMetadata, squashTestSuite);
        squashTestSuite.setExecutionStatus(testSuitePivot.getStatus());
        this.attachmentPivotImportService.addAttachmentsToEntity(testSuitePivot.getAttachments(), new AttachmentHolderInfo(squashTestSuite.getId(), squashTestSuite.getAttachmentList().getId(), EntityType.TEST_SUITE, testSuitePivot.getPivotId()), pivotFormatImport, pivotImportMetadata);
    }

    private void bindTestPlanItemsToTestSuite(List<String> testPlanItemBindings, PivotImportMetadata pivotImportMetadata, TestSuite testSuite) {
        List<Long> testPlanItemIds = testPlanItemBindings.stream().map(internalId -> pivotImportMetadata.getTestPlanItemIdsMap().get(internalId)).toList();
        testSuite.bindTestPlanItemsById(testPlanItemIds);
    }

    @Override
    public void importSprintsFromZipArchive(ZipFile zipFile, ProjectIdsReferences projectIdsReferences, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) throws IOException {
        this.importEntitiesFromZipArchive(zipFile, JsonImportFile.SPRINTS, pivotFormatImport, pivotImportMetadata, "sprints", "sprint", this.getSprintPivotImportStrategy(projectIdsReferences, pivotImportMetadata, pivotFormatImport));
    }

    private PivotImportStrategy<SprintPivot> getSprintPivotImportStrategy(final ProjectIdsReferences projectIdsReferences, final PivotImportMetadata pivotImportMetadata, final PivotFormatImport pivotFormatImport) {
        return new PivotImportStrategy<SprintPivot>(){

            @Override
            public Class<SprintPivot> getPivotClazz() {
                return SprintPivot.class;
            }

            @Override
            public void create(List<SprintPivot> entities) {
                ExecutionWorkspacePivotImporterServiceImpl.this.createEntities(entities, "sprints", pivotFormatImport, sprintPivot -> ExecutionWorkspacePivotImporterServiceImpl.this.createSprint((SprintPivot)sprintPivot, projectIdsReferences, pivotImportMetadata, pivotFormatImport));
            }
        };
    }

    private void createSprint(SprintPivot sprintPivot, ProjectIdsReferences projectIdsReferences, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) throws ParseException, IOException {
        Long squashFolderTargetId = pivotImportMetadata.getCampaignFoldersIdsMap().get(sprintPivot.getParentId());
        Map<Long, RawValue> customFields = this.adminPivotConverterService.pivotToCustomFieldValues(sprintPivot.getCustomFields(), pivotImportMetadata);
        Sprint sprint = this.executionWorkspaceConverterService.pivotToSprint(sprintPivot);
        switch (sprintPivot.getParentType()) {
            case CAMPAIGN_LIBRARY: {
                this.campaignLibraryNavigationService.addSprintToCampaignLibrary(projectIdsReferences.getCampaignLibraryId(), sprint, customFields);
                break;
            }
            case CAMPAIGN_FOLDER: {
                this.campaignLibraryNavigationService.addSprintToCampaignFolderUnsecured(squashFolderTargetId, sprint, customFields);
                break;
            }
            case SPRINT_GROUP: {
                this.campaignLibraryNavigationService.addSprintToSprintGroupUnsecured(squashFolderTargetId, sprint, customFields);
                break;
            }
            default: {
                throw new IllegalArgumentException("This entity has an entity type that is not handled " + String.valueOf(sprintPivot.getParentType()));
            }
        }
        pivotImportMetadata.getSprintIdsMap().put(sprintPivot.getPivotId(), sprint.getId());
        this.attachmentPivotImportService.addAttachmentsToEntity(sprintPivot.getAttachments(), new AttachmentHolderInfo(sprint.getId(), sprint.getAttachmentList().getId(), EntityType.SPRINT, sprintPivot.getPivotId()), pivotFormatImport, pivotImportMetadata);
    }

    @Override
    public void importExecutionsFromZipArchive(ZipFile zipFile, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) throws IOException {
        this.importEntitiesFromZipArchive(zipFile, JsonImportFile.EXECUTIONS, pivotFormatImport, pivotImportMetadata, "executions", "execution", this.getExecutionPivotImportStrategy(pivotImportMetadata, pivotFormatImport));
    }

    private PivotImportStrategy<ExecutionPivot> getExecutionPivotImportStrategy(final PivotImportMetadata pivotImportMetadata, final PivotFormatImport pivotFormatImport) {
        return new PivotImportStrategy<ExecutionPivot>(){

            @Override
            public Class<ExecutionPivot> getPivotClazz() {
                return ExecutionPivot.class;
            }

            @Override
            public void create(List<ExecutionPivot> entities) {
                ExecutionWorkspacePivotImporterServiceImpl.this.createEntities(entities, "execution", pivotFormatImport, executionPivot -> ExecutionWorkspacePivotImporterServiceImpl.this.createExecution((ExecutionPivot)executionPivot, pivotImportMetadata, pivotFormatImport));
            }
        };
    }

    private void createExecution(ExecutionPivot executionPivot, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) throws IOException, ParseException {
        Long testPlanItemId = executionPivot.getParentType().equals((Object)EntityType.ITERATION) ? this.findTestPlanItemIdForIteration(executionPivot, pivotImportMetadata) : this.findTestPlanItemIdForTestSuite(executionPivot, pivotImportMetadata);
        Map<Long, RawValue> customFields = this.adminPivotConverterService.pivotToCustomFieldValues(executionPivot.getCustomFieldValues(), pivotImportMetadata);
        Execution execution = this.iterationModificationService.addManualExecutionUnsecured(testPlanItemId);
        execution.setDescription(executionPivot.getComment());
        execution.setLastExecutedBy(executionPivot.getLastExecutedBy());
        execution.setLastExecutedOn(this.parseIso8601DateTime(executionPivot.getLastExecutedOn()));
        if (Objects.nonNull(executionPivot.getStatus())) {
            execution.setExecutionStatus(executionPivot.getStatus());
        }
        this.attachmentPivotImportService.addAttachmentsToEntity(executionPivot.getAttachments(), new AttachmentHolderInfo(execution.getId(), execution.getAttachmentList().getId(), EntityType.EXECUTION, executionPivot.getPivotId()), pivotFormatImport, pivotImportMetadata);
        this.privateCustomFieldValueService.initCustomFieldValues((BoundEntity)execution, customFields);
        this.updateExecutionSteps(execution, executionPivot, pivotImportMetadata, pivotFormatImport);
        if (executionPivot.getParentType().equals((Object)EntityType.TEST_SUITE)) {
            TestSuiteInfo testSuiteInfo = pivotImportMetadata.getTestSuiteIdsMap().get(executionPivot.getParentId());
            TestSuite testSuite = (TestSuite)this.entityManager.find(TestSuite.class, (Object)testSuiteInfo.id());
            testSuite.setExecutionStatus(testSuiteInfo.status());
        }
        TestPlanItem testPlanItem = execution.getTestPlanItem();
        User assignee = this.userDao.findUserByLogin(execution.getLastExecutedBy());
        testPlanItem.updateLastExecutionAndAssignee(execution.getLastExecutedOn(), assignee);
    }

    private void updateExecutionSteps(Execution execution, ExecutionPivot executionPivot, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) throws IOException, ParseException {
        List<Long> executionStepIds = execution.getSteps().stream().map(ExecutionStep::getId).toList();
        Map<Long, Long> referencedTestStepIdByExecutionStepIdMap = this.findReferencedTestStepIdForExecutionStepIds(executionStepIds);
        for (ExecutionStepPivot executionStepPivot : executionPivot.getExecutionSteps()) {
            Long testStepId = pivotImportMetadata.getTestStepsIdsMap().get(executionStepPivot.getTestStepId());
            ExecutionStep executionStep = execution.getSteps().stream().filter(step -> ((Long)referencedTestStepIdByExecutionStepIdMap.get(step.getId())).equals(testStepId)).findFirst().orElse(null);
            if (!Objects.nonNull(executionStep)) continue;
            this.updateExecutionStep(execution, executionPivot, executionStepPivot, executionStep, pivotFormatImport, pivotImportMetadata);
        }
    }

    private void updateExecutionStep(Execution execution, ExecutionPivot executionPivot, ExecutionStepPivot executionStepPivot, ExecutionStep executionStep, PivotFormatImport pivotFormatImport, PivotImportMetadata pivotImportMetadata) throws IOException, ParseException {
        Map<Long, RawValue> customFields = this.adminPivotConverterService.pivotToCustomFieldValues(executionStepPivot.getCustomFieldValues(), pivotImportMetadata);
        executionStep.setComment(executionStepPivot.getComment());
        executionStep.setExecutionStatus(executionStepPivot.getStatus());
        executionStep.setLastExecutedBy(executionStepPivot.getLastExecutedBy());
        executionStep.setLastExecutedOn(this.parseIso8601DateTime(executionStepPivot.getLastExecutedOn()));
        this.privateCustomFieldValueService.initCustomFieldValues((BoundEntity)executionStep, customFields);
        this.attachmentPivotImportService.addAttachmentsToEntity(executionStepPivot.getAttachments(), new AttachmentHolderInfo(execution.getId(), executionStep.getAttachmentList().getId(), EntityType.EXECUTION_STEP, executionPivot.getPivotId()), pivotFormatImport, pivotImportMetadata);
    }

    private Long findTestPlanItemIdForIteration(ExecutionPivot execution, PivotImportMetadata pivotImportMetadata) {
        Long squashTestCaseId = pivotImportMetadata.getTestCaseIdsMap().get(execution.getTestCaseId());
        Long squashDatasetId = pivotImportMetadata.getDatasetIdsMap().get(execution.getDatasetId());
        Long squashIterationId = pivotImportMetadata.getIterationIdsMap().get(execution.getParentId());
        SelectConditionStep baseQuery = this.dsl.select((SelectField)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID).from((TableLike)Tables.TEST_PLAN_ITEM).leftJoin((TableLike)Tables.ITERATION).on(Tables.ITERATION.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ID)).where(Tables.TEST_PLAN_ITEM.TCLN_ID.eq((Object)squashTestCaseId)).and(Tables.ITERATION.ITERATION_ID.eq((Object)squashIterationId)).and(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.notIn((Select)this.dsl.select((SelectField)Tables.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID).from((TableLike)Tables.TEST_SUITE_TEST_PLAN_ITEM)));
        if (Objects.nonNull(squashDatasetId)) {
            return (Long)baseQuery.and(Tables.TEST_PLAN_ITEM.DATASET_ID.eq((Object)squashDatasetId)).fetchOneInto(Long.class);
        }
        return (Long)baseQuery.fetchOneInto(Long.class);
    }

    private Long findTestPlanItemIdForTestSuite(ExecutionPivot execution, PivotImportMetadata pivotImportMetadata) {
        Long squashTestCaseId = pivotImportMetadata.getTestCaseIdsMap().get(execution.getTestCaseId());
        Long squashDatasetId = pivotImportMetadata.getDatasetIdsMap().get(execution.getDatasetId());
        Long squashSuiteId = pivotImportMetadata.getTestSuiteIdsMap().get(execution.getParentId()).id();
        SelectConditionStep baseQuery = this.dsl.select((SelectField)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID).from((TableLike)Tables.TEST_PLAN_ITEM).leftJoin((TableLike)Tables.TEST_SUITE_TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.eq((Field)Tables.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID)).where(Tables.TEST_PLAN_ITEM.TCLN_ID.eq((Object)squashTestCaseId)).and(Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID.eq((Object)squashSuiteId));
        if (Objects.nonNull(squashDatasetId)) {
            return (Long)baseQuery.and(Tables.TEST_PLAN_ITEM.DATASET_ID.eq((Object)squashDatasetId)).fetchOneInto(Long.class);
        }
        return (Long)baseQuery.fetchOneInto(Long.class);
    }

    private Map<Long, Long> findReferencedTestStepIdForExecutionStepIds(List<Long> executionStepIds) {
        return this.dsl.select((SelectField)Tables.EXECUTION_STEP.TEST_STEP_ID, (SelectField)Tables.EXECUTION_STEP.EXECUTION_STEP_ID).from((TableLike)Tables.EXECUTION_STEP).where(Tables.EXECUTION_STEP.EXECUTION_STEP_ID.in(executionStepIds)).fetchMap((Field)Tables.EXECUTION_STEP.EXECUTION_STEP_ID, (Field)Tables.EXECUTION_STEP.TEST_STEP_ID);
    }

    private Date parseIso8601DateTime(String date) throws ParseException {
        try {
            return DateUtils.parseIso8601DateTime((String)date);
        }
        catch (ParseException e) {
            LOGGER.error("Error while trying to parse date: {}", new Object[]{date});
            throw e;
        }
    }

    static /* synthetic */ void access$0(ExecutionWorkspacePivotImporterServiceImpl executionWorkspacePivotImporterServiceImpl, CampaignPivot campaignPivot, ProjectIdsReferences projectIdsReferences, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) throws IOException, ParseException {
        executionWorkspacePivotImporterServiceImpl.createCampaign(campaignPivot, projectIdsReferences, pivotImportMetadata, pivotFormatImport);
    }

    static /* synthetic */ void access$1(ExecutionWorkspacePivotImporterServiceImpl executionWorkspacePivotImporterServiceImpl, IterationPivot iterationPivot, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) throws IOException, ParseException {
        executionWorkspacePivotImporterServiceImpl.createIteration(iterationPivot, pivotImportMetadata, pivotFormatImport);
    }

    static /* synthetic */ void access$2(ExecutionWorkspacePivotImporterServiceImpl executionWorkspacePivotImporterServiceImpl, TestSuitePivot testSuitePivot, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) throws IOException {
        executionWorkspacePivotImporterServiceImpl.createTestSuite(testSuitePivot, pivotImportMetadata, pivotFormatImport);
    }

    static /* synthetic */ void access$3(ExecutionWorkspacePivotImporterServiceImpl executionWorkspacePivotImporterServiceImpl, SprintPivot sprintPivot, ProjectIdsReferences projectIdsReferences, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) throws ParseException, IOException {
        executionWorkspacePivotImporterServiceImpl.createSprint(sprintPivot, projectIdsReferences, pivotImportMetadata, pivotFormatImport);
    }

    static /* synthetic */ void access$4(ExecutionWorkspacePivotImporterServiceImpl executionWorkspacePivotImporterServiceImpl, ExecutionPivot executionPivot, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) throws IOException, ParseException {
        executionWorkspacePivotImporterServiceImpl.createExecution(executionPivot, pivotImportMetadata, pivotFormatImport);
    }

    private record TestPlanItemBindingDto(TestCase testCase, Dataset dataset, String testCaseLabel, String testPlanItemPivotId) {
    }
}

