/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectexporter.dao;

import java.util.Iterator;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.jooq.CommonTableExpression;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Record1;
import org.jooq.Record2;
import org.jooq.Record7;
import org.jooq.ResultQuery;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.testcase.TestCaseKind;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.InfoListItem;
import org.squashtest.tm.jooq.domain.tables.TestCaseLibraryNode;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AbstractPivotEntity;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AbstractPivotObject;
import org.squashtest.tm.service.internal.dto.pivotdefinition.CustomFieldValuePivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.testcaseworkspace.TestCasePivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.testcaseworkspace.testcasepart.ActionStepPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.testcaseworkspace.testcasepart.DatasetParamPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.testcaseworkspace.testcasepart.DatasetPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.testcaseworkspace.testcasepart.KeywordPivot;
import org.squashtest.tm.service.internal.pivot.projectexporter.dao.PivotSubElementRecordProcessor;
import org.squashtest.tm.service.pivot.converters.TestCasePivotConverterService;
import org.squashtest.tm.service.pivot.projectexporter.dao.CustomFieldPivotDao;
import org.squashtest.tm.service.pivot.projectexporter.dao.TestCasePivotDao;

@Repository
public class TestCasePivotDaoImpl
implements TestCasePivotDao {
    private static final int BATCH_SIZE = 50;
    private final DSLContext dsl;
    private final CustomFieldPivotDao customFieldPivotDao;
    private final TestCasePivotConverterService testCasePivotConverterService;

    public TestCasePivotDaoImpl(DSLContext dsl, CustomFieldPivotDao customFieldPivotDao, TestCasePivotConverterService testCasePivotConverterService) {
        this.dsl = dsl;
        this.customFieldPivotDao = customFieldPivotDao;
        this.testCasePivotConverterService = testCasePivotConverterService;
    }

    @Override
    public boolean hasTestCase(Long projectId) {
        boolean hasTestCaseInsideProject = this.dsl.fetchExists((Select)this.dsl.selectOne().from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).join((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).where(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)));
        if (hasTestCaseInsideProject) {
            return true;
        }
        return this.hasTestCaseOutsideProject(projectId);
    }

    @Override
    public boolean hasTestCaseOutsideProject(Long projectId) {
        TestCaseLibraryNode calledTcln = Tables.TEST_CASE_LIBRARY_NODE.as("called_tcln_table");
        TestCaseLibraryNode ctpiTcln = Tables.TEST_CASE_LIBRARY_NODE.as("ctpi_tcln_table");
        TestCaseLibraryNode itpiTcln = Tables.TEST_CASE_LIBRARY_NODE.as("itpi_tcln_table");
        return this.dsl.fetchExists((Select)DSL.selectOne().from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).join((TableLike)Tables.TEST_CASE_STEPS).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TEST_CASE_STEPS.TEST_CASE_ID)).join((TableLike)Tables.CALL_TEST_STEP).on(Tables.TEST_CASE_STEPS.STEP_ID.eq((Field)Tables.CALL_TEST_STEP.TEST_STEP_ID)).join((TableLike)calledTcln).on(Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID.eq((Field)calledTcln.TCLN_ID)).where(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).and(calledTcln.PROJECT_ID.notEqual((Object)projectId)).unionAll((Select)DSL.selectOne().from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).join((TableLike)Tables.CAMPAIGN_TEST_PLAN_ITEM).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.CAMPAIGN_TEST_PLAN_ITEM.CAMPAIGN_ID)).join((TableLike)ctpiTcln).on(Tables.CAMPAIGN_TEST_PLAN_ITEM.TEST_CASE_ID.eq((Field)ctpiTcln.TCLN_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).and(ctpiTcln.PROJECT_ID.notEqual((Object)projectId))).unionAll((Select)DSL.selectOne().from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).join((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID)).join((TableLike)Tables.ITERATION).on(Tables.CAMPAIGN_ITERATION.ITERATION_ID.eq((Field)Tables.ITERATION.ITERATION_ID)).join((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.ITERATION.TEST_PLAN_ID)).join((TableLike)itpiTcln).on(Tables.TEST_PLAN_ITEM.TCLN_ID.eq((Field)itpiTcln.TCLN_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).and(itpiTcln.PROJECT_ID.notEqual((Object)projectId))));
    }

    @Override
    public CommonTableExpression<Record1<Long>> getCteTestCaseWithCalledByProjectId(Long projectId) {
        Table allTestCase = DSL.select((SelectField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).where(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).union((Select)DSL.select((SelectField)Tables.CAMPAIGN_TEST_PLAN_ITEM.TEST_CASE_ID).from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).join((TableLike)Tables.CAMPAIGN_TEST_PLAN_ITEM).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.CAMPAIGN_TEST_PLAN_ITEM.CAMPAIGN_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId))).union((Select)DSL.select((SelectField)Tables.TEST_PLAN_ITEM.TCLN_ID).from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).join((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID)).join((TableLike)Tables.ITERATION).on(Tables.ITERATION.ITERATION_ID.eq((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ID)).join((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.ITERATION.TEST_PLAN_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId))).asTable();
        return DSL.name((String)"recursive_cte").fields(TestCasePivotDao.TEST_CASE_CTE_TCLN_ID.getName()).as((ResultQuery)DSL.select((SelectField)allTestCase.field((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).from((TableLike)allTestCase).union((Select)DSL.select((SelectField)Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID).from(DSL.name((String)"recursive_cte")).join((TableLike)Tables.TEST_CASE_STEPS).on(DSL.field(TestCasePivotDao.TEST_CASE_CTE_TCLN_ID).eq((Field)Tables.TEST_CASE_STEPS.TEST_CASE_ID)).join((TableLike)Tables.CALL_TEST_STEP).on(Tables.TEST_CASE_STEPS.STEP_ID.eq((Field)Tables.CALL_TEST_STEP.TEST_STEP_ID))));
    }

    private Table<Record2<Long, String>> getTestCaseCoverageTable(Long projectId) {
        return DSL.select((SelectField)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID, (SelectField)DSL.groupConcat((Field)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID).separator(",").as(TestCasePivotDao.TEST_CASE_COVERAGE_REQ_VERSION_IDS)).from((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).join((TableLike)Tables.REQUIREMENT_VERSION).on(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID.eq((Field)Tables.REQUIREMENT_VERSION.RES_ID)).join((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).on(Tables.REQUIREMENT_VERSION.REQUIREMENT_ID.eq((Field)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID)).where(Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).groupBy(new GroupField[]{Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID}).asTable();
    }

    private Table<Record2<Long, String>> getTestStepCoverageTable(Long projectId) {
        return DSL.select((SelectField)Tables.VERIFYING_STEPS.TEST_STEP_ID, (SelectField)DSL.groupConcat((Field)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID).separator(",").as(TestCasePivotDao.TEST_STEP_COVERAGE_REQ_VERSION_IDS)).from((TableLike)Tables.VERIFYING_STEPS).join((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).on(Tables.VERIFYING_STEPS.REQUIREMENT_VERSION_COVERAGE_ID.eq((Field)Tables.REQUIREMENT_VERSION_COVERAGE.REQUIREMENT_VERSION_COVERAGE_ID)).join((TableLike)Tables.REQUIREMENT_VERSION).on(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID.eq((Field)Tables.REQUIREMENT_VERSION.RES_ID)).join((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).on(Tables.REQUIREMENT_VERSION.REQUIREMENT_ID.eq((Field)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID)).where(Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).groupBy(new GroupField[]{Tables.VERIFYING_STEPS.TEST_STEP_ID}).asTable();
    }

    private Table<?> getKeywordStepTable() {
        return DSL.select((SelectField)Tables.KEYWORD_TEST_STEP.TEST_STEP_ID, (SelectField)Tables.KEYWORD_TEST_STEP.KEYWORD, (SelectField)Tables.KEYWORD_TEST_STEP.DATATABLE, (SelectField)Tables.KEYWORD_TEST_STEP.DOCSTRING, (SelectField)Tables.KEYWORD_TEST_STEP.COMMENT, (SelectField)DSL.groupConcat((Field)DSL.case_().when(Tables.ACTION_WORD_TEXT.TEXT.isNotNull(), (Field)Tables.ACTION_WORD_TEXT.TEXT).otherwise((Field)Tables.ACTION_WORD_PARAMETER_VALUE.VALUE)).orderBy(new OrderField[]{Tables.ACTION_WORD_FRAGMENT.FRAGMENT_ORDER}).separator("").as(TestCasePivotDao.KEYWORD_STEP_VALUE)).from((TableLike)Tables.KEYWORD_TEST_STEP).join((TableLike)Tables.ACTION_WORD_FRAGMENT).on(Tables.ACTION_WORD_FRAGMENT.ACTION_WORD_ID.eq((Field)Tables.KEYWORD_TEST_STEP.ACTION_WORD_ID)).leftJoin((TableLike)Tables.ACTION_WORD_TEXT).on(Tables.ACTION_WORD_FRAGMENT.ACTION_WORD_FRAGMENT_ID.eq((Field)Tables.ACTION_WORD_TEXT.ACTION_WORD_FRAGMENT_ID)).leftJoin((TableLike)Tables.ACTION_WORD_PARAMETER_VALUE).on(Tables.ACTION_WORD_FRAGMENT.ACTION_WORD_FRAGMENT_ID.eq((Field)Tables.ACTION_WORD_PARAMETER_VALUE.ACTION_WORD_FRAGMENT_ID)).groupBy(new GroupField[]{Tables.KEYWORD_TEST_STEP.TEST_STEP_ID}).asTable();
    }

    private ResultQuery<? extends Record> getTestCaseByProjectIdQuery(Long projectId) {
        CommonTableExpression<Record1<Long>> cteTestCaseWithCalled = this.getCteTestCaseWithCalledByProjectId(projectId);
        Table<Record2<Long, String>> testCaseCoverage = this.getTestCaseCoverageTable(projectId);
        Table<Record2<Long, String>> testStepCoverage = this.getTestStepCoverageTable(projectId);
        Table<?> keywordStepTable = this.getKeywordStepTable();
        InfoListItem infoListItemNature = InfoListItem.INFO_LIST_ITEM.as("INFO_LIST_ITEM_NATURE");
        InfoListItem infoListItemType = InfoListItem.INFO_LIST_ITEM.as("INFO_LIST_ITEM_TYPE");
        return this.dsl.withRecursive(new CommonTableExpression[]{cteTestCaseWithCalled}).select(new SelectFieldOrAsterisk[]{Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, Tables.TEST_CASE_LIBRARY_NODE.NAME, Tables.TEST_CASE_LIBRARY_NODE.DESCRIPTION, Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID, Tables.TEST_CASE.REFERENCE, Tables.TEST_CASE.IMPORTANCE, Tables.TEST_CASE.TC_STATUS, infoListItemNature.CODE.as(TestCasePivotDao.TC_NATURE), infoListItemType.CODE.as(TestCasePivotDao.TC_TYPE), Tables.TEST_CASE.PREREQUISITE, Tables.TCLN_RELATIONSHIP.ANCESTOR_ID, DSL.when((Condition)Tables.SCRIPTED_TEST_CASE.TCLN_ID.isNotNull(), (Object)TestCaseKind.GHERKIN.name()).when(Tables.EXPLORATORY_TEST_CASE.TCLN_ID.isNotNull(), (Object)TestCaseKind.EXPLORATORY.name()).when(Tables.KEYWORD_TEST_CASE.TCLN_ID.isNotNull(), (Object)TestCaseKind.KEYWORD.name()).otherwise((Object)TestCaseKind.STANDARD.name()).as(TestCasePivotDao.TC_KIND), Tables.SCRIPTED_TEST_CASE.SCRIPT, Tables.EXPLORATORY_TEST_CASE.CHARTER, Tables.EXPLORATORY_TEST_CASE.SESSION_DURATION, Tables.TEST_CASE_STEPS.STEP_ID, Objects.requireNonNull(keywordStepTable.field((Field)Tables.KEYWORD_TEST_STEP.KEYWORD)).as((Field)Tables.KEYWORD_TEST_STEP.KEYWORD), Objects.requireNonNull(keywordStepTable.field((Field)Tables.KEYWORD_TEST_STEP.DATATABLE)).as((Field)Tables.KEYWORD_TEST_STEP.DATATABLE), Objects.requireNonNull(keywordStepTable.field((Field)Tables.KEYWORD_TEST_STEP.DOCSTRING)).as((Field)Tables.KEYWORD_TEST_STEP.DOCSTRING), Objects.requireNonNull(keywordStepTable.field((Field)Tables.KEYWORD_TEST_STEP.COMMENT)).as((Field)Tables.KEYWORD_TEST_STEP.COMMENT), TestCasePivotDao.KEYWORD_STEP_VALUE, Tables.ACTION_TEST_STEP.TEST_STEP_ID, Tables.ACTION_TEST_STEP.ACTION, Tables.ACTION_TEST_STEP.EXPECTED_RESULT, TestCasePivotDao.TEST_CASE_COVERAGE_REQ_VERSION_IDS, TestCasePivotDao.TEST_STEP_COVERAGE_REQ_VERSION_IDS}).from(cteTestCaseWithCalled).join((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(TestCasePivotDao.TEST_CASE_CTE_TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).join((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).leftJoin((TableLike)infoListItemNature).on(Tables.TEST_CASE.TC_NATURE.eq((Field)infoListItemNature.ITEM_ID)).leftJoin((TableLike)infoListItemType).on(Tables.TEST_CASE.TC_TYPE.eq((Field)infoListItemType.ITEM_ID)).leftJoin((TableLike)Tables.TCLN_RELATIONSHIP).on(Tables.TCLN_RELATIONSHIP.DESCENDANT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).leftJoin((TableLike)Tables.SCRIPTED_TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.SCRIPTED_TEST_CASE.TCLN_ID)).leftJoin((TableLike)Tables.EXPLORATORY_TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.EXPLORATORY_TEST_CASE.TCLN_ID)).leftJoin((TableLike)Tables.KEYWORD_TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.KEYWORD_TEST_CASE.TCLN_ID)).leftJoin((TableLike)Tables.TEST_CASE_STEPS).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_STEPS.TEST_CASE_ID)).leftJoin(keywordStepTable).on(Tables.TEST_CASE_STEPS.STEP_ID.eq(keywordStepTable.field((Field)Tables.KEYWORD_TEST_STEP.TEST_STEP_ID))).leftJoin((TableLike)Tables.ACTION_TEST_STEP).on(Tables.TEST_CASE_STEPS.STEP_ID.eq((Field)Tables.ACTION_TEST_STEP.TEST_STEP_ID)).leftJoin(testStepCoverage).on(Tables.ACTION_TEST_STEP.TEST_STEP_ID.eq(testStepCoverage.field((Field)Tables.VERIFYING_STEPS.TEST_STEP_ID))).leftJoin(testCaseCoverage).on(Tables.TEST_CASE.TCLN_ID.eq(testCaseCoverage.field((Field)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID))).orderBy((OrderField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, (OrderField)Tables.TEST_CASE_STEPS.STEP_ORDER).fetchSize(50);
    }

    private ResultQuery<? extends Record> getDatasetWithParamValueByProjectIdQuery(Long projectId) {
        CommonTableExpression<Record1<Long>> cteTestCaseWithCalled = this.getCteTestCaseWithCalledByProjectId(projectId);
        return this.dsl.withRecursive(new CommonTableExpression[]{cteTestCaseWithCalled}).select(TestCasePivotDao.TEST_CASE_CTE_TCLN_ID, (SelectField)Tables.DATASET.DATASET_ID, (SelectField)Tables.DATASET.NAME, (SelectField)Tables.DATASET_PARAM_VALUE.DATASET_ID, (SelectField)Tables.DATASET_PARAM_VALUE.PARAM_ID, (SelectField)Tables.DATASET_PARAM_VALUE.PARAM_VALUE).from(cteTestCaseWithCalled).join((TableLike)Tables.DATASET).on(TestCasePivotDao.TEST_CASE_CTE_TCLN_ID.eq((Field)Tables.DATASET.TEST_CASE_ID)).leftJoin((TableLike)Tables.DATASET_PARAM_VALUE).on(Tables.DATASET.DATASET_ID.eq((Field)Tables.DATASET_PARAM_VALUE.DATASET_ID)).orderBy(TestCasePivotDao.TEST_CASE_CTE_TCLN_ID, (OrderField)Tables.DATASET.DATASET_ID).fetchSize(50);
    }

    private ResultQuery<? extends Record> getParameterByProjectIdQuery(Long projectId) {
        CommonTableExpression<Record1<Long>> cteTestCaseWithCalled = this.getCteTestCaseWithCalledByProjectId(projectId);
        return this.dsl.withRecursive(new CommonTableExpression[]{cteTestCaseWithCalled}).select(TestCasePivotDao.TEST_CASE_CTE_TCLN_ID, (SelectField)Tables.PARAMETER.PARAM_ID, (SelectField)Tables.PARAMETER.NAME, (SelectField)Tables.PARAMETER.DESCRIPTION).from(cteTestCaseWithCalled).join((TableLike)Tables.PARAMETER).on(TestCasePivotDao.TEST_CASE_CTE_TCLN_ID.eq((Field)Tables.PARAMETER.TEST_CASE_ID)).orderBy(TestCasePivotDao.TEST_CASE_CTE_TCLN_ID, (OrderField)Tables.PARAMETER.PARAM_ORDER).fetchSize(50);
    }

    private ResultQuery<? extends Record> getCustomFieldValueTestCaseByProjectIdQuery(Long projectId) {
        Table<Record7<Long, Long, String, String, String, String, String>> customFieldTable = this.customFieldPivotDao.getCustomFieldValuesTableByProjectIdAndBindableEntity(projectId, BindableEntity.TEST_CASE);
        return this.dsl.select((SelectField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, CustomFieldPivotDao.CFV_TABLE_CF_ID, CustomFieldPivotDao.CFV_TABLE_CF_VALUE).from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).join(customFieldTable).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq(CustomFieldPivotDao.CFV_TABLE_BOUND_ENTITY_ID)).where(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).orderBy((OrderField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).fetchSize(50);
    }

    private ResultQuery<? extends Record> getCustomFieldValueTestStepByProjectIdQuery(Long projectId) {
        Table<Record7<Long, Long, String, String, String, String, String>> customFieldTable = this.customFieldPivotDao.getCustomFieldValuesTableByProjectIdAndBindableEntity(projectId, BindableEntity.TEST_STEP);
        return this.dsl.select((SelectField)Tables.TEST_CASE_STEPS.STEP_ID, CustomFieldPivotDao.CFV_TABLE_CF_ID, CustomFieldPivotDao.CFV_TABLE_CF_VALUE).from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).join((TableLike)Tables.TEST_CASE_STEPS).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TEST_CASE_STEPS.TEST_CASE_ID)).join(customFieldTable).on(Tables.TEST_CASE_STEPS.STEP_ID.eq(CustomFieldPivotDao.CFV_TABLE_BOUND_ENTITY_ID)).where(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).orderBy((OrderField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, (OrderField)Tables.TEST_CASE_STEPS.STEP_ORDER).fetchSize(50);
    }

    @Override
    public void getTestCaseByProjectId(Long projectId, Consumer<TestCasePivot> consumer) {
        ResultQuery<? extends Record> testCaseByProjectIdQuery = this.getTestCaseByProjectIdQuery(projectId);
        ResultQuery<? extends Record> parameterByProjectIdQuery = this.getParameterByProjectIdQuery(projectId);
        ResultQuery<? extends Record> datasetWithParamValueByProjectIdQuery = this.getDatasetWithParamValueByProjectIdQuery(projectId);
        ResultQuery<? extends Record> customFieldValueTestCaseByProjectIdQuery = this.getCustomFieldValueTestCaseByProjectIdQuery(projectId);
        ResultQuery<? extends Record> customFieldValueTestStepByProjectIdQuery = this.getCustomFieldValueTestStepByProjectIdQuery(projectId);
        this.consumeTestCase(projectId, testCaseByProjectIdQuery, parameterByProjectIdQuery, datasetWithParamValueByProjectIdQuery, customFieldValueTestCaseByProjectIdQuery, customFieldValueTestStepByProjectIdQuery, consumer);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T extends Record, P extends Record, D extends Record, CTC extends Record, CTS extends Record> void consumeTestCase(Long projectId, ResultQuery<T> resultTcQuery, ResultQuery<P> resultParamQuery, ResultQuery<D> resultDatasetQuery, ResultQuery<CTC> resultCufTCQuery, ResultQuery<CTS> resultCufTSQuery, Consumer<TestCasePivot> writingToJsonConsumer) {
        Throwable throwable = null;
        Object var9_10 = null;
        try {
            Stream stream = resultTcQuery.fetchStream();
            try {
                block35: {
                    Stream streamParam = resultParamQuery.fetchStream();
                    try {
                        block34: {
                            Stream streamDataset = resultDatasetQuery.fetchStream();
                            try {
                                block33: {
                                    Stream streamTestCaseCuf = resultCufTCQuery.fetchStream();
                                    try {
                                        try (Stream streamStepCuf = resultCufTSQuery.fetchStream();){
                                            Iterator iteratorTestCase = stream.iterator();
                                            AbstractPivotObject testCasePivot = null;
                                            PivotSubElementRecordProcessor<DatasetPivot> datasetHandler = this.getDatasetPivotContainer(streamDataset.iterator());
                                            PivotSubElementRecordProcessor<DatasetParamPivot> datasetParamHandler = this.getDatasetParamPivotContainer(streamParam.iterator());
                                            PivotSubElementRecordProcessor<CustomFieldValuePivot> testCaseCufHandler = this.getCufTestCasePivotContainer(streamTestCaseCuf.iterator());
                                            PivotSubElementRecordProcessor<CustomFieldValuePivot> stepCufHandler = this.getCufTestStepPivotContainer(streamStepCuf.iterator());
                                            while (true) {
                                                if (!iteratorTestCase.hasNext()) {
                                                    if (testCasePivot != null) {
                                                        Long idMainElement = testCasePivot.pivotIdToSquashId();
                                                        ((TestCasePivot)testCasePivot).addAllDatasets(datasetHandler.getPivotSubElements(idMainElement, true));
                                                        ((TestCasePivot)testCasePivot).addAllDatasetParams(datasetParamHandler.getPivotSubElements(idMainElement, true));
                                                        ((AbstractPivotEntity)testCasePivot).addAllCustomFields(testCaseCufHandler.getPivotSubElements(idMainElement, true));
                                                        writingToJsonConsumer.accept((TestCasePivot)testCasePivot);
                                                    }
                                                    break;
                                                }
                                                Record record = (Record)iteratorTestCase.next();
                                                if (testCasePivot == null) {
                                                    testCasePivot = this.testCasePivotConverterService.testCaseRecordToTestCasePivot(record, projectId);
                                                    this.appendStepAndGetStepCustomFieldValue(record, (TestCasePivot)testCasePivot, stepCufHandler);
                                                    continue;
                                                }
                                                Long idMainElement = testCasePivot.pivotIdToSquashId();
                                                if (!idMainElement.equals(record.get((Field)Tables.TEST_CASE.TCLN_ID))) {
                                                    ((TestCasePivot)testCasePivot).addAllDatasets(datasetHandler.getPivotSubElements(idMainElement));
                                                    ((TestCasePivot)testCasePivot).addAllDatasetParams(datasetParamHandler.getPivotSubElements(idMainElement));
                                                    ((AbstractPivotEntity)testCasePivot).addAllCustomFields(testCaseCufHandler.getPivotSubElements(idMainElement));
                                                    writingToJsonConsumer.accept((TestCasePivot)testCasePivot);
                                                    testCasePivot = this.testCasePivotConverterService.testCaseRecordToTestCasePivot(record, projectId);
                                                }
                                                this.appendStepAndGetStepCustomFieldValue(record, (TestCasePivot)testCasePivot, stepCufHandler);
                                            }
                                        }
                                        if (streamTestCaseCuf == null) break block33;
                                    }
                                    catch (Throwable throwable2) {
                                        if (throwable == null) {
                                            throwable = throwable2;
                                        } else if (throwable != throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                        if (streamTestCaseCuf == null) throw throwable;
                                        streamTestCaseCuf.close();
                                        throw throwable;
                                    }
                                    streamTestCaseCuf.close();
                                }
                                if (streamDataset == null) break block34;
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                } else if (throwable != throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                if (streamDataset == null) throw throwable;
                                streamDataset.close();
                                throw throwable;
                            }
                            streamDataset.close();
                        }
                        if (streamParam == null) break block35;
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        if (streamParam == null) throw throwable;
                        streamParam.close();
                        throw throwable;
                    }
                    streamParam.close();
                }
                if (stream == null) return;
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                if (stream == null) throw throwable;
                stream.close();
                throw throwable;
            }
            stream.close();
            return;
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
                throw throwable;
            }
            if (throwable == throwable6) throw throwable;
            throwable.addSuppressed(throwable6);
            throw throwable;
        }
    }

    private void appendStepAndGetStepCustomFieldValue(Record record, TestCasePivot testCasePivot, PivotSubElementRecordProcessor<CustomFieldValuePivot> stepCufHandler) {
        switch (testCasePivot.getTestCaseKind()) {
            case STANDARD: {
                if (record.get((Field)Tables.ACTION_TEST_STEP.TEST_STEP_ID) == null) {
                    return;
                }
                ActionStepPivot actionStepPivot = this.testCasePivotConverterService.actionStepRecordToActionStepPivot(record);
                testCasePivot.addActionSteps(actionStepPivot);
                actionStepPivot.addAllCustomFields(stepCufHandler.getPivotSubElements((Long)record.get((Field)Tables.ACTION_TEST_STEP.TEST_STEP_ID)));
                break;
            }
            case KEYWORD: {
                if (record.get((Field)Tables.TEST_CASE_STEPS.STEP_ID) == null) {
                    return;
                }
                KeywordPivot keywordPivot = this.testCasePivotConverterService.keywordStepRecordToKeywordPivot(record);
                testCasePivot.getKeywordSteps().add(keywordPivot);
                break;
            }
        }
    }

    private <R extends Record> PivotSubElementRecordProcessor<DatasetParamPivot> getDatasetParamPivotContainer(Iterator<R> iterator) {
        return new PivotSubElementRecordProcessor<DatasetParamPivot>(iterator, (Field<Long>)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, (Field<Long>)Tables.PARAMETER.PARAM_ID, this.testCasePivotConverterService::datasetParamRecordToDatasetParamPivot);
    }

    private <R extends Record> PivotSubElementRecordProcessor<CustomFieldValuePivot> getCufTestCasePivotContainer(Iterator<R> iterator) {
        return new PivotSubElementRecordProcessor<CustomFieldValuePivot>(iterator, (Field<Long>)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, CustomFieldPivotDao.CFV_TABLE_CF_ID, this.customFieldPivotDao::cufValueRecordToCufValuePivot);
    }

    private <R extends Record> PivotSubElementRecordProcessor<CustomFieldValuePivot> getCufTestStepPivotContainer(Iterator<R> iterator) {
        return new PivotSubElementRecordProcessor<CustomFieldValuePivot>(iterator, (Field<Long>)Tables.TEST_CASE_STEPS.STEP_ID, CustomFieldPivotDao.CFV_TABLE_CF_ID, this.customFieldPivotDao::cufValueRecordToCufValuePivot);
    }

    private <R extends Record> PivotSubElementRecordProcessor<DatasetPivot> getDatasetPivotContainer(Iterator<R> iterator) {
        return new PivotSubElementRecordProcessor<DatasetPivot>(iterator, (Field<Long>)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, (Field<Long>)Tables.DATASET.DATASET_ID, this.testCasePivotConverterService::datasetRecordToDatasetPivot, this::appendParamValueToDatasetPivot);
    }

    private void appendParamValueToDatasetPivot(DatasetPivot datasetPivot, Record record) {
        DatasetPivot.ParamValue paramValue = this.testCasePivotConverterService.datasetParamValueRecordToDatasetParamValuePivot(record);
        if (paramValue != null) {
            datasetPivot.addParamValues(paramValue);
        }
    }
}

