/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectexporter.dao;

import java.util.Iterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Record7;
import org.jooq.ResultQuery;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AbstractPivotEntity;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AbstractPivotObject;
import org.squashtest.tm.service.internal.dto.pivotdefinition.CustomFieldValuePivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.CampaignPivot;
import org.squashtest.tm.service.internal.pivot.projectexporter.dao.PivotSubElementRecordProcessor;
import org.squashtest.tm.service.pivot.converters.ExecutionWorkspaceConverterService;
import org.squashtest.tm.service.pivot.projectexporter.dao.CampaignPivotDao;
import org.squashtest.tm.service.pivot.projectexporter.dao.CustomFieldPivotDao;

@Repository
public class CampaignPivotDaoImpl
implements CampaignPivotDao {
    private static final int BATCH_SIZE = 50;
    private final DSLContext dsl;
    private final CustomFieldPivotDao customFieldPivotDao;
    private final ExecutionWorkspaceConverterService executionWorkspaceConverterService;

    public CampaignPivotDaoImpl(DSLContext dsl, CustomFieldPivotDao customFieldPivotDao, ExecutionWorkspaceConverterService executionWorkspaceConverterService) {
        this.dsl = dsl;
        this.customFieldPivotDao = customFieldPivotDao;
        this.executionWorkspaceConverterService = executionWorkspaceConverterService;
    }

    @Override
    public boolean hasCampaignByProjectId(Long projectId) {
        return this.dsl.fetchExists((Select)this.dsl.selectOne().from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).join((TableLike)Tables.CAMPAIGN).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.CAMPAIGN.CLN_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)));
    }

    private ResultQuery<? extends Record> getCustomFieldValueCampaignByProjectIdQuery(Long projectId) {
        Table<Record7<Long, Long, String, String, String, String, String>> customFieldTable = this.customFieldPivotDao.getCustomFieldValuesTableByProjectIdAndBindableEntity(projectId, BindableEntity.CAMPAIGN);
        return this.dsl.select((SelectField)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID, CustomFieldPivotDao.CFV_TABLE_CF_ID, CustomFieldPivotDao.CFV_TABLE_CF_VALUE).from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).join(customFieldTable).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq(CustomFieldPivotDao.CFV_TABLE_BOUND_ENTITY_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).orderBy((OrderField)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID).fetchSize(50);
    }

    @Override
    public void getCampaignByProjectId(Long projectId, Consumer<CampaignPivot> objectConsumer) {
        ResultQuery<? extends Record> cufCampaignQuery = this.getCustomFieldValueCampaignByProjectIdQuery(projectId);
        ResultQuery campaignQuery = this.dsl.select((SelectField)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID, (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.NAME, (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.DESCRIPTION, (SelectField)Tables.CAMPAIGN.REFERENCE, (SelectField)Tables.CAMPAIGN.CAMPAIGN_STATUS, (SelectField)Tables.CAMPAIGN.ACTUAL_START_AUTO, (SelectField)Tables.CAMPAIGN.ACTUAL_END_AUTO, (SelectField)Tables.CAMPAIGN.ACTUAL_START_DATE, (SelectField)Tables.CAMPAIGN.ACTUAL_END_DATE, (SelectField)Tables.CAMPAIGN.SCHEDULED_START_DATE, (SelectField)Tables.CAMPAIGN.SCHEDULED_END_DATE, (SelectField)Tables.CLN_RELATIONSHIP.ANCESTOR_ID, (SelectField)Tables.CAMPAIGN_TEST_PLAN_ITEM.CTPI_ID, (SelectField)Tables.CAMPAIGN_TEST_PLAN_ITEM.TEST_CASE_ID, (SelectField)Tables.CAMPAIGN_TEST_PLAN_ITEM.DATASET_ID).from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).join((TableLike)Tables.CAMPAIGN).on(Tables.CAMPAIGN.CLN_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).leftJoin((TableLike)Tables.CLN_RELATIONSHIP).on(Tables.CAMPAIGN.CLN_ID.eq((Field)Tables.CLN_RELATIONSHIP.DESCENDANT_ID)).leftJoin((TableLike)Tables.CAMPAIGN_TEST_PLAN_ITEM).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.CAMPAIGN_TEST_PLAN_ITEM.CAMPAIGN_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).orderBy((OrderField)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID, (OrderField)Tables.CAMPAIGN_TEST_PLAN_ITEM.TEST_PLAN_ORDER).fetchSize(50);
        this.consumeCampaigns(campaignQuery, cufCampaignQuery, objectConsumer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <C extends Record, T extends Record> void consumeCampaigns(ResultQuery<C> campaignQuery, ResultQuery<T> campaignCufQuery, Consumer<CampaignPivot> writingToJsonConsumer) {
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            Stream campaignStream = campaignQuery.fetchStream();
            try {
                try (Stream cufStream = campaignCufQuery.fetchStream();){
                    Iterator campaignIterator = campaignStream.iterator();
                    AbstractPivotObject campaignPivot = null;
                    PivotSubElementRecordProcessor<CustomFieldValuePivot> cufHandler = this.getCufPivotContainer(cufStream.iterator());
                    while (campaignIterator.hasNext()) {
                        Record record = (Record)campaignIterator.next();
                        if (campaignPivot == null) {
                            campaignPivot = this.executionWorkspaceConverterService.campaignRecordToCampaignPivot(record);
                            this.appendTestPlanItemToCampaignPivot((CampaignPivot)campaignPivot, record);
                            continue;
                        }
                        Long mainEntityId = campaignPivot.pivotIdToSquashId();
                        if (!mainEntityId.equals(record.get((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID))) {
                            ((AbstractPivotEntity)campaignPivot).addAllCustomFields(cufHandler.getPivotSubElements(mainEntityId));
                            writingToJsonConsumer.accept((CampaignPivot)campaignPivot);
                            campaignPivot = this.executionWorkspaceConverterService.campaignRecordToCampaignPivot(record);
                            this.appendTestPlanItemToCampaignPivot((CampaignPivot)campaignPivot, record);
                            continue;
                        }
                        this.appendTestPlanItemToCampaignPivot((CampaignPivot)campaignPivot, record);
                    }
                    if (campaignPivot != null) {
                        Long idMainElement = campaignPivot.pivotIdToSquashId();
                        ((AbstractPivotEntity)campaignPivot).addAllCustomFields(cufHandler.getPivotSubElements(idMainElement, true));
                        writingToJsonConsumer.accept((CampaignPivot)campaignPivot);
                    }
                }
                if (campaignStream == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (campaignStream == null) throw throwable;
                campaignStream.close();
                throw throwable;
            }
            campaignStream.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private void appendTestPlanItemToCampaignPivot(CampaignPivot campaignPivot, Record record) {
        if (record.get((Field)Tables.CAMPAIGN_TEST_PLAN_ITEM.TEST_CASE_ID) != null) {
            campaignPivot.addTestPlanItem(this.executionWorkspaceConverterService.campaignTestPlanItemRecordToTestPlanItemPivot(record));
        }
    }

    private <R extends Record> PivotSubElementRecordProcessor<CustomFieldValuePivot> getCufPivotContainer(Iterator<R> iterator) {
        return new PivotSubElementRecordProcessor<CustomFieldValuePivot>(iterator, (Field<Long>)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID, CustomFieldPivotDao.CFV_TABLE_CF_ID, this.customFieldPivotDao::cufValueRecordToCufValuePivot);
    }
}

